#ifndef ALTLIGHT_H
#define ALTLIGHT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altLight.h 748 2007-12-07 06:11:45Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altLight.h
 * \brief   Light
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altDX.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Light
///
class altLight : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altLight();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altLight();

  ///
  /// \brief  Set light
  ///
  /// \param  vecDirection  [I ] Direction
  /// \param  nType         [I ] Type
  /// \param  oDiffuse      [I ] Diffuse Color
  /// \param  oSpecular     [I ] Specular Color
  /// \param  fRange        [I ] Range
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetLight(const D3DXVECTOR3 & vecDirection, const D3DLIGHTTYPE nType, const D3DCOLORVALUE & oDiffuse, const D3DCOLORVALUE & oSpecular, const FLOAT fRange);

private:
  D3DLIGHT9 m_oLight;
};

#endif
#endif
