#ifndef ALTXFILE_H
#define ALTXFILE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altXFile.h 758 2007-12-13 05:38:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altXFile.h
 * \brief   DirectX X File
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>
#include <altBase/altBase.h>

#ifdef ALT_WIN
#include <altDX/altDX.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
struct XFILE
{
	LPD3DXMESH            lpMesh;
	DWORD                 NumMaterial;
	D3DMATERIAL9 *        Mat;
	LPDIRECT3DTEXTURE9 *  Tex;
};

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
class altXFile : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altXFile();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altXFile();

  ///
  /// \brief  Load X File
  ///
  /// \param  sFileName   [I ] File Name
  /// \param  dwOptions   [I ] Options
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Load(const altStr & sFileName, const DWORD dwOptions = D3DXMESH_MANAGED);

  ///
  /// \brief  Release X File
  ///
  LIBALT_API void Release();
  
  ///
  /// \brief  Draw X File
  ///
  LIBALT_API void Draw();

  ///
  /// \brief  Draw X File Color
  ///
  LIBALT_API void DrawColor(int ColorNo);

private:
  struct XFILE *      m_pXFile;
};

#endif
#endif
