#ifndef ALTEXTERNALIZABLE_H
#define ALTEXTERNALIZABLE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altExternalizable.h 710 2007-11-22 18:14:39Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altExternalizable.h
 * \brief   Externalizable
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altMisc/altDataStream.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Data Stream
///
class altExternalizable : public altBase
{
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altExternalizable();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altExternalizable();

  ///
  /// \brief  Write
  ///
  /// \param  oDataStream [ O] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Write(altDataStream & oDataStream) const = 0;
  
  ///
  /// \brief  Read
  ///
  /// \param  oDataStream [I ] Data stream
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t virtual Read(altDataStream & oDataStream) const = 0;
};

#endif
