#ifndef ALTMD5_H
#define ALTMD5_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMD5.h 498 2007-11-07 22:15:07Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altMD5.h
 * \brief   MD5
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

#ifdef ALT_WIN
#include <altNet/openssl/md5.h>
#endif
#ifdef ALT_LINUX
#include <openssl/md5.h>
#endif

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  MD5
///
class altMD5 : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altMD5();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altMD5();

  ///
  /// \brief  Update MD5 digest
  ///
  /// \param  pData [I ] Data
  /// \param  nSize [I ] Data size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Update(const altUChar * pData, const altUInt nSize);

  ///
  /// \brief  To string
  ///
  /// \return string
  ///
  LIBALT_API altStr ToStr();

  altUChar  m_aHash[MD5_DIGEST_LENGTH]; ///< SHA1 digest
};

#endif
