#ifndef ALTMISCUTIL_H
#define ALTMISCUTIL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMiscUtil.h 511 2007-11-08 09:06:16Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altMiscUtil.h
 * \brief   Utility Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Function Declare
 *----------------------------------------------------------------*/
///
/// \brief  Hex to DWORD
///
/// \param  szHex   [I ] Hex string
///
/// \return DWORD value
///
LIBALT_API DWORD altHexToDWORD(const altChar * szHex);

///
/// \brief  fputs
///
/// \param  szStr [I ] String
/// \param  pFile [I ] FILE pointer
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_WRITE   write error
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altFPuts(const altChar * szData, FILE * pFile);

#endif
