#ifndef ALTTIMER_H
#define ALTTIMER_H
/*--------------------------------------------------------------------------*

   Alternative Library

  $Id: altTimer.h 366 2007-10-10 23:03:43Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTimer.h
 * \brief   Timer
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStatus.h>
#include <altBase/altLog.h>

#ifdef ALT_LINUX
  #include <sys/time.h>
  #include <signal.h>
  #include <unistd.h>
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef void (* altTimerCallBack)(int);

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Timer
///
class altTimer : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTimer();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altTimer();

  ///
  /// \brief  Start Timer
  ///
  /// \param  nDelay    [I ] Timer Interval
  /// \return pCallBack [I ] Call Back Function
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Start(const altUInt nDelay, altTimerCallBack pCallBack);

  ///
  /// \brief  Stop Timer
  ///
  /// \return ALT_S_SUCCESS
  ///
  LIBALT_API alt_t Stop();

private:
#ifdef ALT_WIN
  altUInt m_nTimerID;   ///< Timer ID
#endif
#ifdef ALT_LINUX
  struct sigaction  m_oAct;
  struct sigaction  m_oOldAct;
  struct itimerval  m_oValue;
  struct itimerval  m_oOldValue;
  altTimerCallBack  m_pTimerCallBack;
#endif
  altBool m_bStarted;   ///< Started
};

#endif
