#ifndef ALTSSLSERVER_H
#define ALTSSLSERVER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLServer.h 794 2008-01-21 06:44:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLServer.h
 * \brief   SSL Network Server
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETConnectionManager.h>
#include <altNet/altSSLAcceptor.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUncopyable.h>

#include <map>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define aiSSLServer altSSLServer::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altInt, altSSLAcceptor *> altSSLAcceptorMap;   ///< SSL Acceptor Map

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SSL Server Class
///
class altSSLServer : public altSingleton<altSSLServer>, protected altSyncThread
{
friend class altSingleton<altSSLServer>;
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSSLServer();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSSLServer();

public:
  ///
  /// \brief  Open Port
  ///
  /// \param  nPort               [I ] Port NO
  /// \param  pAcceptCallBack     [I ] Accept Call Back Function
  /// \param  pDisconnectCallBack [I ] Disconnected Call Back Function
  /// \param  nThreadCount        [I ] Request Thread Count
  /// \param  nListenQueSize      [I ] Listen Que Size
  /// \param  nAcceptThreadCount  [I ] Accept Thread Count
  /// \param  nSSLVersion         [I ] SSL Version Number(ALT_SSL_V23 or ALT_SSL_V2 or ALT_SSL_V3 or ALT_TSL_V1)
  ///
  /// \return ALT_S_SUCCESS     success
  /// \return ALT_E_WSASTARTUP  start up error
  /// \return ALT_E_WSAVERSION  WinSock version error
  /// \return ALT_E_NOMEM       Out Of Memory error
  /// \return ALT_E_INVAL       Invalid Paramter
  ///
  LIBALT_API alt_t OpenPort(const altInt nPort, const altNETReceiveCallBack pReceiveCallBack, const altNETAcceptCallBack pAcceptCallBack = NULL, const altNETDisconnectCallBackFunc pDisconnectCallBack = NULL, const altUInt nThreadCount = 10, const altInt nListenQueSize = 5, const altUInt nAcceptThreadCount = 1, const altByte nSSLVersion = ALT_SSL_V3);

  ///
  /// \brief  Close Port
  ///
  /// \param  nPort   [I ] Port NO
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t ClosePort(const altInt nPort);

  ///
  /// \brief  Close All Port
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t ClosePortAll();

  ///
  /// \brief  Get Instance
  ///
  /// \return Instance
  ///
  LIBALT_API static altSSLServer & GetInstance();

private:
  altSSLAcceptorMap m_oAcceptorMap;  ///< SSL Acceptor Map
};

#endif  //ALTSSLSERVER_H
