#ifndef altSSLSyncThread_H
#define altSSLSyncThread_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLSyncThread.h 603 2007-11-15 01:18:12Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLSyncThread.h
 * \brief   SSL Synchronize Thread Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>
#include <vector>

//--------------------------------------------------------------------
// Type Definition
//--------------------------------------------------------------------
typedef std::vector<altSyncThread *> altSyncThreadContainer;

//--------------------------------------------------------------------
// Class Definition
//--------------------------------------------------------------------
///
/// \brief	 SSL Synchronize Class
///
class altSSLSyncThread
{
public:
	///
	/// \brief Constructor
	///
	altSSLSyncThread();

	///
	/// \brief Destructor
	///
	virtual ~altSSLSyncThread();

  ///
  /// \brief	Initialize
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
	static alt_t InitLock();

	///
	/// \brief	Lock Call Back Function
	///
	static void LockingCallback(altInt nMode, altInt nType, const altChar * pFile, altInt nLine);

	///
	/// \brief	end of using
	///
	/// \return ALT_S_SUCCESS	  Success
	///
	static alt_t End();

private:
  static altBool                bInitDone;
  static altSyncThreadContainer oSyncThreads;
};

#endif //altSSLSyncThread_H

