## チャンネルで独自に新しいカーネルをサポートする
AlterISO3ではカーネルに関する処理が大幅に変更され、チャンネルのみで独自にカーネルを追加することができるようになりました。  
ここではAlterISO本体のコードを変更せずにチャンネルだけで独自のカーネルを使用する方法を解説します。  

## 追加したいカーネルの情報を把握する
カーネルを追加するにはいくつかの設定ファイルを編集する必要があります。  
それぞれの設定ファイルの詳細については[KERNEL.md](./KERNEL.md)を参考にして下さい。  
  
カーネルを設定するには以下の情報が必要です。
- カーネルのパッケージ名
- （AURからビルドする以外は）そのカーネルのパッケージがホストされているリポジトリの情報
  - リポジトリ名
  - 公開鍵
  - サーバのURL
- `mkinitcpio`によって`/boot`以下に作成されるカーネルのファイル名
- `mkinitcpio -p`で指定するプロファイル名
- カーネルの略称（他のカーネルと重複しない名前ならなんでもOK）

## カーネル設定ファイルを作成する
もしチャンネルディレクトリに`kernel-<arch>`というファイルがある場合は`/system/kernel-<arch>`の代わりにそのファイルが参照されます。  
カーネルの情報を`/system/kernel-<arch>`を参考に作成して下さい。その後作成した設定ファイルをチャンネル内に配置して下さい。  
ビルドスクリプトは、`/system/kernel-<arch>`の代わりにチャンネル内の設定ファイルを使用します。  
その設定ファイル内の記述されているカーネルしか使用できなくなるので、`/system/kernel-<arch>`で既に設定されているカーネルも記述して下さい。  

## カーネルリストを作成する
そのチャンネルが使用可能なカーネルの一覧を書いたファイル（`kernel_list-<arch>`）にカーネル設定ファイルで指定したカーネル名を追記して下さい。  
カーネルリストに書かれていないとビルドに使用できません。逆に言えば、一時的にカーネルを無効化したい場合はカーネル設定ファイルを編集するのではなくカーネルリストでコメントアウトして下さい。

## カーネルのパッケージファイルを作成する
`packages.<arch>/kernel/<kernel_name>`ディレクトリを作成して下さい。このディレクトリ内のパッケージはそのカーネルが指定された場合のみインストールされます。  
デフォルトで使用可能な`zen`や`lts`などのカーネルパッケージは`share`チャンネルで指定されています。  
参考: [shareチャンネルのlinux-ltsのパッケージファイル1](https://github.com/FascodeNet/alterlinux/blob/dev/channels/share/packages.x86_64/kernel/lts.x86_64)

## pacman-<arch>.confにリポジトリを追加する
チャンネルの`pacman-<arch>.conf`にそのカーネルのパッケージが存在しているリポジトリの情報を追記して下さい。  
AURから直接ビルドすることもできますが、ビルドに非常に時間がかかるのでおすすめできません。  
リポジトリによっては公開鍵を追加する必要があります。  

## config.<arch>でデフォルトカーネルを設定する
`config.<arch>`内の`defaultkernel`変数でユーザーがカーネルを指定しなかった場合のデフォルトを指定できます。  
`releng`チャンネルでは`core`カーネルがデフォルトに設定されています。  
参考: [https://github.com/FascodeNet/alterlinux/blob/dev/channels/releng/config.any](https://github.com/FascodeNet/alterlinux/blob/dev/channels/releng/config.any)
