/*
 * Decompiled with CFR 0.152.
 */
package org.amritaj.expander.impl;

import java.util.Collection;
import org.amritaj.AttrArray;
import org.amritaj.config.AmritaJConfig;
import org.amritaj.html.HtmlNode;

public abstract class HtmlTagExpander {
    private HtmlNode htmlNode = null;
    private boolean closed = false;

    public HtmlTagExpander(HtmlNode htmlNode) {
        this.htmlNode = htmlNode;
    }

    protected abstract boolean isExpandStartClose();

    protected String expandOpenTag() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.htmlNode.isPutStartQName()) {
            stringBuilder.append("<" + this.htmlNode.getStartQName());
            stringBuilder.append(this.makeAttribute());
            if (this.isExpandStartClose()) {
                this.closed = true;
                stringBuilder.append("/");
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    protected String expandCloseTag() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.closed && this.htmlNode.isPutEndQName()) {
            stringBuilder.append("</" + this.htmlNode.getEndQName() + ">");
        }
        return stringBuilder.toString();
    }

    protected String makeAttrAttribute(AttrArray attrArray) {
        return attrArray.toString();
    }

    protected String makeAttribute() {
        return this.makeAttribute(new AttrArray());
    }

    protected String makeAttribute(AttrArray attrArray) {
        Collection<String> collection = attrArray.attributeList();
        AmritaJConfig amritaJConfig = new AmritaJConfig();
        collection.add(amritaJConfig.getHandleString());
        return this.htmlNode.attributeString(collection);
    }
}

