/*
 * Decompiled with CFR 0.152.
 */
package org.amritaj;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.amritaj.AbstractTemplate;
import org.amritaj.exception.AmritaJRuntimeException;
import org.amritaj.html.AmritajHtmlHandler;
import org.amritaj.html.Node;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class TemplateFile
extends AbstractTemplate {
    private File templateFile = null;
    private InputStream inputStream = null;
    private String encode = "UTF-8";

    public TemplateFile(String string) {
        this.templateFile = new File(string);
    }

    public TemplateFile(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void expand(Writer writer, Object object) {
        if (this.templateFile != null) {
            this.fileExpand(writer, object);
        } else if (this.inputStream != null) {
            this.inputStreamExpand(writer, object);
        } else {
            throw new AmritaJRuntimeException("no initialized.");
        }
    }

    public void expand(OutputStream outputStream, Object object) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.expand(printWriter, object);
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileExpand(Writer writer, Object object) {
        SAXParser sAXParser = new SAXParser(this.getConfig());
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.templateFile), this.encode);
            try {
                AmritajHtmlHandler amritajHtmlHandler = new AmritajHtmlHandler();
                sAXParser.setContentHandler((ContentHandler)amritajHtmlHandler);
                sAXParser.parse(new InputSource(inputStreamReader));
                Node node = amritajHtmlHandler.getRootNode();
                writer.write(node.expand(object));
            }
            finally {
                if (inputStreamReader != null) {
                    ((Reader)inputStreamReader).close();
                }
            }
        }
        catch (Exception exception) {
            throw new AmritaJRuntimeException(exception);
        }
    }

    private void inputStreamExpand(Writer writer, Object object) {
        SAXParser sAXParser = new SAXParser(this.getConfig());
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, this.encode);
            AmritajHtmlHandler amritajHtmlHandler = new AmritajHtmlHandler();
            sAXParser.setContentHandler((ContentHandler)amritajHtmlHandler);
            sAXParser.parse(new InputSource(inputStreamReader));
            Node node = amritajHtmlHandler.getRootNode();
            writer.write(node.expand(object));
        }
        catch (Exception exception) {
            throw new AmritaJRuntimeException(exception);
        }
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String string) {
        this.encode = string;
    }
}

