/*
 * Decompiled with CFR 0.152.
 */
package org.amritaj.script.impl;

import org.amritaj.config.AmritaJConfig;
import org.amritaj.exception.AmritaJRuntimeException;
import org.amritaj.script.impl.J2SDK6Eval;
import org.amritaj.script.impl.RhinoEval;
import org.amritaj.script.impl.ScriptEval;

public class ScriptEvalFactory {
    private static final String J2SDK16_JAVAX_SCRIPT = "javax.script.ScriptEngineManager";
    private static final String RHINO_SCRIPT = "org.mozilla.javascript.Context";

    public static ScriptEval createScriptEval(String string) {
        AmritaJConfig amritaJConfig = new AmritaJConfig();
        if (!amritaJConfig.isEnforceRhino()) {
            try {
                Class<?> clazz = Class.forName(J2SDK16_JAVAX_SCRIPT);
                return new J2SDK6Eval(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Class<?> clazz = Class.forName(RHINO_SCRIPT);
            return new RhinoEval();
        }
        catch (Exception exception) {
            throw new AmritaJRuntimeException("No support script.");
        }
    }
}

