/*** X_MATHOP.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_arth(ctree *ptr){				/*** TT-Lang: A = X+Y | X-Y | X*Y | X/Y | X%Y | X**Y ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans;			dtab	*a,*x,*y;
tint	alen,mul,div;

dtab	*ma,*mx,*my;	int		xi,xj,xs,xv,yi,yj,ys,yv;		// Matrix Parameter
dtab	*ex[3],*ey[3];											// Vector Parameter

/* Debug & PreCheck */					chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr); chk_vtype(x,"SIDPA",0);	/* L=>0 */
	if( x->type=='A' && !ismatx(x) ){ flag_exerr=MatxAttri; return NULL; }
	y = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr); chk_vtype(y,"SIDPA",1);	/* R=>1 */
	if( y->type=='A' && !ismatx(y) ){ flag_exerr=MatxAttri; return NULL; }
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Matrix Jump */
	if( ismatx(x) || ismatx(y) ){ goto MATX_CODE; }

/* Do ADD()!! - Value & String			A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op=='+' ){
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=cint(x)+cint(y); return ans; }
		if( isdptr(x)    && isdptr(y)    ){ a->type='D'; a->dval=cdbl(x)+cdbl(y); return ans; }

		if( isnull(x)    && isnull(y)    ){ null_dtab(a) ; return ans; }
		if( x->type=='S' && isnull(y)    ){ cpy_dtab(a,x); return ans; }
		if( isnull(x)    && y->type=='S' ){ cpy_dtab(a,y); return ans; }

		if( x->type=='S' && y->type=='S' ){ a->type='S'; a->str=X_SCAT(x->str,y->str); return ans; }
		if( x->type=='S' /*'I'|'D'|'P'*/ ){ a->type='S'; alen=strlen2(x->str)+1; a->str=X_ATOM(alen+1);
			strcpy2(a->str,x->str);
			(a->str)[alen-1] = (char)(cint(y)&0xFF);
			(a->str)[alen+0] = '\0';						return ans; }
		if( /*'I'|'D'|'P'*/ y->type=='S' ){ a->type='S'; alen=1+strlen2(y->str); a->str=X_ATOM(alen+1);
			(a->str)[     0] = (char)(cint(x)&0xFF);
			(a->str)[     1] = '\0';
			strcat2(a->str,y->str);							return ans; }
	}
/* Do SUB()!! - Value & String			A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op=='-' ){
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=cint(x)-cint(y); return ans; }
		if( isdptr(x)    && isdptr(y)    ){ a->type='D'; a->dval=cdbl(x)-cdbl(y); return ans; }
	}
/* Do MUL()!! - Value & String			A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op=='*' ){
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=cint(x)*cint(y); return ans; }
		if( isdptr(x)    && isdptr(y)    ){ a->type='D'; a->dval=cdbl(x)*cdbl(y); return ans; }
		if( x->type=='S' && isdptr(y)    ){ a->type='S';
			if( (mul=cint(y))<0 ){ flag_exerr=NgARGVAL; last_ct=ptr->r; return NULL; }
			alen=strlen2(x->str)*mul; a->str=X_ATOM(alen+1); a->str[0]='\0';
			while( mul-- ){ strcat2(a->str,x->str); }		return ans;
		}
	}
/* Do DIV()!! - Value & String			A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op=='/' ){
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=cint(x)/cint(y); return ans; }
		if( isdptr(x)    && isdptr(y)    ){ a->type='D'; a->dval=cdbl(x)/cdbl(y); return ans; }
		if( x->type=='S' && isdptr(y)    ){ a->type='S';
			if( (div=cint(y))<0 ){ flag_exerr=NgARGVAL; last_ct=ptr->r; return NULL; }
			alen=strlen2(x->str)/div; a->str=X_ATOM(alen+1); a->str[0]='\0';
			strncat2(a->str,x->str,alen);					return ans;
		}
	}
/* Do MOD()!! - Value					A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op=='%' ){
		if( x->type=='S' || y->type=='S' ) goto MOD_ERROR;
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=(tint)fmod(cint(x),cint(y)); return ans; }
		else                              { a->type='D'; a->dval=(tdbl)fmod(cdbl(x),cdbl(y)); return ans; }
MOD_ERROR:;
	}
/* Do POW()!! - Value					A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( op==POW ){
		if( x->type=='S' || y->type=='S' ) goto POW_ERROR;
		if( isiptr(x)    && isiptr(y)    ){ a->type='I'; a->ival=(tint)pow (cdbl(x),cdbl(y)); return ans; }
		else                              { a->type='D'; a->dval=(tdbl)pow (cdbl(x),cdbl(y)); return ans; }
POW_ERROR:;
	}
/* Assert!! */
	return NULL;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
MATX_CODE:
	xi = matx_getrow(x); xj = matx_getcol(x);
	yi = matx_getrow(y); yj = matx_getcol(y);
	xs = ( xi==0 && xj==0 );			// Scalar Flag for X (T/F)
	ys = ( yi==0 && yj==0 );			// Scalar Flag for Y (T/F)
	xv = ( xi==0 && xj!=0 );			// Vector Flag for X (T/F)
	yv = ( yi==0 && yj!=0 );			// Vector Flag for Y (T/F)

	if( op==SOP ){ goto VECT_SOP ; }	// N次元ベクトルの内積
	if( op==VOP ){ goto VECT_VOP ; }	// 3次元ベクトルの外積
	if( op=='@' ){ goto MATX_MULT; }	// 行列の積
	goto MATX_ADAM;						// 行列のアダマール演算

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
VECT_SOP:								// N次元ベクトルの内積
	if( xv && yv && xj==yj ){;}			// OK条件 = {ベクトル(同サイズ) OP ベクトル(同サイズ)}
	else{
		flag_exerr=MatxCombi; epar[0]=xi,epar[1]=xj,epar[2]=yi,epar[3]=yj; return NULL;
	}

	ma=a; ma->type='I';
	for( int j=0 ; j<xj ; j++ ){
		mx = di2p_dtab(x,j);
		my = di2p_dtab(y,j);
		if( !isdef (mx) ){ flag_exerr=MatxUndef; epar[0]=INVA; epar[1]=j; return NULL; }
		if( !ismatv(mx) ){ flag_exerr=MatxValue; epar[0]=INVA; epar[1]=j; return NULL; }
		if( !isdef (my) ){ flag_exerr=MatxUndef; epar[0]=INVA; epar[1]=j; return NULL; }
		if( !ismatv(my) ){ flag_exerr=MatxValue; epar[0]=INVA; epar[1]=j; return NULL; }
		if( ma->type=='I' ){
			if( isiptr(mx) && isiptr(my) ){		// I += I * I
				ma->ival += cint(mx)*cint(my);
			}
			else{								// D += V * V ( D <- I )
				ma->type='D'; ma->dval=ma->ival; ma->ival=0;
				ma->dval += cdbl(mx)*cdbl(my);
			}
		}
		else{									// D += V * V
				ma->dval += cdbl(mx)*cdbl(my);
		}
	}
	return ans;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
VECT_VOP:								// 3次元ベクトルの外積
	if( xv && yv && xj==3 && yj==3 ){;}	// OK条件 = {3次元ベクトル OP 3次元ベクトル}
	else{
		flag_exerr=MatxCombi; epar[0]=xi,epar[1]=xj,epar[2]=yi,epar[3]=yj; return NULL;
	}

	for( int t=0 ; t<3 ; t++ ){
		ex[t] = mx = di2p_dtab(x,t);
		ey[t] = my = di2p_dtab(y,t);
		if( !isdef (mx) ){ flag_exerr=MatxUndef; epar[0]=INVA; epar[1]=t; return NULL; }
		if( !ismatv(mx) ){ flag_exerr=MatxValue; epar[0]=INVA; epar[1]=t; return NULL; }
		if( !isdef (my) ){ flag_exerr=MatxUndef; epar[0]=INVA; epar[1]=t; return NULL; }
		if( !ismatv(my) ){ flag_exerr=MatxValue; epar[0]=INVA; epar[1]=t; return NULL; }
	}
	for( int t=0 ; t<3 ; t++ ){
		ma = di2p_dtab(a,t);
		if( isiptr(ex[(t+1)%3]) && isiptr(ex[(t+2)%3]) && isiptr(ey[(t+1)%3]) && isiptr(ey[(t+2)%3]) ){	// I = I*I-I*I
			ma->type='I';
			ma->ival = cint(ex[(t+1)%3]) * cint(ey[(t+2)%3]) - cint(ex[(t+2)%3]) * cint(ey[(t+1)%3]) ;
		}
		else{																							// D = V*V-V*V
			ma->type='D';
			ma->dval = cdbl(ex[(t+1)%3]) * cdbl(ey[(t+2)%3]) - cdbl(ex[(t+2)%3]) * cdbl(ey[(t+1)%3]) ;
		}
	}
	return ans;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
MATX_MULT:								// 行列の積
	if( !xs && !ys && xj==yi ){;}		// OK条件 = {行列 OP 行列}、かつ、{列数 == 行数}
	else{
		if( !xs && yv && xj==1 && yi==0 ) goto _MULT_OK;
		flag_exerr=MatxCombi; epar[0]=xi,epar[1]=xj,epar[2]=yi,epar[3]=yj; return NULL;
_MULT_OK:;
	}

	for( int i=0 ; i<xi || (i==0&&xv) ; i++ ){					/* Matrix|Vector */
		for( int j=0 ; j<yj ; j++ ){
			if( xv || xi==1 ){			// X=Vector|1行Matrix -> A=Scalar|Vecotr
				ma = ( yj==1 ? a : di2p_dtab(a,j) ); ma->type='I'; ma->ival=0;
			}
			else{						// X=Matrix           -> A=Matrix
				ma =               dm2p_dtab(a,i,j); ma->type='I'; ma->ival=0;
			}
			for( int t=0 ; t<xj ; t++ ){
				mx = ( xv ? di2p_dtab(x,t) : dm2p_dtab(x,i,t) );
				my = ( yv ? di2p_dtab(y,j) : dm2p_dtab(y,t,j) );
				if( !isdef (mx) ){ flag_exerr=MatxUndef; epar[0]=(xv?INVA:i); epar[1]=t; return NULL; }
				if( !ismatv(mx) ){ flag_exerr=MatxValue; epar[0]=(xv?INVA:i); epar[1]=t; return NULL; }
				if( !isdef (my) ){ flag_exerr=MatxUndef; epar[0]=(yv?INVA:t); epar[1]=j; return NULL; }
				if( !ismatv(my) ){ flag_exerr=MatxValue; epar[0]=(yv?INVA:t); epar[1]=j; return NULL; }
				if( ma->type=='I' ){
					if( isiptr(mx) && isiptr(my) )			// I += I * I
						ma->ival += cint(mx)*cint(my);
					else{									// D += V * V ( D <- I )
						ma->type='D'; ma->dval=ma->ival; ma->ival=0;
						ma->dval += cdbl(mx)*cdbl(my);
					}
				}
				else										// D += V * V
						ma->dval += cdbl(mx)*cdbl(my);
			}
		}
	}
	return ans;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
MATX_ADAM:								// 行列のアダマール演算
// OK条件 = {スカラー OP 行列}、{行列 OP スカラー}、又は、{行列(同サイズ) OP 行列(同サイズ)}
	if( xs || ys || ( !xs && !ys && xi==yi && xj==yj ) ){;}
	else{
		if( xv &&!ys && xi==0 && yi==1 && xj==yj ) goto _ADAM_OK;		// Vector(0xN) OP Matrix(1xN)
		if(!xs && yv && xi==1 && yi==0 && xj==yj ) goto _ADAM_OK;		// Matrix(1xN) OP Vector(0xN)
		flag_exerr=MatxCombi; epar[0]=xi,epar[1]=xj,epar[2]=yi,epar[3]=yj; return NULL;
_ADAM_OK:;
	}

	for( int i=0 ; i<(xs?yi:xi) || (i==0&&(xs?yv:xv)) ; i++ ){	/* Matrix|Vector */
		for( int j=0 ; j<(xs?yj:xj) ; j++ ){
			ma = ( ( xv || yv )  ? di2p_dtab(a,j) : dm2p_dtab(a,i,j)  );
			mx = ( xs ? x : ( xv ? di2p_dtab(x,j) : dm2p_dtab(x,i,j) ));// If mx is Scalar, it can't be 'U' here!!
			my = ( ys ? y : ( yv ? di2p_dtab(y,j) : dm2p_dtab(y,i,j) ));// If my is Scalar, it can't be 'U' here!!
			if( !isdef (mx) ){ flag_exerr=MatxUndef; epar[0]=(xv?INVA:i); epar[1]=j; return NULL; }
			if( !ismatv(mx) ){ flag_exerr=MatxValue; epar[0]=(xv?INVA:i); epar[1]=j; return NULL; }
			if( !isdef (my) ){ flag_exerr=MatxUndef; epar[0]=(yv?INVA:i); epar[1]=j; return NULL; }
			if( !ismatv(my) ){ flag_exerr=MatxValue; epar[0]=(yv?INVA:i); epar[1]=j; return NULL; }
			if( isiptr(mx) && isiptr(my) ){		// I = I op I
				switch(op){
					case '+': ma->type='I'; ma->ival=cint(mx)+cint(my); break;
					case '-': ma->type='I'; ma->ival=cint(mx)-cint(my); break;
					case '*': ma->type='I'; ma->ival=cint(mx)*cint(my); break;
					case '/': ma->type='I'; ma->ival=cint(mx)/cint(my); break;
					case '%': ma->type='I'; ma->ival=(tint)fmod(cdbl(mx),cdbl(my)); break;
					case POW: ma->type='I'; ma->ival=(tint)pow (cdbl(mx),cdbl(my)); break;
					default: return NULL;	/* Assert!! */
				}
			}
			else{								// D = V op V
				switch(op){
					case '+': ma->type='D'; ma->dval=cdbl(mx)+cdbl(my); break;
					case '-': ma->type='D'; ma->dval=cdbl(mx)-cdbl(my); break;
					case '*': ma->type='D'; ma->dval=cdbl(mx)*cdbl(my); break;
					case '/': ma->type='D'; ma->dval=cdbl(mx)/cdbl(my); break;
					case '%': ma->type='D'; ma->dval=fmod(cdbl(mx),cdbl(my)); break;
					case POW: ma->type='D'; ma->dval=pow (cdbl(mx),cdbl(my)); break;
					default: return NULL;	/* Assert!! */
				}
			}
		}
	}
	return ans;
}
