/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


/*
 || Example for the Tamino API for Java
 ||
 || It is assumed that a Tamino database called "mydb" has
 || been created and is running.
 || For storing data the default collection ino:etc is used
 || which should only be used for examples/test code.
 || We do not recommend this for real applications.
 ||
 || The following tasks are performed:
 ||
 || - establish a connection to the Tamino database
 || - obtain a non-XML accessor
 || - insert a new document with mime-type text/plain
 || - query the inserted document
 || - close the connection
 */
package com.softwareag.tamino.db.api.examples.greeting;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.response.TResponse;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;


public class NonXMLGreeting {
	
	public static void main(String[] args) throws Exception {
		// Put the XML content into a StringReader
		StringReader stringReader = new StringReader( NON_XML );
		// Instantiate an empty TNonXMLObject instance
		TNonXMLObject nonXMLObject = TNonXMLObject.newInstance( stringReader ,
															   null ,
															   "ino:nonXML" ,
															   "NonXMLGreeting" ,
															   "text/plain" );
		// Establish the connection to Tamino
		TConnection connection = TConnectionFactory.getInstance().newConnection( DATABASE_URI );
		// Obtain a TNonXMLObjectAccessor
		TNonXMLObjectAccessor nonXMLObjectAccessor = connection.newNonXMLObjectAccessor(
			TAccessLocation.newInstance( "ino:etc" ) );
		
		try {
			// Invoke the insert operation
			nonXMLObjectAccessor.insert( nonXMLObject );
			// Print ino:id of the document just inserted
			System.out.println( "Insert succeeded, ino:id=" + nonXMLObject.getId() );
		}
		catch (TInsertException insertException) {
			// Inform about the reason for the failure.
			System.out.println( "Insert failed!" );
			if ( insertException.hasAccessFailureException() )
				System.out.println( "Insert rejected by Tamino. Reason:" +
								   insertException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" +
								   insertException.getRootCause().getMessage() );
		}
		// Prepare to read the instance
		TQuery query = TQuery.newInstance( nonXMLObject.getDoctype() + "[@ino:id=" +
										  nonXMLObject.getId() + "]" );
		try {
			// Invoke the query operation
			TResponse response = nonXMLObjectAccessor.query( query );
			if ( response.hasFirstNonXMLObject() ) {
				ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
				response.getFirstNonXMLObject().writeTo( outputStream );
				System.out.println( "Retrieved following instance:" + outputStream );
			}
			else
				System.out.println( "No instance found!" );
		}
		catch (TQueryException queryException) {
			// Inform about the reason for the failure
			System.out.println( "Query failed!" );
			if ( queryException.hasAccessFailureException() )
				System.out.println( "Query rejected by Tamino. Reason:" +
								   queryException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" +
								   queryException.getRootCause().getMessage() );
		}
		// OK, everything is done, close the connection
		connection.close();
	}
	
	// URI of the Tamino database, please edit accordingly
	public final static String DATABASE_URI = "http://localhost/tamino/mydb";
	
	// Non-XML document to be written to the connected database
	public final static String NON_XML = "Greeting by='XMLGreetingApplication':Hello World";
	
}

