/*
 * ĿͼѤδؿ
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/24
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <conf.h>
#include <dic.h>
#include <record.h>
#include <dicutil.h>

static int gIsInit;

/* recordƱindexβܤͤФ */
static int gOffset;

void
anthy_dic_util_init(void)
{
  if (gIsInit) {
    return ;
  }
  if (anthy_init_dic() == -1) {
    return ;
  }
  anthy_dic_set_personality("default");
  gIsInit = 1;
}

void
anthy_dic_util_set_personality(char *id)
{
  anthy_dic_set_personality(id);
}

void
anthy_priv_dic_delete(void)
{
  if (anthy_select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  anthy_release_section();
}

int
anthy_priv_dic_select_first_entry(void)
{
  if (anthy_select_section("PRIVATEDIC",0) == -1) {
    return -1;
  }
  gOffset = 0;
  return anthy_select_first_column();
}

int
anthy_priv_dic_select_next_entry(void)
{
  int nr = anthy_get_nr_values();
  if (nr > gOffset + 3) {
    gOffset += 3;
    return 0;
  }
  gOffset = 0;
  return anthy_select_next_column();
}

int
anthy_priv_dic_select_entry(char *index)
{
  (void)index;
  return 0;
}

char *
anthy_priv_dic_get_index(char *buf, int len)
{
  xstr *xs;
  xs = anthy_get_index_xstr();
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

int
anthy_priv_dic_get_freq(void)
{
  return anthy_get_nth_value(gOffset + 2);
}

char *
anthy_priv_dic_get_wtype(char *buf, int len)
{
  xstr *xs = anthy_get_nth_xstr(gOffset + 1);
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

char *
anthy_priv_dic_get_word(char *buf, int len)
{
  xstr *xs = anthy_get_nth_xstr(gOffset);
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

int
anthy_priv_dic_add_entry(char *yomi, char *word,
			 char *wt_name, int freq)
{
  xstr *xs;
  int nr;

  if (anthy_select_section("PRIVATEDIC", 1) == -1) {
    return -1;
  }
  xs = anthy_cstr_to_xstr(yomi);
  if (anthy_select_column(xs, 1) == -1) {
    anthy_free_xstr(xs);
    return -1;
  }

  anthy_free_xstr(xs);
  nr = anthy_get_nr_values();
  xs = anthy_cstr_to_xstr(word);
  anthy_set_nth_xstr(nr, xs);
  anthy_free_xstr(xs);
  xs = anthy_cstr_to_xstr(wt_name);
  anthy_set_nth_xstr(nr+1, xs);
  anthy_free_xstr(xs);
  anthy_set_nth_value(nr + 2, freq);
  anthy_mark_column_used();
  return 0;
}

const char *
anthy_dic_util_get_anthydir(void)
{
  return anthy_conf_get_str("ANTHYDIR");
}
