(if (not (boundp 'test-opt2))
    (setq test-opt2 nil))
(if (not (boundp 'test-opt3))
    (setq test-opt3 nil))

(setq test-args 
      (list test-opt test-opt2 test-opt3))

(if (member "--help" test-args)
    (progn
      (print "Test patterns:\n\tsingle\n\tstd")
      (kill-emacs)))

(setq no-parse (member "--noparse" test-args))

(defun calc-test-index (args)
  (let ((c (car args)))
    (if (null c) 0
      (if (and
	   (stringp c)
	   (< 0 (string-to-int c)))
	  (string-to-int c)
	(calc-test-index (cdr args))))))

(setq test-index
      (calc-test-index test-args))

(print agent-command)
(setq agent
      (eval (append
 	     '(start-process 
 	       "anthy-agent" " *agent*" agent-command)
 	     agent-opt)))

(if (not agent)
    (progn
      (print "Failed to invoke anthy-agent\n")
      (kill-emacs)))

(defun wait-for-buffer ()
  (let ((p)(q))
    (setq p (buffer-size))
    (sleep-for 0 50)
    (accept-process-output nil 0 1)
    (setq q (buffer-size))
    (or (= q 0) (< p q))))

(defun send-cmd (str)
  (with-current-buffer " *agent*"
    (erase-buffer)
    (process-send-string agent str)
    (while (wait-for-buffer))
    (buffer-string)))


(defun do-conv (str check)
  (let
      ((ans)(res t))
    (print (send-cmd (concat str "\n")))
    (setq ans (send-cmd "(space)\n"))
    (print ans)
    (if (and check
	     (not no-parse))
	(progn
	  (setq ans (read ans))
	  (setq res (funcall check ans))))
    (if (or (not res) (not check) no-parse)
	(print ans))
    res))

(defun check-single (arg)
  (= (length arg) 2))

(setq standard-test-list
      '(("watasinonamaehanakanodesu")
	("sekkakudakara,orehakonoakanotobirawoerabuze")
	("konohonwoyonidasukotogadekirunoha,tumaeimi-tomusumemarianookageda.")
	))

(setq misc-test-list
      '(("ittekuru")
	("yondemo")
	("tuzuketeiku")
	("kyojinkattoru")
	("#")
	("/A/ikitai")
	("nihonkokunodoryoku")
	))

(setq single-test-list
      '(("susumeyou")
	("kaiterunoni")
	("mireruto")
	("okonawareruto")
	("nonderu")
	("tukawareru")
	("teian")
	("audakede")
	("sitei")
	("hajimeta")
	("kettei")
	("tukaitai")
	("naritai")
	("anda-rainn")
	("omoitukimasita")
	))

(defun list-conv (lst check)
  (if (< 0 test-index)
      (setq lst
	    (list (nth (- test-index 1) lst))))
  (let
      ((total 0)
       (ok 0)
       (miss 0))
    (mapcar (lambda (arg)
	      (progn 
		(if (do-conv (car arg) check)
		    (setq ok (1+ ok))
		  (setq miss (1+ miss)))
		(setq total (1+ total))))
	    lst)
    (princ ok)
    (princ "=OK/MISS=")
    (princ miss)
    (princ " :Total ")
    (princ total)
    (princ "\n")
    ))

(if (= (length test-opt) 0)
    (setq test-opt "std"))

(if (member "std" test-args)
    (list-conv standard-test-list nil))

(if (member "misc" test-args)
    (list-conv misc-test-list nil))

(if (member "single" test-args)
    (list-conv single-test-list 'check-single))
