/*
 * Anthyμ饤֥Υȥ롼
 *
 * Copyright (C) 2000-2002 TABATA Yusuke
 *
 * $Id: dic_main.c,v 1.20 2002/06/01 03:14:44 yusuke Exp $
 */
#include <stdlib.h>

#include <dic.h>
#include <conf.h>
#include <record.h>
#include <alloc.h>
#include <logger.h>

#include "dic_main.h"
#include "dic_personality.h"
#include "dic_ent.h"
#include "dic_cache.h"
#include "dic_session.h"

/**/
static int dic_is_init;

/*  */

/* personality */
struct dic_cache *anthy_current_dic;
struct record_stat *anthy_current_record;

seq_ent_t
anthy_get_seq_ent_from_xstr(xstr *x)
{
  struct seq_ent *s;
  s = anthy_cache_get_seq_ent(x);
  if (!s || s->nr_dic_ents==0) {
    return anthy_get_ext_seq_ent_from_xstr(x);
  }
  return s;
}

/*
 * seq_entμ
 ************************
 * seq_entγƼμ
 */
int
anthy_get_seq_flag(seq_ent_t se)
{
  if (!se) {
    return 0;
  }

  return se->flags;
}

int
anthy_get_nr_dic_ents(seq_ent_t se, xstr *xs)
{
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  return s->nr_dic_ents + anthy_get_nr_dic_ents_of_ext_ent(se, xs);
}

int
anthy_get_nth_dic_ent_str(seq_ent_t se, xstr *o,
			  int n, xstr *x)
{
  struct seq_ent *s = se;
  if (!s) {
    return -1;
  }
  if (n >= s->nr_dic_ents) {
    return anthy_get_nth_dic_ent_str_of_ext_ent(se, o, n - s->nr_dic_ents, x);
  }
  x->len = s->dic_ents[n]->str.len;
  x->str = anthy_xstr_dup_str(&s->dic_ents[n]->str);
  return 0;
}

int
anthy_get_nth_dic_ent_freq(seq_ent_t se, int n)
{
  struct seq_ent *s = se;
  if (!s || s->nr_dic_ents <= n) {
      return 0;
  }
  return s->dic_ents[n]->freq;
}

int
anthy_get_nth_dic_ent_wtype(seq_ent_t se, xstr *xs,
			    int n, wtype_t *w)
{
  struct seq_ent *s = se;
  if (!s) {
    *w = anthy_wt_none;
    return -1;
  }
  if (s->nr_dic_ents <= n) {
    int r;
    r = anthy_get_nth_dic_ent_wtype_of_ext_ent(xs, n - s->nr_dic_ents, w);
    if ( r == -1) {
      *w = anthy_wt_none;
    }
    return r;
  }
  *w =  s->dic_ents[n]->type;
  return 0;
}

int
anthy_get_seq_ent_pos(seq_ent_t se, int pos)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_pos(se, pos);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_pos(s->dic_ents[i]->type) == pos) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int
anthy_get_seq_ent_ct(seq_ent_t se, int pos, int ct)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_ct(s, pos, ct);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_pos(s->dic_ents[i]->type)== pos &&
	 anthy_wtype_get_ct(s->dic_ents[i]->type)==ct) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int
anthy_get_seq_ent_wtype_freq(seq_ent_t se, wtype_t wt)
{
  int i,f;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_wtype(se, wt);
  }
  f = 0;
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtypecmp(wt, s->dic_ents[i]->type)) {
      if (f < s->dic_ents[i]->freq) {
	f = s->dic_ents[i]->freq;
      }
    }
  }
  return f;
}

int
anthy_get_seq_ent_indep(seq_ent_t se)
{
  int i;
  struct seq_ent *s = se;
  if (!s) {
      return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_indep(s);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_indep(s->dic_ents[i]->type)) {
      return 1;
    }
  }
  return 0;
}
/*
 *
 */
int
anthy_init_dic(void)
{
  if (dic_is_init) {
    return 0;
  }
  anthy_do_conf_init();

  anthy_init_wtypes();
  anthy_init_ext_ent();
  anthy_init_ddic();
  anthy_init_sdic();
  anthy_init_record();
  anthy_init_xchar_tab();

  if (anthy_init_dic_cache() == -1) {
    anthy_log(0, "Failed to init dic cache.\n");
    return -1;
  }
  dic_is_init = 1;
  return 0;
}

void
anthy_quit_dic(void)
{
  if (anthy_current_record) {
    anthy_release_record(anthy_current_record);
  }
  if (anthy_current_dic) {
    anthy_release_dic_cache(anthy_current_dic);
  }
  anthy_current_record = 0;
  anthy_current_dic = 0;
  anthy_quit_ddic();
  anthy_quit_allocator();
  anthy_conf_free();
  dic_is_init = 0;
}

dic_session_t
anthy_dic_create_session(void)
{
  return anthy_create_session();
}

void
anthy_dic_activate_session(dic_session_t d)
{
  anthy_activate_session(d);
}

void
anthy_dic_release_session(dic_session_t d)
{
  anthy_release_session(d);
  anthy_shrink_cache();
}

void
anthy_dic_set_personality(const char *id)
{
  /*
   * 
   * 񥭥åιۤˤե뤬ɬ
   */
  anthy_current_record = anthy_create_record(id);
  anthy_current_dic = anthy_create_dic_cache(id);
}
