/* code from uim from gtk+
   example-start entry entry.c */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct app_context {
  GtkWidget *entry_index;
  GtkWidget *entry_word;
};

void enter_callback( GtkWidget *widget,
                     GtkWidget *entry )
{
  gchar *entry_text;
  entry_text = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  printf("Entry contents: %s\n", entry_text);
}

void
do_add_word(const char *index, const char *word)
{
  FILE *fp = fopen("tmp-tmp", "w");
  if (!fp) {
    return ;
  }
  fprintf(fp, "%s %s\n", index, word);
  fclose(fp);

  system("fossil-backend --encoding utf-8 --read tmp-tmp");
}

void
commit_callback(GtkWidget *widget,
	       void *ptr)
{
  app_context *ac = (app_context *)ptr;
  const gchar *index;
  const gchar *word;
  index = gtk_entry_get_text(GTK_ENTRY(ac->entry_index));
  word = gtk_entry_get_text(GTK_ENTRY(ac->entry_word));
  if (!index || !strlen(index) ||
      !word || !strlen(word)) {
    return ;
  }
  printf("add index=(%s) word=(%s)\n",index, word);
  //
  do_add_word(index, word);
}

void
close_callback(GtkWidget *widget,
	       void *ptr)
{
  system("fossil-backend --update-index");
  gtk_exit(0);
}



static GtkWidget *
create_top_vbox()
{
  GtkWidget *window;
  GtkWidget *vbox;

  /* create a new window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  //gtk_widget_set_usize( GTK_WIDGET (window), 200, 100);
  gtk_window_set_title(GTK_WINDOW (window), "New word");
  gtk_signal_connect(GTK_OBJECT (window), "delete_event",
		     (GtkSignalFunc) gtk_exit, NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);
    
  gtk_widget_show(window);
  return vbox;
}

static GtkWidget *
create_field(const char *word, GtkWidget *vbox)
{
  GtkWidget *label;
  GtkWidget *entry;
  //
  label = gtk_label_new(word);
  gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
  gtk_widget_show(label);
  //
  entry = gtk_entry_new_with_max_length (50);
  gtk_signal_connect(GTK_OBJECT(entry), "activate",
		     GTK_SIGNAL_FUNC(enter_callback),
		     entry);
  gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
  gtk_widget_show (entry);
  return entry;
}

int
main(int argc, char *argv[])
{
  GtkWidget *vbox;

  struct app_context ac;

  gtk_set_locale();
  gtk_init (&argc, &argv);

  vbox = create_top_vbox();
  /**/
  ac.entry_index = create_field("Index", vbox);
  ac.entry_word = create_field("Word", vbox);

  /**/
  GtkWidget *add_button;
  add_button = gtk_button_new_with_label ("Add");
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC(commit_callback),
		      (void*)&ac);
  gtk_box_pack_start (GTK_BOX (vbox), add_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (add_button);
  gtk_widget_show (add_button);

  /**/
  GtkWidget *close_button;
  close_button = gtk_button_new_with_label ("Close");
  gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
		      GTK_SIGNAL_FUNC(close_callback),
		      (void*)&ac);
  gtk_box_pack_start (GTK_BOX (vbox), close_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (close_button);
  gtk_widget_show (close_button);

  gtk_main();
  return(0);
}
