#include <stdio.h>
#include <stdlib.h>
#include "ui.h"
#include "reader.h"

static void
do_dump()
{
  system("fossil-backend --dump > tmp-tmp");
}

static GtkTreeModel *
build_words_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(3,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static void
update_word_attrs(app_win *aw, Word *w)
{
  gtk_list_store_clear(GTK_LIST_STORE(aw->attr_model));
  if (!w) {
    return ;
  }
  std::list<Attr *>::iterator it;
  for (it = w->m_attrs.begin(); it != w->m_attrs.end(); it++) {
    Attr *a = *it;
    std::list<Sign *>::iterator jt;
    for (jt = a->m_signs.begin(); jt != a->m_signs.end(); jt++) {
      Sign *s = *jt;
      GtkTreeIter iter;
      char buf[10];
      s->m_stamp.get_str(buf);
      gtk_list_store_append(GTK_LIST_STORE(aw->attr_model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(aw->attr_model), &iter,
			 0, s,
			 1, s->m_user,
			 2, buf,
			 3, s->m_is_ok ? "ok" : "no",
			 4, a->m_attr,
			 -1);
    }
  }
}


static void
set_edit_attrs(app_win *win, Sign *sign)
{
  if (!sign) {
    gtk_label_set_text(GTK_LABEL(win->index_label), "");
    gtk_label_set_text(GTK_LABEL(win->word_label), "");
    gtk_label_set_text(GTK_LABEL(win->name_label), "");
    gtk_label_set_text(GTK_LABEL(win->attr_label), "");
    gtk_label_set_text(GTK_LABEL(win->stamp_label), "");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check), 0);
    return ;
  }
  Attr *a = sign->m_owner;
  gtk_label_set_text(GTK_LABEL(win->index_label), a->m_owner->m_index);
  gtk_label_set_text(GTK_LABEL(win->word_label), a->m_owner->m_word);
  gtk_label_set_text(GTK_LABEL(win->name_label), sign->m_user);
  gtk_label_set_text(GTK_LABEL(win->attr_label), a->m_attr);
  //
  char buf[10];
  sign->m_stamp.get_str(buf);
  gtk_label_set_text(GTK_LABEL(win->stamp_label), buf);
  //
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check),
			       sign->m_is_ok);
}

static void
word_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_word = NULL;
    win->current_sign = NULL;
    update_word_attrs(win, NULL);
    set_edit_attrs(win, NULL);
    return ;
  }

  gtk_tree_model_get_value(win->words_model, &iter,
			   0, &value);
  //
  Word *w = (Word *)g_value_get_pointer(&value);
  if (w != win->current_word) {
    win->current_sign = NULL;
    set_edit_attrs(win, NULL);
  }
  win->current_word = w;
  g_value_unset(&value);
  update_word_attrs(win, w);
}

static void
check_cb(GtkWidget *ok_check,
	 app_win *win)
{
  Sign *sign = win->current_sign;
  if (!sign) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check), 0);
    return ;
  }
  if (!strcmp(sign->m_user, get_user_name())) {
    // my decision
    int active;
    active = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(win->ok_check));
    if (active) {
      sign->m_is_ok = true;
    } else {
      sign->m_is_ok = false;
    }
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check),
				 sign->m_is_ok);
  }
  update_word_attrs(win, win->current_word);
}

static void
new_attr_cb(GtkWidget *button, app_win *win)
{
  if (!win->current_word) {
    return ;
  }
  Stamp stamp;
  win->ws.add_word(get_user_name(), stamp, true,
		   win->current_word->m_index,
		   win->current_word->m_word);
  update_word_attrs(win, win->current_word);
}

static void
quit_cb(GtkWidget *button, app_win *win)
{
  gtk_exit(0);
}

static void
save_cb(GtkWidget *button, app_win *win)
{
  FILE *fp = fopen("tmp-tmp", "w");
  if (!fp) {
    fprintf(stderr, "failed to open tmpfile.\n");
    return ;
  }
  win->ws.write_words(fp);
  system("fossil-backend --read tmp-tmp");
  fclose(fp);
}

static void
attr_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_sign = NULL;
    return ;
  }

  gtk_tree_model_get_value(win->attr_model, &iter,
			   0, &value);
  Sign *sign;
  sign = (Sign *)g_value_get_pointer(&value);
  win->current_sign = sign;
  g_value_unset(&value);
  if (sign) {
    set_edit_attrs(win, sign);
  }
}

static GtkTreeModel *
build_attr_model()
{
  // stamp, user, day, approve
  GtkListStore *model;
  model = gtk_list_store_new(5,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}


static void
add_column(GtkTreeView *treeview, const char *name, int idx)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes(name,
						    renderer,
						    "text", idx,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
}

static void
add_word_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Word", 1);
  /**/
  add_column(treeview, "Index", 2);
}

static void
add_attr_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Name", 1);
  add_column(treeview, "Stamp", 2);
  add_column(treeview, "Ok?", 3);
  add_column(treeview, "Attribute", 4);
}

static void
build_tree_view(struct app_win *aw, GtkWidget *box)
{
  GtkWidget *sw;
  sw = gtk_scrolled_window_new(NULL, NULL);


  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);
  aw->words_model = build_words_model();
  aw->words_view = gtk_tree_view_new_with_model(aw->words_model);
  aw->attr_model = build_attr_model();
  aw->attr_view = gtk_tree_view_new_with_model(aw->attr_model);

  add_word_view_column(aw, GTK_TREE_VIEW(aw->words_view));
  add_attr_view_column(aw, GTK_TREE_VIEW(aw->attr_view));

  gtk_container_add(GTK_CONTAINER(sw), aw->words_view);
  gtk_box_pack_start (GTK_BOX (box), aw->attr_view, TRUE, TRUE, 0);

  gtk_widget_show(aw->words_view);
  gtk_widget_show(aw->attr_view);
  gtk_widget_show(sw);

  GtkTreeSelection *selection;
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->words_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(word_selection_cb), aw);
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->attr_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(attr_selection_cb), aw);
}

static void
build_button_bar(struct app_win *win, GtkWidget *vbox)
{
  GtkWidget *hbox;
  hbox = gtk_hbox_new(FALSE, 0);
  //
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  //
  GtkWidget *quit_button;
  GtkWidget *save_button;
  GtkWidget *sign_button;
  quit_button = gtk_button_new_with_label("Quit");
  save_button = gtk_button_new_with_label("Save");
  sign_button = gtk_button_new_with_label("MySign");
  gtk_box_pack_start(GTK_BOX(hbox), sign_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), save_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), quit_button, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(sign_button), "clicked",
		     GTK_SIGNAL_FUNC(new_attr_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(save_button), "clicked",
		     GTK_SIGNAL_FUNC(save_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		     GTK_SIGNAL_FUNC(quit_cb),
		     win);
  gtk_widget_show(quit_button);
  gtk_widget_show(save_button);
  gtk_widget_show(sign_button);
  gtk_widget_show(hbox);
}

static void
build_app_win(struct app_win *win)
{
  win->main_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  //
  build_tree_view(win, vbox);
  build_button_bar(win, vbox);
  //
  gtk_container_add(GTK_CONTAINER(win->main_top), vbox);
  gtk_widget_show(vbox);
  gtk_window_set_default_size(GTK_WINDOW(win->main_top), 500, 500);
  gtk_widget_show(win->main_top);
}

static void
build_edit_win(struct app_win *win)
{
  win->edit_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(win->edit_top), vbox);
  //
  win->word_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->word_label, TRUE, TRUE, 0);
  gtk_widget_show(win->word_label);
  //
  win->index_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->index_label, TRUE, TRUE, 0);
  gtk_widget_show(win->index_label);
  //
  win->name_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->name_label, TRUE, TRUE, 0);
  gtk_widget_show(win->name_label);
  //
  win->attr_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->attr_label, TRUE, TRUE, 0);
  gtk_widget_show(win->attr_label);
  //
  win->stamp_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->stamp_label, TRUE, TRUE, 0);
  gtk_widget_show(win->stamp_label);
  //
  win->ok_check = gtk_check_button_new_with_label("ok");
  gtk_box_pack_start(GTK_BOX(vbox), win->ok_check, TRUE, TRUE, 0);
  gtk_widget_show(win->ok_check);
  gtk_signal_connect(GTK_OBJECT(win->ok_check), "toggled",
		     GTK_SIGNAL_FUNC(check_cb), win);
  //
  gtk_widget_show(vbox);
  gtk_widget_show(win->edit_top);
}

static void
update_model(struct app_win *aw)
{
  std::list<Word *>::iterator it;
  GtkTreeIter iter;

  for (it = aw->ws.m_word_array.begin();
       it != aw->ws.m_word_array.end(); it++) {
    Word *w = *it;

    gtk_list_store_append(GTK_LIST_STORE(aw->words_model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(aw->words_model), &iter,
		       0, w,
		       1, w->m_index,
		       2, w->m_word,
		       -1);

  }
}

static void
read_words(WordSet *ws, const char *fn)
{
  FILE *fp = fopen(fn, "r");
  if (!fp) {
    return ;
  }
  char buf[1024];
  while (fgets(buf, 1024, fp)) {
    DictLine dl(buf);
    if (dl.nr != 6) {
      continue;
    }
    ws->add_word(dl.user, dl.stamp, dl.approve,
		 dl.index, dl.word);
  }
  fclose(fp);
}

int
main(int argc, char **argv)
{
  struct app_win win;
  do_dump();
  read_words(&win.ws, "tmp-tmp");
  gtk_init(&argc, &argv);
  win.current_sign = NULL;
  win.current_word = NULL;

  build_app_win(&win);
  build_edit_win(&win);
  update_model(&win);

  gtk_main();
  return 0;
}
