#include <iconv.h>
#include <string.h>
#include <stdlib.h>
#include "word.h"
#include "misc.h"

static iconv_t euc_to_utf8;
static bool input_is_utf8 = true;

Sign::Sign(Stamp stamp, const char *user, bool is_ok)
{
  m_user = strdup(user);
  m_stamp = stamp;
  m_is_ok = is_ok;
}

Attr::Attr(Word *w, const char *a)
{
  m_attr = strdup(a);
  m_owner = w;
}

Sign *
Attr::add_sign(const char *user, Stamp stamp, bool ok)
{
  std::list<Sign *>::iterator it;
  for (it = m_signs.begin(); it != m_signs.end(); it++) {
    Sign *s = *it;
    if (!strcmp(s->m_user, user)) {
      // overwrite
      s->m_is_ok = ok;
      if (stamp.get_stamp() > s->m_stamp.get_stamp()) {
	s->m_stamp = stamp;
      }
      return NULL;
    }
  }
  //
  Sign *s = new Sign(stamp, user, ok);
  s->m_owner = this;
  m_signs.push_back(s);
  return s;
}

Attr *
Word::find_attr(const char *name)
{
  std::list<Attr *>::iterator it;
  for (it = m_attrs.begin(); it != m_attrs.end(); it++) {
    Attr *attr = *it;
    if (!strcmp(attr->m_attr, name)) {
      return attr;
    }
  }
  return NULL;
}

static char *
do_iconv(const char *str, iconv_t ic)
{
  int len = strlen(str);
  unsigned int buflen = len * 6+3;
  char *realbuf = (char *)alloca(buflen);
  char *outbuf = realbuf;
  const char *inbuf = str;
  memset(realbuf, 0, buflen);
  iconv(ic, (ICONV_CONST char **)&inbuf, (size_t *)&len,
	&outbuf, (size_t *)&buflen);
  return strdup(realbuf);
}

char *
to_utf8(const char *str)
{
  if (input_is_utf8) {
    return strdup(str);
  }
  return do_iconv(str, euc_to_utf8);
}

static int
hash(const char *str)
{
  const unsigned char *p = (const unsigned char *)str;
  int h = 0;
  while (*p) {
    h = h + (*p) * 11;
    h = h * 11;
    p++;
  }
  return h;
}

int
word_hash(const char *idx, const char *word)
{
  int h1 = hash(idx);
  int h2 = hash(word);
  int h = h1 * 11 + h2;
  if (h < 0) {
    h = -h;
  }
  return h;
}

void
set_encoding(const char *encoding)
{
  char e = encoding[0];
  if (e == 'u' || e == 'U') {
    input_is_utf8 = true;
  } else {
    input_is_utf8 = false;
  }
}

void
init_word()
{
  euc_to_utf8 = iconv_open("UTF-8", "EUC-JP");
  if (euc_to_utf8 == (iconv_t)-1) {
  }
}
