#include "ui.h"

static void
build_button_bar(struct app_win *win, GtkWidget *vbox)
{
  GtkWidget *hbox;
  hbox = gtk_hbox_new(FALSE, 0);
  //
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  //
  GtkWidget *quit_button;
  GtkWidget *save_button;
  GtkWidget *sign_button;
  quit_button = gtk_button_new_with_label("Quit");
  save_button = gtk_button_new_with_label("Save");
  sign_button = gtk_button_new_with_label("MySign");
  gtk_box_pack_start(GTK_BOX(hbox), sign_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), save_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), quit_button, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(sign_button), "clicked",
		     GTK_SIGNAL_FUNC(new_attr_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(save_button), "clicked",
		     GTK_SIGNAL_FUNC(save_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		     GTK_SIGNAL_FUNC(quit_cb),
		     win);
  gtk_widget_show(quit_button);
  gtk_widget_show(save_button);
  gtk_widget_show(sign_button);
  gtk_widget_show(hbox);
}

static void
add_column(GtkTreeView *treeview, const char *name, int idx)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes(name,
						    renderer,
						    "text", idx,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
}

static void
add_word_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Word", 1);
  /**/
  add_column(treeview, "Index", 2);
}

static void
add_attr_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Name", 1);
  add_column(treeview, "Stamp", 2);
  add_column(treeview, "Ok?", 3);
  add_column(treeview, "Attribute", 4);
}

static GtkTreeModel *
build_words_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(3,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static GtkTreeModel *
build_attr_model()
{
  // stamp, user, day, approve
  GtkListStore *model;
  model = gtk_list_store_new(5,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static void
build_tree_view(struct app_win *aw, GtkWidget *box)
{
  GtkWidget *sw;
  sw = gtk_scrolled_window_new(NULL, NULL);


  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);
  aw->words_model = build_words_model();
  aw->words_view = gtk_tree_view_new_with_model(aw->words_model);
  aw->attr_model = build_attr_model();
  aw->attr_view = gtk_tree_view_new_with_model(aw->attr_model);

  add_word_view_column(aw, GTK_TREE_VIEW(aw->words_view));
  add_attr_view_column(aw, GTK_TREE_VIEW(aw->attr_view));

  gtk_container_add(GTK_CONTAINER(sw), aw->words_view);
  gtk_box_pack_start (GTK_BOX (box), aw->attr_view, TRUE, TRUE, 0);

  gtk_widget_show(aw->words_view);
  gtk_widget_show(aw->attr_view);
  gtk_widget_show(sw);

  GtkTreeSelection *selection;
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->words_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(word_selection_cb), aw);
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->attr_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(attr_selection_cb), aw);
}

static GtkWidget *
build_edit_win(struct app_win *win)
{
  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  //
  win->word_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->word_label, FALSE, FALSE, 0);
  gtk_widget_show(win->word_label);
  //
  win->index_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->index_label, FALSE, FALSE, 0);
  gtk_widget_show(win->index_label);
  //
  win->name_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->name_label, FALSE, FALSE, 0);
  gtk_widget_show(win->name_label);
  //
  win->attr_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->attr_label, FALSE, FALSE, 0);
  gtk_widget_show(win->attr_label);
  //
  win->stamp_label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), win->stamp_label, FALSE, FALSE, 0);
  gtk_widget_show(win->stamp_label);
  //
  win->ok_check = gtk_check_button_new_with_label("ok");
  gtk_box_pack_start(GTK_BOX(vbox), win->ok_check, FALSE, FALSE, 0);
  gtk_widget_show(win->ok_check);
  gtk_signal_connect(GTK_OBJECT(win->ok_check), "toggled",
		     GTK_SIGNAL_FUNC(check_cb), win);
  //
  gtk_widget_show(vbox);
  return vbox;
}

static GtkWidget *
build_app_win(struct app_win *win)
{
  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  //
  build_tree_view(win, vbox);
  build_button_bar(win, vbox);
  //
  gtk_widget_show(vbox);
  return vbox;
}

void
build_win(app_win *win)
{
  win->main_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget *hbox;
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(win->main_top), hbox);


  GtkWidget *main_box;
  main_box = build_app_win(win);
  gtk_window_set_default_size(GTK_WINDOW(win->main_top), 500, 500);
  gtk_box_pack_start(GTK_BOX(hbox), main_box, TRUE, TRUE, 0);

  //
  GtkWidget *edit_box;
  edit_box = build_edit_win(win);
  gtk_box_pack_start(GTK_BOX(hbox), edit_box, TRUE, TRUE, 0);

  gtk_widget_show(hbox);
  gtk_widget_show(win->main_top);
}
