#ifndef _rkconv_h_included_
#define _rkconv_h_included_

#include "jmode.h"

struct RkRule {
    char* lhs;
    char* rhs;
    char* follow;
};

struct Rule{
    Rule();
    ~Rule(void);
    Rule& operator = (RkRule& r);
    char* lhs;
    char* rhs;
    char* follow;
};

class RuleSet{
public:
    RuleSet(RkRule* rule);
    ~RuleSet();
    Rule* get_rule() { return rule; }
    int get_nr_rules() { return nr_rules; }
private:
    Rule* rule;
    int nr_rules;
};

class SlrClosure{
public:
    SlrClosure (RuleSet* rule, int nr_rule,
		Rule* cur_rule = NULL, size_t pflen = 0);
    ~SlrClosure (void);
    void print (FILE* fp, char* prefix);
    void convert_batch (char* src, char* dst);
    SlrClosure* convert_iterative (char c, char* dst, SlrClosure* cl);
    const char* get_prefix(void){ return prefix; }
private:
    char* convert_reduction(char* dst, Rule* r);
    
    char* prefix;
    Rule* r;//ԸԤ롼(äƤ(SLR))
		  int is_reduction_only;
    SlrClosure* next[128];
};

class RKMap{
public:
    RKMap(RkRule* rule);
    ~RKMap(void);
    void print (FILE* fp, char* prefix);
    void convert_batch (char* src, char* dst);
    SlrClosure* convert_iterative (char c, char* dst, SlrClosure* cur){
	return cur->convert_iterative(c, dst, cl);
    }
    int get_refcount();
    int inc_refcount();
    int dec_refcount();
    SlrClosure* get_init();
private:
    RuleSet* rs;
    SlrClosure* cl;
    int refcount;
};

class RKConv{
public:
    RKConv();
    bool push_key(int cin);  
    void flush();
    cchar get_cchar();
    /*
     * 
     *    map:  ޥåפμ
     *    :           Ťޥå
     *             NULL     顼 (Ťޥåֹݻ)
     *                      ޤϸŤޥåפʤ
     */
    RKMap* select_map(RKMap* map);
    void print_map(FILE* fp, char* prefix);
    char* get_pending_char(char* buf, size_t size);
    bool is_pending();
    bool back_space();/*ºݤΥ饯äɤ֤äƤ*/
private:
    bool euc_to_cchar(char* p);
    RKMap* map;
    SlrClosure* cur;
    std::list<cchar> outQ;
};

extern RkRule hiragana[];
extern RkRule katakana[];

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
