; ܸ/JapaneseEUC-JP
;
;; im-management
;
(define current-im nil)
(define im-list nil)

(define default-im-name nil)

(define preedit-none 0)
(define preedit-underline 1)
(define preedit-reverse 2)
(define preedit-cursor 4)


(define make-im
  (lambda (name lang encoding init-arg init-context release-context
		mode key-press key-release reset
		get-candidate set-candidate-index)
    (let ((im ()))
      (set! im (cons (cons 'name name) im))
      (set! im (cons (cons 'lang lang) im))
      (set! im (cons (cons 'encoding encoding) im))
      (set! im (cons (cons 'init-arg init-arg) im))
      (set! im (cons (cons 'init-handler init-context) im))
      (set! im (cons (cons 'release-handler release-context) im))
      (set! im (cons (cons 'mode-handler mode) im))
      (set! im (cons (cons 'key-press-handler key-press) im))
      (set! im (cons (cons 'key-release-handler key-release) im))
      (set! im (cons (cons 'reset-handler reset) im))
      (set! im (cons (cons 'get-candidate-handler get-candidate) im))
      (set! im (cons (cons 'set-candidate-index-handler set-candidate-index) im))
      im)))

(define register-im
  (lambda (name lang encoding init-arg init release
		mode key-press key-release reset
		get-candidate set-candidate-index)
    (let
	((im
	  (make-im name lang encoding init-arg init release
		   mode key-press key-release reset
		   get-candidate set-candidate-index)))
      (set! current-im im)
      (im-register-im name lang encoding)
      (if (assq name im-list)
	  (delq name im-list))
      (set! im-list
	    (cons
	     (cons name im) im-list)))))

(define im-name
  (lambda (im)
    (cdr (assq 'name im))))
(define im-init-arg
  (lambda (im)
    (cdr (assq 'init-arg im))))
(define im-init-handler
  (lambda (im)
    (cdr (assq 'init-handler im))))
(define im-release-handler
  (lambda (im)
    (cdr (assq 'release-handler im))))
(define im-key-press-handler
  (lambda (im)
    (cdr (assq 'key-press-handler im))))
(define im-encoding
  (lambda (im)
    (cdr (assq 'encoding im))))
(define im-key-release-handler
  (lambda (im)
    (cdr (assq 'key-release-handler im))))
(define im-reset-handler
  (lambda (im)
    (cdr (assq 'reset-handler im))))
(define im-get-candidate
  (lambda (im)
    (cdr (assq 'get-candidate im))))
(define im-mode-handler
  (lambda (im)
    (cdr (assq 'mode-handler im))))
(define im-get-candidate-handler
  (lambda (im)
    (cdr (assq 'get-candidate-handler im))))
(define im-set-candidate-index-handler
  (lambda (im)
    (cdr (assq 'set-candidate-index-handler im))))
;;
;; context-management
; context := ((id im.data) ...)
(define context-list nil)
(define find-context
  (lambda (id)
    (let ((c (assq id context-list)))
      c)))
(define remove-context-rec
  (lambda (lst id)
    (if lst
	(if (= (caar lst) id)
	    (remove-context-rec (cdr lst) id)
	    (cons (car lst)
		  (remove-context-rec (cdr lst) id)))
	nil)))
(define remove-context
  (lambda (id)
    (set! context-list
	  (remove-context-rec context-list id))))

(define add-context
  (lambda (id im)
    (set! context-list
	  (cons
	   (cons
	    id
	    (cons im ()))
	   context-list))))

(define context-id
 (lambda (c)
   (car c)))
(define context-im
 (lambda (c)
   (cadr c)))
(define context-data
  (lambda (c)
    (cddr c)))
(define set-context-data!
  (lambda (c d)
    (set-cdr! (cdr c) d)))
;; default-im
(define default-push-back-mode
  (lambda (id lst)
    (if (car lst)
	(begin
	  (im-pushback-mode-list id (caar lst))
	  (default-push-back-mode id (cdr lst))))))
(define default-init-handler
  (lambda (id)
    (im-clear-mode-list id)
    (default-push-back-mode id im-list)
    (im-update-mode-list id)
    (im-update-mode id (- (length im-list) 1))
    ()))
(define default-release-handler
  (lambda (id)()))
(define default-key-press-handler
  (lambda (id key state)
    (let ((c (find-context id)))
      (im-commit-raw id))))
(define default-key-release-handler
  (lambda (id key state)()))
(define default-reset-handler
  (lambda (id)()))
(define default-mode-handler
  (lambda (id mode)
    (create-context id nil (car (nth mode im-list)))))

(define default-get-candidate-handler
  (lambda (id idx)()))
(define default-set-candidate-index-handler
  (lambda (id idx)()))

(register-im
 'default
 "*"
 "UTF-8"
 nil
 default-init-handler
 default-release-handler
 default-mode-handler
 default-key-press-handler
 default-key-release-handler
 default-reset-handler
 default-get-candidate-handler
 default-set-candidate-index-handler)
;;
;; Dispatch
(define key-press-handler
  (lambda (id key state)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-key-press-handler im)))
      (handler id key state))))
;
(define key-release-handler
  (lambda (id key state)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-key-release-handler im)))
      (handler id key state))))

(define reset-handler
  (lambda (id)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-reset-handler im)))
      (handler id))))

(define mode-handler
  (lambda (id mode)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-mode-handler im)))
      (handler id mode))))

(define select-im
  (lambda (name lang)
    (let ((res ()))
      ;; use default, if exsits.
      (if default-im-name
	  (set! res
		(assq default-im-name im-list)))
      ;; specified name
      (let ((i (assq name im-list)))
	(if i
	    (set! res (cdr i))))
      (if (not res)
	  (set! res current-im))
      res)))

(define create-context
  (lambda (id lang name)
    (let* ((im (select-im name lang))
	   (handler (im-init-handler im))
	   (arg (im-init-arg im)))
      (if (find-context id)
	  (remove-context id))
      (im-set-encoding id
		       (im-encoding im))
      (add-context id im)
      (handler id arg))))

(define release-context
  (lambda (id)
    (let* ((c (find-context id))
	   (im (context-im c))
	   (handler (im-release-handler im)))
      (if handler
	  (handler id))
      (remove-context id)
      ())))

(define get-candidate
  (lambda (id idx)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-get-candidate-handler im)))
      (im-return-str (handler id idx)))))
(define set-candidate-index
  (lambda (id idx)
    (let*
	((c (find-context id))
	 (im (context-im c))
	 (handler (im-set-candidate-index-handler im)))
      (handler id idx))))
;;
(require "util.scm")
(require "key.scm")
;;
