// -*- C++ -*-
//
// dispatcher of Xlib events for window.
//
#ifndef _xdispatch_h_included_
#define _xdispatch_h_included_

#include <X11/X.h>

class WindowIf{
public:
    virtual ~WindowIf();
    virtual void expose(Window )=0;
    virtual void destroy(Window )=0;
    virtual void resize(Window ,int w,int h);
};

// Xlib event
#define EXPOSE_MASK (1<<15)
#define STRUCTURE_NOTIFY_MASK (1<<17)

void add_window_watch(Window id,WindowIf *,int mask);
void remove_window_watch(Window id);

void add_atom_watch(Atom , void (*fn)(Atom ));

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
