#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <uim/uim.h>

extern int uim_fd;

#define BUFFER_SIZE 1024
static char uim_help_buf[BUFFER_SIZE];
/*Common buffer for some functions's temporary buffer.
  Pay attention for use.*/

int uim_helper_init_client_fd(char *path)
{
    int fd;
    struct sockaddr_un server;

    if(!path)
      return -1;

    memset(&server, 0, sizeof(server));
    
    server.sun_family = PF_UNIX;
    strcpy(server.sun_path, path);

    fd = socket(PF_UNIX, SOCK_STREAM, 0);
    if (fd < 0) {
      perror("fail to create socket");
      return -1;
    }

    if(connect(fd,&server,sizeof(server.sun_family)+ strlen(path))== -1){
      perror("failed to connect to server");
      return -1;
    }

    return fd;
}


void
uim_helper_client_focus_in(uim_context uc)
{
  uim_helper_client_focus(uc, 0);
}

void
uim_helper_client_focus_out(uim_context uc)
{
  uim_helper_client_focus(uc, 1);
}

static void
uim_helper_client_focus(uim_context uc, int flg)
{
  int id = uim_get_context_id(uc);

  if(uim_fd < 0)
    return;

  if(!id)
    return;

  if(flg == 0)
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_in:%d\n",  id);
  else
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_out:%d\n", id);

  uim_helper_send_message(uim_fd, uim_help_buf);
}


uim_helper_client_get_prop_list(void)
{
  snprintf(uim_help_buf, BUFFER_SIZE, "get_prop_list");
  uim_helper_send_message(uim_fd, uim_help_buf);
}
