#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>
#include "context.h"

static int uim_fd;
static void (*uim_disconnect_cb)(void);

#define BUFFER_SIZE 1024
static char uim_help_buf[BUFFER_SIZE];
/*Common buffer for some functions's temporary buffer.
  Pay attention for use.*/

int uim_helper_init_client_fd(void (*disconnect_cb)(void))
{
    int fd;
    struct sockaddr_un server;
    char *path = uim_helper_get_pathname();

    uim_fd = -1;

    if(!path)
      return -1;

    memset(&server, 0, sizeof(server));
    
    server.sun_family = PF_UNIX;
    strcpy(server.sun_path, path);
    free(path);

    fd = socket(PF_UNIX, SOCK_STREAM, 0);
    if (fd < 0) {
      perror("fail to create socket");
      return -1;
    }

    if(connect(fd,&server,sizeof(server)) == -1){
      perror("failed to connect to server");
      return -1;
    }

    uim_fd = fd;
    return fd;
}


void
uim_helper_client_focus_in(uim_context uc)
{
  uim_helper_client_focus(uc, 0);
}

void
uim_helper_client_focus_out(uim_context uc)
{
  uim_helper_client_focus(uc, 1);
}

static void
uim_helper_client_focus(uim_context uc, int flg)
{
  if(uim_fd < 0)
    return;

  if(!uc || !uc->global_id || uc->global_id < 0)
    return;

  if(flg == 0)
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_in:%d\n",  uc->global_id);
  else
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_out:%d\n", uc->global_id);

  uim_helper_send_message(uim_fd, uim_help_buf);
}



void
uim_helper_client_get_prop_list(void)
{
  snprintf(uim_help_buf, BUFFER_SIZE, "prop_list_get\n");
  uim_helper_send_message(uim_fd, uim_help_buf);
}


int
uim_helper_manage_context(uim_context uc)
{
  char buf[1024];
  int i,rc;

  uc->global_id = -1;


  write(uim_fd, "new_context\n", strlen("new_context\n"));
  rc = read(uim_fd, buf, sizeof(buf)-1);
  buf[rc] = '\0';
  sscanf(buf,
	 "new_context:%d\n", &(uc->global_id));      
  
  printf("new context id:%d\n",(uc->global_id));
  
  return uc->global_id; 
}

void
uim_helper_read_proc(void)
{
  // currently do nothing
}
