#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "comm.h"

static Display *dpy;
static Atom jmode_input_mode;
static Atom jmode_input_stat;
static int mode;

static int
X_error_handler(Display *dpy, XErrorEvent *ev)
{
  return 0;
}

int
init_comm()
{
  mode = -1;

  dpy = XOpenDisplay("");
  if (!dpy) {
    printf("display?");
    return -1;
  }
  XSetErrorHandler(X_error_handler);
  jmode_input_mode = XInternAtom(dpy, "JMODE_INPUT_MODE", 0);
  jmode_input_stat = XInternAtom(dpy, "JMODE_INPUT_STAT", 0);
  XSelectInput(dpy, DefaultRootWindow(dpy), PropertyChangeMask);
  XFlush(dpy);
  return XConnectionNumber(dpy);
}

void
proc_comm(void (*fn)(struct comm_event *))
{
  XEvent ev;

  while (XPending(dpy)) {
    XNextEvent(dpy, &ev);
    if (ev.type == PropertyNotify) {
      if (ev.xproperty.atom == jmode_input_mode) {
	Atom type;
	int format;
	unsigned long nr_prop,nr_bytes;	
	int *prop;
	struct comm_event ce;
	XGetWindowProperty(dpy, DefaultRootWindow(dpy), jmode_input_mode,
			   0, 1, False, XA_INTEGER, &type, &format,
			   &nr_prop, &nr_bytes, (unsigned char **)&prop);
	ce.type = COMM_EVENT_MODE;
	ce.nr = prop[0];
	if (mode != prop[0]) {
	  mode = prop[0];
	  fn(&ce);
	}
      } else if (ev.xproperty.atom == jmode_input_stat) {
	Atom type;
	int format;
	unsigned long nr_prop,nr_bytes;	
	int *prop;
	struct comm_event ce;
	XGetWindowProperty(dpy, DefaultRootWindow(dpy), jmode_input_stat,
			   0, 1, False, XA_INTEGER, &type, &format,
			   &nr_prop, &nr_bytes, (unsigned char **)&prop);
	ce.type = COMM_EVENT_STAT;
	ce.nr = prop[0];
	fn(&ce);
      }
    }
  }
}

void
comm_set_mode(int m)
{
  if (m != mode) {
    mode = m;
    XChangeProperty(dpy, DefaultRootWindow(dpy), jmode_input_mode,
		    XA_INTEGER,
		    32, PropModeReplace, (unsigned char *)&m, 1);
    XFlush(dpy);
  }
}
