#include <gtk/gtk.h>
#include <stdlib.h>
#include <locale.h>

#include "comm.h"
#include "on.xpm"
#include "off.xpm"

static GtkWidget *opt_menu;
static GtkWidget *draw_win;
static int event_fd;
static GdkPixmap *on_pixmap, *off_pixmap;
static int jmode_stat;

#ifdef GTK2_FE
static char kanji_mode_str[] = {0xe3,0x81,0x82,0};
#else
static char kanji_mode_str[] = "";
#endif

static gint
activate_event(GtkWidget *g, gpointer p)
{
  comm_set_mode((int)p);
}

static void add_mode(GtkWidget *menu, char *mode, int idx)
{
  GtkWidget *item;
  item = gtk_menu_item_new_with_label(mode);
  gtk_menu_append(GTK_MENU(menu), item);
  gtk_signal_connect(item, "activate",
		     GTK_SIGNAL_FUNC(activate_event), (void *)idx);
  gtk_widget_show(item);
}

static gint toolbar_expose(GtkWidget *w, GdkEventExpose *e)
{
  GdkPixmap *pix;
  if (jmode_stat) {
    pix = on_pixmap;
  } else {
    pix = off_pixmap;
  }
  gdk_draw_pixmap(w->window,
		  w->style->fg_gc[GTK_WIDGET_STATE (w)],
		  pix,0,0,0,0,12,32);
  return FALSE;
}

static void handler(struct comm_event *ev)
{
  if (ev->type == COMM_EVENT_MODE) {
    gtk_option_menu_set_history(GTK_OPTION_MENU(opt_menu), ev->nr);
  }
  if (ev->type == COMM_EVENT_STAT) {
    jmode_stat = ev->nr;
    toolbar_expose(draw_win, NULL);
  }
}

static void fd_handler(gpointer p, gint fd,
		       GdkInputCondition c)
{
  proc_comm(handler);
}

static void init_xpm()
{
    GdkBitmap *mask;
    GtkStyle *style;
    style = gtk_widget_get_style(draw_win);
    on_pixmap = gdk_pixmap_create_from_xpm_d(draw_win->window,&mask,
					     &style->bg[GTK_STATE_NORMAL],
					     (gchar **)on_xpm);
    off_pixmap = gdk_pixmap_create_from_xpm_d(draw_win->window,&mask,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **)off_xpm);
}

static void init_toolbar()
{
  GtkWidget *top_win;
  GtkWidget *hbox;
  GtkWidget *menu;

  top_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  menu = gtk_menu_new();

  hbox = gtk_hbox_new(FALSE, 0);
  add_mode(menu, "a", 0);
  add_mode(menu, kanji_mode_str, 1);

  gtk_widget_show(menu);

  opt_menu = gtk_option_menu_new();
  gtk_widget_show(opt_menu);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(opt_menu), menu);

  gtk_box_pack_start(GTK_BOX(hbox), opt_menu, FALSE, FALSE, 2);

  draw_win = gtk_drawing_area_new();
  gtk_widget_set_usize(GTK_WIDGET(draw_win),16,36);  
  gtk_widget_show(draw_win);
  gtk_box_pack_start(GTK_BOX(hbox), draw_win, FALSE, FALSE, 2);
  gtk_signal_connect(GTK_OBJECT(draw_win), "expose_event",
		     (GtkSignalFunc)toolbar_expose, NULL);

  gtk_container_add(GTK_CONTAINER(top_win), hbox);
  gtk_widget_show(hbox);
  gtk_widget_show(top_win);

  init_xpm();
}

int main(int argc, char **argv)
{

  putenv("LANG=ja_JP");
  setlocale(LC_ALL, "ja_JP");
  
  event_fd = init_comm();
  jmode_stat = 0;
  gtk_init(&argc, &argv);
  gtk_set_locale();
  init_toolbar();
  gdk_input_add(event_fd, (GdkInputCondition)GDK_INPUT_READ,
		fd_handler, 0);
  gtk_main();
  return 0;
}
