/* jmode launcher */
#include "config.h"

#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static char *pref_fe;

static struct fe_info {
  char *name;
} fe_info_list[] = {
#ifdef USE_GTK2
  {"gtk2"},
#endif
#ifdef USE_GTK1
  {"gtk1"},
#endif
#ifdef USE_GNOME2
  {"gnome2"},
#endif
#ifdef USE_QT
  {"qt"},
#endif
  {0}
};

static void
select_fe()
{
  struct fe_info *fi;
  for (fi = fe_info_list; fi->name; fi++) {
  }
}

static int
do_exec(char *cmd, char **args)
{
  pid_t p;
  p = fork();
  if (p > 0) {
    printf("exec %s\n", cmd);
    execv(cmd, args);
    exit(0);
  }
  if (p < 0) {
    printf("failed\n");
  }
  return p;
}

static void
print_usage()
{
  struct fe_info *fi;
  printf("jmode {");
  for (fi = fe_info_list; fi->name; fi++) {
    printf("%s ", fi->name);
  }
  printf("}\n");
  exit(0);
}

static void
parse_args(int argc, char **argv)
{
  int i;
  for (i = 1; i < argc; i++) {
    char *arg = argv[i];
    if (!strncmp(arg, "--", 2)) {
      print_usage();
    } else {
      pref_fe = arg;
    }
  }
}

int
main(int argc, char **argv)
{
  char *arg[10];
  parse_args(argc, argv);
  select_fe();
  arg[0] = "/";
  arg[1] = NULL;
  signal(SIGCHLD, SIG_IGN);
  do_exec(EXEC_DIR"/jmode-xim", arg);

  if (pref_fe) {
    int line_len = strlen(EXEC_DIR) + 20;
    char *fe_line = alloca(line_len);
    snprintf(fe_line, line_len, EXEC_DIR"/jmode-%s-fe", pref_fe);
    do_exec(fe_line, arg);
  }
  return 0;

}
