// 1,selectΥ롼פݲƤ롢ΤȤgdkεǽȤäơ
// GUI Υ롼פ򤷤Ƥ롣
// 2,event dispatch for GtkWidget and Xlib Window.
// 3,XIM̿γΩԤ

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <sys/select.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <unistd.h>
#include <stdio.h>
#include <map>

#include "jmode.h"
#include "xdispatch.h"
#include "xim.h"

static Atom xim_servers;
static Atom server_heke;
static Atom locales;
static Atom transport;

// selection뤿Υɥ
Window gWnd;
//ѤΥǥץ쥤³
Display *gDpy;

struct fd_watch_struct {
    int mask;
    void (*fn)(int,int);
};
static std::map<int,fd_watch_struct> fd_watch_stat;

static void remove_current_fd_watch(int fd)
{
    std::map<int,fd_watch_struct>::iterator i;
    i = fd_watch_stat.find(fd);
    if (i == fd_watch_stat.end()) {
        return ;
    }
    fd_watch_stat.erase(i);
}

static void add_fd_watch(int fd, int mask, void (*fn)(int, int))
{
    remove_current_fd_watch(fd);

    fd_watch_struct s;
    s.mask = mask;
    s.fn = fn;
    std::pair<int,fd_watch_struct> p(fd, s);
    fd_watch_stat.insert(p);
}

void main_loop()
{
    fd_set rfds, wfds;
    while (1) {
	FD_ZERO(&rfds);
	FD_ZERO(&wfds);
	std::map<int,fd_watch_struct>::iterator it;
	int  fd_max = 0;
	for (it = fd_watch_stat.begin(); it != fd_watch_stat.end(); it++) {
	    int fd = it->first;
	    if (it->second.mask & READ_OK) {
		FD_SET(fd, &rfds);
	    }
	    if (it->second.mask & WRITE_OK) {
		FD_SET(fd, &wfds);
	    }
	    if (fd_max < fd) {
		fd_max = fd;
	    }
	}
	select(fd_max + 1, &rfds, &wfds, NULL, NULL);
	for (it = fd_watch_stat.begin(); it != fd_watch_stat.end(); it++) {
	    int fd = it->first;
	    if (FD_ISSET(fd, &rfds)) {
		it->second.fn(fd, READ_OK);
	    }
	    if (FD_ISSET(fd, &wfds)) {
		it->second.fn(fd, WRITE_OK);
	    }
	}
    }
}

static std::map<unsigned int, WindowIf *> window_watch_stat;

void
add_window_watch(Window id, WindowIf *w, int mask)
{
    std::pair<unsigned int,WindowIf *> p(id, w);
    window_watch_stat.insert(p);

    //٥ȥޥX.hƤΤƱͤĤ
    //˰¸ץϽ񤫤ʤ
    int emask = 0;
    if (mask & EXPOSE_MASK) {
	emask |= ExposureMask;
    }
    if (mask & STRUCTURE_NOTIFY_MASK) {
	emask |= StructureNotifyMask;
    }
    XSelectInput(gDpy, id, emask);
}

void
remove_window_watch(Window id)
{
    std::map<unsigned int,WindowIf *>::iterator i;
    i = window_watch_stat.find(id);
    if (i != window_watch_stat.end()) {
	window_watch_stat.erase(i);
    }
}

//
static void
registerAtoms()
{
    xim_servers = XInternAtom(gDpy, "XIM_SERVERS", 0);
    server_heke = XInternAtom(gDpy, "@server=jmode", 0);
    locales = XInternAtom(gDpy, "LOCALES", 0);
    transport = XInternAtom(gDpy, "TRANSPORT", 0);
}

static bool
registerProp()
{
    Atom type;
    int format;
    unsigned long nr_prop,nr_bytes;
    Atom *prop;
    int mode = PropModePrepend;
    int valuechange = 1;

    Window selection_owner;
    selection_owner = XGetSelectionOwner(gDpy, server_heke);
    if (selection_owner != None) {
	printf("Another instance exists.\n");
	return false;
    }


    XGetWindowProperty(gDpy, DefaultRootWindow(gDpy),
                       xim_servers, 0, 8192 ,False,
                       XA_ATOM, &type, &format,
                       &nr_prop, &nr_bytes, (unsigned char **)&prop);
    int i;
    if (type != XA_ATOM || format != 32) {
	mode = PropModeReplace;
    } else {
	for (i = 0 ; i < (int)nr_prop ; i++) {
	    if (prop[i] == server_heke) {
		mode = PropModeAppend;
		valuechange = 0;
		break;
	    }
	}
    }
    if (nr_prop) {
	XFree(prop);
    }

    XChangeProperty(gDpy, DefaultRootWindow(gDpy), xim_servers,
		    XA_ATOM, 32,
		    mode, (unsigned char *)&server_heke,
		    valuechange ? 1 : 0);
    return true;
}

bool
pretrans_register()
{
    gDpy = XOpenDisplay(NULL);
    if (!gDpy) {
        printf("failed to open display!\n");
        return false;
    }
    registerAtoms();
    if (!registerProp()) {
	XCloseDisplay(gDpy);
	return false;
    }
    XFlush(gDpy);
    scr_width = DisplayWidth(gDpy, 0);
    scr_height = DisplayHeight(gDpy, 0);
    return true;
}

static void
sendSelectionNotify(XEvent *ev, char *buf, int len)
{
    XEvent e;
    e.type = SelectionNotify;
    e.xselection.requestor = ev->xselectionrequest.requestor;
    e.xselection.selection = ev->xselectionrequest.selection;
    e.xselection.target = ev->xselectionrequest.target;
    e.xselection.time = ev->xselectionrequest.time;
    e.xselection.property = ev->xselectionrequest.property;
    XChangeProperty(gDpy, e.xselection.requestor,
                    e.xselection.property,
                    e.xselection.target,
                    8,PropModeReplace,
                    (unsigned char *)buf, len);
    XSendEvent(gDpy, e.xselection.requestor, 0, 0, &e);
    XFlush(gDpy);
}

void
notifyLocale(XEvent *ev)
{
    char buf[32];
    strcpy(buf,"@locale=ja_JP");
    sendSelectionNotify(ev, buf, strlen(buf)+1);
    if (g_option_mask & OPT_TRACE) {
	printf("selection notify request for locale.\n");
    }
}

void
notifyTransport(XEvent *ev)
{
    sendSelectionNotify(ev, "@transport=X/", 13+1);
    if (g_option_mask & OPT_TRACE) {
	printf("selection notify request for transport.\n");
    }
}

WindowIf *
findWindowIf(Window w)
{
    std::map<unsigned int,WindowIf *>::iterator i;
    i = window_watch_stat.find(w);
    if (i == window_watch_stat.end()) {
	return NULL;
    }
    return (*i).second;
}

WindowIf::~WindowIf()
{
}

void
WindowIf::resize(Window, int, int)
{
    // do nothing
}

static int
X_ErrorHandler(Display *d, XErrorEvent *e)
{
    if (g_option_mask & OPT_TRACE) {
	printf("X error occured.\n");
    }
    return 0;
}

static int
X_IOErrorHandler(Display *d)
{
    return 0;
}

void
ProcXEvent(XEvent *e)
{
    Atom p;
    switch (e->type) {
    case SelectionRequest:
    {
	p = e->xselectionrequest.property;
	if (p == locales) {
	    notifyLocale(e);
	} else if(p == transport) {
	    notifyTransport(e);
	} else {
	    printf("property %s?\n",
		   XGetAtomName(gDpy,e->xselection.property));
	    break;
	}
    }
    break;
    case Expose:
    {
	if (e->xexpose.count == 0) {
	    WindowIf *i = findWindowIf(e->xexpose.window);
	    if (i) {
		i->expose(e->xexpose.window);
	    }
	}
    }
    break;
    case ConfigureNotify:
    {
	WindowIf *i = findWindowIf(e->xconfigure.window);
	if (i) {
	    i->resize(e->xconfigure.window,
		      e->xconfigure.x, e->xconfigure.y);
	}
    }
    break;
    case DestroyNotify:
    {
	WindowIf *i = findWindowIf(e->xdestroywindow.window);
	if (i) {
	    i->destroy(e->xdestroywindow.window);
	}
	remove_window_watch(e->xdestroywindow.window);
    }
    break;
    case ClientMessage:
	procXClientMessage(&e->xclient);
    break;
    default:;
	//printf("unknown type of X event. %d\n",e->type);
    }
}

static void
xEventRead(int fd, int ev)
{
    XFlush(gDpy);

    XEvent e;
    while (XPending(gDpy)) {
	XNextEvent(gDpy, &e);
	ProcXEvent(&e);
    }
}

int
pretrans_setup()
{
    int fd;
  
    XSetErrorHandler(X_ErrorHandler);
    XSetIOErrorHandler(X_IOErrorHandler);
    gWnd = XCreateSimpleWindow(gDpy, DefaultRootWindow(gDpy),
                              0, 0, 1, 1,
			       1,0,0);

    XSetSelectionOwner(gDpy, server_heke, gWnd, CurrentTime);
    XSelectInput(gDpy, DefaultRootWindow(gDpy), 0);

    XSync(gDpy, False);

    fd = XConnectionNumber(gDpy);

    add_fd_watch(fd, READ_OK, xEventRead);

    return fd;
}
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
