/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.MissingImageReaderException;

public abstract class Filter {
    private static final Log LOG = LogFactory.getLog(Filter.class);
    public static final String SYSPROP_DEFLATELEVEL = "org.apache.pdfbox.filter.deflatelevel";

    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public final void encode(InputStream input, OutputStream encoded, COSDictionary parameters, int index) throws IOException {
        this.encode(input, encoded, parameters.asUnmodifiableDictionary());
    }

    protected abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSBase filter = dictionary.getDictionaryObject(COSName.FILTER, COSName.F);
        COSBase obj = dictionary.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        if (filter instanceof COSName && obj instanceof COSDictionary) {
            return (COSDictionary)obj;
        }
        if (filter instanceof COSArray && obj instanceof COSArray) {
            COSArray array = (COSArray)obj;
            if (index < array.size()) {
                return (COSDictionary)array.getObject(index);
            }
        } else if (obj != null && !(filter instanceof COSArray) && !(obj instanceof COSArray)) {
            LOG.error((Object)("Expected DecodeParams to be an Array or Dictionary but found " + obj.getClass().getName()));
        }
        return new COSDictionary();
    }

    protected static ImageReader findImageReader(String formatName, String errorCause) throws MissingImageReaderException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(formatName);
        ImageReader reader = null;
        while (readers.hasNext() && ((reader = readers.next()) == null || !reader.canReadRaster())) {
        }
        if (reader == null) {
            throw new MissingImageReaderException("Cannot read " + formatName + " image: " + errorCause);
        }
        return reader;
    }
}

