/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction.text;

import java.io.IOException;
import java.util.List;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.instruction.text.TextBufferingInstruction;
import org.apache.fontbox.ttf.TrueTypeFont;

public class Font
extends TextBufferingInstruction {
    private String fontName;
    private float fontSize = Float.NaN;

    public Font(int indent, List<Object> params) throws IOException {
        super(indent, params);
        String name;
        TrueTypeFont ttf;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            Object obj = params.get(i);
            if (obj instanceof Number) {
                this.fontSize = ((Number)obj).floatValue();
                continue;
            }
            if (!(obj instanceof String)) continue;
            sb.append(' ');
            sb.append(obj);
        }
        if (sb.length() >= 2 && (ttf = FontLoader.get(name = sb.substring(1))) != null) {
            this.fontName = ttf.getName();
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }
}

