package net.osdn.util.yaml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

import com.esotericsoftware.yamlbeans.YamlReader;

/**
 * 
 */
public class Yaml {
	
	private static Charset UTF_8 = Charset.forName("UTF-8");
	
	private Object root;
	private Map<String, Object> map;
	private List<Object> list;
	private String trailer;
	
	/** 
	 * コンストラクタ
	 * 
	 * @param file　
	 * @throws IOException
	 */
	public Yaml(File file) throws IOException {
		if(file == null) {
			throw new NullPointerException();
		}
		
		Charset charset = CharsetDetector.detectCharset(file);
		if(charset == null) {
			charset = UTF_8;
		}

		StringBuilder header = new StringBuilder();
		StringBuilder trailer = null;
		
		BufferedReader reader = null;
		try {
			boolean isFirst = true;
			reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), charset));
			String line;
			while((line = reader.readLine()) != null) {
				//最初の読み取りが 0xFEFF で始まる場合、UTF-8のBOMと見なして除去します。
				if(isFirst) {
					if(charset.equals(UTF_8) && line.length() > 0 && line.charAt(0) == (char)0xFEFF) {
						line = line.substring(1);
					}
					isFirst = false;
				}
				if(trailer == null && header.length() == 0 && line.length() > 0 && line.charAt(0) == (char)0xFEFF) {
				}
				if(trailer == null && line.startsWith("...") && (line.length() == 3 || line.substring(3).trim().length() == 0)) {
					trailer = new StringBuilder();
				} else if(trailer == null) {
					header.append(line);
					header.append('\n');
				} else {
					trailer.append(line);
					trailer.append('\n');
				}
			}
			
			root = new YamlReader(header.toString()).read();
			if(root instanceof Map) {
				@SuppressWarnings("unchecked")
				Map<String, Object> map = (Map<String, Object>)root;
				this.map = map;
			} else if(root instanceof List) {
				@SuppressWarnings("unchecked")
				List<Object> list = (List<Object>)root;
				this.list = list;
			}
					
			if(trailer != null) {
				this.trailer = trailer.toString();
			}
		} finally {
			if(reader != null) {
				reader.close();
			}
		}
	}
	
	/** 指定したキーが存在するか確認します。
	 * 
	 * @param key
	 * @return
	 */
	public boolean containsKey(String key) {
		return this.map.containsKey(key);
	}
	
	public boolean containsValue(Object value) {
		return this.map.containsValue(value);
	}
	
	public Object get(String key) {
		return this.map.get(key);
	}
	
	public String getTrailer() {
		return this.trailer;
	}
	
	public Object getRoot() {
		return root;
	}
	
	public Map<String, Object> getMap() {
		return this.map;
	}
	
	public List<Object> getList() {
		return this.list;
	}
}
