/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro;

import java.io.PrintStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.ProportionalDivision;

public class AccountSettlement {
    private boolean isSoloProprietorship;
    private LocalDate date;
    private Set<AccountTitle> accountTitles;
    private PrintStream out;

    public AccountSettlement(Set<AccountTitle> accountTitles, boolean isSoloproprietorship) {
        this.accountTitles = accountTitles;
        this.isSoloProprietorship = isSoloproprietorship;
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public void addClosingEntries(List<JournalEntry> journalEntries, List<ProportionalDivision> proportionalDivisions) {
        String description;
        JournalEntry entry;
        Debtor debtor;
        Iterator debtor2;
        JournalEntry entry2;
        Object creditor;
        Object creditor2;
        Object debtor3;
        List<JournalEntry> entries;
        long total;
        JournalEntry entry32;
        AccountTitle ownersDrawing;
        if (this.date == null) {
            this.date = AccountSettlement.getClosingDate(journalEntries, this.isSoloProprietorship);
        }
        if (this.date == null) {
            throw new IllegalStateException("\u6c7a\u7b97\u65e5\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (proportionalDivisions != null && (ownersDrawing = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u8cb8")) != null) {
            JournalEntry entry4;
            ArrayList<Debtor> debtors = new ArrayList<Debtor>();
            ArrayList<Creditor> creditors = new ArrayList<Creditor>();
            for (ProportionalDivision proportionalDivision : proportionalDivisions) {
                double total2;
                long longTotal;
                long debtorTotal = 0L;
                long creditorTotal = 0L;
                for (int i = 0; i < journalEntries.size(); ++i) {
                    entry32 = journalEntries.get(i);
                    for (Debtor debtor4 : entry32.getDebtors()) {
                        if (!debtor4.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                        debtorTotal += debtor4.getAmount();
                    }
                    for (Creditor creditor3 : entry32.getCreditors()) {
                        if (!creditor3.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                        creditorTotal += creditor3.getAmount();
                    }
                }
                if (debtorTotal > creditorTotal) {
                    double total3 = (double)(debtorTotal - creditorTotal) * (1.0 - proportionalDivision.getBusinessRatio());
                    long longTotal2 = (long)Math.floor(total3);
                    if (longTotal2 == 0L) continue;
                    creditors.add(new Creditor(proportionalDivision.getAccountTitle(), longTotal2));
                    continue;
                }
                if (creditorTotal <= debtorTotal || (longTotal = (long)Math.floor(total2 = (double)(creditorTotal - debtorTotal) * (1.0 - proportionalDivision.getBusinessRatio()))) == 0L) continue;
                debtors.add(new Debtor(proportionalDivision.getAccountTitle(), longTotal));
            }
            if (debtors.size() > 0) {
                long creditorTotal = 0L;
                for (Debtor debtor5 : debtors) {
                    creditorTotal += debtor5.getAmount();
                }
                Creditor creditor4 = new Creditor(ownersDrawing, creditorTotal);
                entry4 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", debtors, Arrays.asList(creditor4));
                journalEntries.add(entry4);
            }
            if (creditors.size() > 0) {
                long debtorTotal = 0L;
                for (Creditor creditor5 : creditors) {
                    debtorTotal += creditor5.getAmount();
                }
                Debtor debtor6 = new Debtor(ownersDrawing, debtorTotal);
                entry4 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", Arrays.asList(debtor6), creditors);
                journalEntries.add(entry4);
            }
            if (this.out != null && (debtors.size() > 0 || creditors.size() > 0)) {
                this.out.println("  \u5bb6\u4e8b\u6309\u5206\u306e\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
        }
        AccountTitle karibarai = AccountTitle.getByDisplayName(this.accountTitles, "\u4eee\u6255\u6d88\u8cbb\u7a0e\u7b49");
        AccountTitle kariuke = AccountTitle.getByDisplayName(this.accountTitles, "\u4eee\u53d7\u6d88\u8cbb\u7a0e\u7b49");
        AccountTitle misyuu = AccountTitle.getByDisplayName(this.accountTitles, "\u672a\u53ce\u6d88\u8cbb\u7a0e\u7b49");
        AccountTitle mibarai = AccountTitle.getByDisplayName(this.accountTitles, "\u672a\u6255\u6d88\u8cbb\u7a0e\u7b49");
        if (karibarai != null && kariuke != null) {
            boolean existsSettlement = false;
            long karibaraiTotal = 0L;
            long kariukeTotal = 0L;
            for (int i = 0; i < journalEntries.size(); ++i) {
                entry32 = journalEntries.get(i);
                for (Debtor debtor4 : entry32.getDebtors()) {
                    if (debtor4.getAccountTitle().equals(karibarai)) {
                        karibaraiTotal += debtor4.getAmount();
                    }
                    if (debtor4.getAccountTitle().equals(kariuke)) {
                        kariukeTotal -= debtor4.getAmount();
                    }
                    if (misyuu != null && debtor4.getAccountTitle().equals(misyuu)) {
                        existsSettlement = true;
                    }
                    if (mibarai == null || !debtor4.getAccountTitle().equals(mibarai)) continue;
                    existsSettlement = true;
                }
                for (Creditor creditor3 : entry32.getCreditors()) {
                    if (creditor3.getAccountTitle().equals(kariuke)) {
                        kariukeTotal += creditor3.getAmount();
                    }
                    if (creditor3.getAccountTitle().equals(karibarai)) {
                        karibaraiTotal -= creditor3.getAmount();
                    }
                    if (mibarai != null && creditor3.getAccountTitle().equals(mibarai)) {
                        existsSettlement = true;
                    }
                    if (misyuu == null || !creditor3.getAccountTitle().equals(misyuu)) continue;
                    existsSettlement = true;
                }
            }
            if (!(existsSettlement || karibaraiTotal == 0L && kariukeTotal == 0L)) {
                ArrayList<Debtor> debtors = new ArrayList<Debtor>();
                ArrayList<Creditor> creditors = new ArrayList<Creditor>();
                if (kariukeTotal > 0L) {
                    debtors.add(new Debtor(kariuke, kariukeTotal));
                } else if (kariukeTotal < 0L) {
                    creditors.add(new Creditor(kariuke, -kariukeTotal));
                }
                if (karibaraiTotal > 0L) {
                    creditors.add(new Creditor(karibarai, karibaraiTotal));
                } else if (karibaraiTotal < 0L) {
                    debtors.add(new Debtor(karibarai, -karibaraiTotal));
                }
                if (kariukeTotal - karibaraiTotal >= 0L) {
                    if (mibarai != null) {
                        creditors.add(new Creditor(mibarai, kariukeTotal - karibaraiTotal));
                        JournalEntry e = new JournalEntry(this.date, "\u672a\u6255\u6d88\u8cbb\u7a0e\u7b49\u3078\u306e\u632f\u66ff", debtors, creditors);
                        journalEntries.add(e);
                        if (this.out != null && (debtors.size() > 0 || creditors.size() > 0)) {
                            this.out.println("  \u6d88\u8cbb\u7a0e\u7b49\u306e\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                        }
                    }
                } else if (misyuu != null) {
                    debtors.add(new Debtor(misyuu, karibaraiTotal - kariukeTotal));
                    JournalEntry e = new JournalEntry(this.date, "\u672a\u53ce\u6d88\u8cbb\u7a0e\u7b49\u3078\u306e\u632f\u66ff", debtors, creditors);
                    journalEntries.add(e);
                    if (this.out != null && (debtors.size() > 0 || creditors.size() > 0)) {
                        this.out.println("  \u6d88\u8cbb\u7a0e\u7b49\u306e\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                    }
                }
            }
        }
        LinkedHashSet<AccountTitle> revenueAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> expenseAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> assetsAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> liabilitiesAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> equityAccountTitles = new LinkedHashSet<AccountTitle>();
        for (JournalEntry entry32 : journalEntries) {
            for (Creditor creditor3 : entry32.getCreditors()) {
                if (creditor3.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(creditor3.getAccountTitle());
                }
                if (creditor3.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(creditor3.getAccountTitle());
                }
                if (creditor3.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor3.getAccountTitle());
                }
                if (creditor3.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor3.getAccountTitle());
            }
            for (Debtor debtor4 : entry32.getDebtors()) {
                if (debtor4.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(debtor4.getAccountTitle());
                }
                if (debtor4.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(debtor4.getAccountTitle());
                }
                if (debtor4.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor4.getAccountTitle());
                }
                if (debtor4.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor4.getAccountTitle());
            }
        }
        long incomeSummary = 0L;
        ArrayList<Debtor> debtors = new ArrayList<Debtor>();
        long debtorsTotal = 0L;
        ArrayList<Creditor> creditors = new ArrayList<Creditor>();
        long creditorsTotal = 0L;
        for (AccountTitle accountTitle : revenueAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry5 : entries) {
                for (Creditor creditor6 : entry5.getCreditors()) {
                    if (!creditor6.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor6.getAmount();
                }
                for (Debtor debtor7 : entry5.getDebtors()) {
                    if (!debtor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor7.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
            } else {
                creditor2 = new Creditor(accountTitle, -total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += -total;
            }
            incomeSummary += total;
        }
        if (debtors.size() > 0) {
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry2 = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry2);
        }
        if (creditors.size() > 0) {
            debtor2 = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry2 = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry2);
        }
        if (this.out != null) {
            this.out.println("  \u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : expenseAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry5 : entries) {
                for (Debtor debtor7 : entry5.getDebtors()) {
                    if (!debtor7.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor7.getAmount();
                }
                for (Creditor creditor6 : entry5.getCreditors()) {
                    if (!creditor6.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor6.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
            } else {
                debtor3 = new Debtor(accountTitle, -total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += -total;
            }
            incomeSummary -= total;
        }
        if (creditors.size() > 0) {
            debtor2 = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry2 = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry2);
        }
        if (debtors.size() > 0) {
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry2 = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", (List<Debtor>)debtors, Arrays.asList(creditor));
            journalEntries.add(entry2);
        }
        if (this.out != null) {
            this.out.println("  \u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry6 : journalEntries) {
            for (Creditor creditor7 : entry6.getCreditors()) {
                if (creditor7.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor7.getAccountTitle());
                }
                if (creditor7.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor7.getAccountTitle());
            }
            for (Debtor debtor8 : entry6.getDebtors()) {
                if (debtor8.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor8.getAccountTitle());
                }
                if (debtor8.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor8.getAccountTitle());
            }
        }
        if (incomeSummary >= 0L) {
            debtor = new Debtor(AccountTitle.INCOME_SUMMARY, incomeSummary);
            Creditor creditor8 = this.isSoloProprietorship ? new Creditor(AccountTitle.PRETAX_INCOME, incomeSummary) : new Creditor(AccountTitle.RETAINED_EARNINGS, incomeSummary);
            entry = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor), Arrays.asList(creditor8));
            journalEntries.add(entry);
        } else if (incomeSummary < 0L) {
            debtor = this.isSoloProprietorship ? new Debtor(AccountTitle.PRETAX_INCOME, -incomeSummary) : new Debtor(AccountTitle.RETAINED_EARNINGS, -incomeSummary);
            Creditor creditor9 = new Creditor(AccountTitle.INCOME_SUMMARY, -incomeSummary);
            entry = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor), Arrays.asList(creditor9));
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : assetsAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry5 : entries) {
                for (Debtor debtor7 : entry5.getDebtors()) {
                    if (!debtor7.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor7.getAmount();
                }
                for (Creditor creditor6 : entry5.getCreditors()) {
                    if (!creditor6.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor6.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            debtor3 = new Debtor(accountTitle, -total);
            debtors.add((Debtor)debtor3);
            debtorsTotal += -total;
        }
        if (creditors.size() > 0) {
            debtor2 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry2 = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry2);
        }
        if (debtors.size() > 0) {
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry2 = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry2);
        }
        if (this.out != null) {
            this.out.println("  \u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : liabilitiesAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry5 : entries) {
                for (Creditor creditor6 : entry5.getCreditors()) {
                    if (!creditor6.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor6.getAmount();
                }
                for (Debtor debtor7 : entry5.getDebtors()) {
                    if (!debtor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor7.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        if (debtors.size() > 0) {
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry2 = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry2);
        }
        if (creditors.size() > 0) {
            debtor2 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry2 = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry2);
        }
        if (this.out != null) {
            this.out.println("  \u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry7 : journalEntries) {
            for (Creditor creditor7 : entry7.getCreditors()) {
                if (creditor7.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(creditor7.getAccountTitle());
            }
            for (Debtor debtor8 : entry7.getDebtors()) {
                if (debtor8.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(debtor8.getAccountTitle());
            }
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : equityAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry5 : entries) {
                for (Creditor creditor6 : entry5.getCreditors()) {
                    if (!creditor6.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor6.getAmount();
                }
                for (Debtor debtor7 : entry5.getDebtors()) {
                    if (!debtor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor7.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        String string = description = this.isSoloProprietorship ? "\u8cc7\u672c\u306e\u6b8b\u9ad8\u632f\u66ff" : "\u7d14\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff";
        if (debtors.size() > 0) {
            Creditor creditor10 = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, debtors, Arrays.asList(creditor10));
            journalEntries.add(incomeSummaryEntry);
        }
        if (creditors.size() > 0) {
            Debtor debtor9 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, Arrays.asList(debtor9), creditors);
            journalEntries.add(incomeSummaryEntry);
        }
        if (this.out != null) {
            this.out.println("  " + description + "\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static LocalDate getOpeningDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        for (JournalEntry entry : journalEntries) {
            if (date == null) {
                date = entry.getDate();
                continue;
            }
            if (!entry.getDate().isBefore(date)) continue;
            date = entry.getDate();
        }
        return date;
    }

    public static LocalDate getClosingDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        if (isSoloProprietorship) {
            if (journalEntries.size() > 0) {
                JournalEntry entry = journalEntries.get(0);
                date = LocalDate.of(entry.getDate().getYear(), 12, 31);
            }
        } else {
            LocalDate opening = null;
            for (JournalEntry entry : journalEntries) {
                if (opening == null) {
                    opening = entry.getDate();
                    continue;
                }
                if (!entry.getDate().isBefore(opening)) continue;
                opening = entry.getDate();
            }
            date = opening.plusYears(1L).minusMonths(1L);
            date = date.withDayOfMonth(date.lengthOfMonth());
        }
        return date;
    }

    public static List<JournalEntry> getJournalEntriesByAccount(List<JournalEntry> journalEntries, AccountTitle accountTitle) {
        ArrayList<JournalEntry> entriesByAccount = new ArrayList<JournalEntry>();
        if (accountTitle != null) {
            for (JournalEntry entry : journalEntries) {
                for (Debtor debtor : entry.getDebtors()) {
                    if (!accountTitle.equals(debtor.getAccountTitle()) || entriesByAccount.contains(entry)) continue;
                    entriesByAccount.add(entry);
                }
                for (Creditor creditor : entry.getCreditors()) {
                    if (!accountTitle.equals(creditor.getAccountTitle()) || entriesByAccount.contains(entry)) continue;
                    entriesByAccount.add(entry);
                }
            }
        }
        return entriesByAccount;
    }
}

