/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.model;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntryError;

public class JournalEntry {
    private LocalDate date;
    private String description;
    private List<Debtor> debtors;
    private List<Creditor> creditors;
    private JournalEntryError error;
    private String yaml;

    public JournalEntry() {
        this(null, "", null, null);
    }

    public JournalEntry(LocalDate date, String description, List<Debtor> debtors, List<Creditor> creditors) {
        this.date = date;
        this.description = description;
        this.debtors = debtors;
        this.creditors = creditors;
        if (this.debtors == null) {
            this.debtors = new ArrayList<Debtor>();
        }
        if (this.creditors == null) {
            this.creditors = new ArrayList<Creditor>();
        }
        this.updateYaml();
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Debtor> getDebtors() {
        return this.debtors;
    }

    public List<Creditor> getCreditors() {
        return this.creditors;
    }

    public boolean isEmpty() {
        return !(this.date != null || this.description != null && !this.description.isBlank() || this.debtors != null && this.debtors.size() != 0 || this.creditors != null && this.creditors.size() != 0);
    }

    public boolean isOpening() {
        String displayName;
        if (this.isClosing()) {
            return false;
        }
        for (Debtor debtor : this.debtors) {
            displayName = debtor.getAccountTitle().getDisplayName();
            if (!displayName.equals("\u5143\u5165\u91d1")) continue;
            return true;
        }
        for (Creditor creditor : this.creditors) {
            displayName = creditor.getAccountTitle().getDisplayName();
            if (!displayName.equals("\u5143\u5165\u91d1")) continue;
            return true;
        }
        return this.description.equals("\u524d\u671f\u7e70\u8d8a") || this.description.equals("\u958b\u59cb\u6b8b\u9ad8") || this.description.equals("\u8cc7\u672c\u91d1");
    }

    public boolean isClosing() {
        for (Debtor debtor : this.debtors) {
            if (!debtor.getAccountTitle().isClosing()) continue;
            return true;
        }
        for (Creditor creditor : this.creditors) {
            if (!creditor.getAccountTitle().isClosing()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncomeSummary() {
        for (Debtor debtor : this.debtors) {
            if (!debtor.getAccountTitle().equals(AccountTitle.INCOME_SUMMARY)) continue;
            return true;
        }
        for (Creditor creditor : this.creditors) {
            if (!creditor.getAccountTitle().equals(AccountTitle.INCOME_SUMMARY)) continue;
            return true;
        }
        return false;
    }

    public boolean isBalance() {
        for (Debtor debtor : this.debtors) {
            if (!debtor.getAccountTitle().equals(AccountTitle.BALANCE)) continue;
            return true;
        }
        for (Creditor creditor : this.creditors) {
            if (!creditor.getAccountTitle().equals(AccountTitle.BALANCE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        if (this.error == null) {
            this.validate();
        }
        return this.error.getErrorType() != JournalEntryError.ErrorType.NO_ERROR;
    }

    public JournalEntryError getError() {
        if (this.error == null) {
            this.validate();
        }
        return this.error;
    }

    public JournalEntryError validate() {
        if (this.date == null) {
            this.error = JournalEntryError.NO_DATE;
            return this.error;
        }
        if (this.description.isEmpty()) {
            this.error = JournalEntryError.NO_DESCRIPTION;
            return this.error;
        }
        if (this.debtors.size() == 0 && this.creditors.size() == 0) {
            this.error = JournalEntryError.NO_ACCOUNT;
            return this.error;
        }
        long debtorsAmount = 0L;
        for (Debtor debtor : this.debtors) {
            if (debtor.getAmount() < 0L) {
                this.error = new JournalEntryError(JournalEntryError.ErrorType.NO_DEBTOR_AMOUNT, debtor.getAccountTitle());
                return this.error;
            }
            debtorsAmount += debtor.getAmount();
        }
        long creditorsAmount = 0L;
        for (Creditor creditor : this.creditors) {
            if (creditor.getAmount() < 0L) {
                this.error = new JournalEntryError(JournalEntryError.ErrorType.NO_CREDITOR_AMOUNT, creditor.getAccountTitle());
                return this.error;
            }
            creditorsAmount += creditor.getAmount();
        }
        if (this.debtors.size() == 0) {
            this.error = JournalEntryError.NO_DEBTOR;
            return this.error;
        }
        if (this.creditors == null || this.creditors.size() == 0) {
            this.error = JournalEntryError.NO_CREDITOR;
            return this.error;
        }
        if (debtorsAmount != creditorsAmount) {
            this.error = JournalEntryError.NOT_MATCH_AMOUNT;
            return this.error;
        }
        this.error = JournalEntryError.NO_ERROR;
        return this.error;
    }

    public String updateYaml() {
        String displayName;
        AccountTitle accountTitle;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("- \"\u65e5\u4ed8\" : ");
        if (this.date != null) {
            sb.append('\"');
            sb.append(DateTimeFormatter.ISO_LOCAL_DATE.format(this.date));
            sb.append("\"\r\n");
        } else {
            sb.append("null\r\n");
        }
        sb.append("  \"\u6458\u8981\" : \"");
        if (this.description != null) {
            sb.append(YamlBeansUtil.escape(this.description));
        }
        sb.append("\"\r\n");
        sb.append("  \"\u501f\u65b9\" : [ ");
        for (i = 0; i < this.debtors.size(); ++i) {
            Debtor debtor = this.debtors.get(i);
            sb.append("{\"\u52d8\u5b9a\u79d1\u76ee\" : ");
            accountTitle = debtor.getAccountTitle();
            displayName = accountTitle != null ? accountTitle.getDisplayName() : null;
            sb.append((String)(displayName != null ? "\"" + YamlBeansUtil.escape(displayName) + "\"" : "null"));
            sb.append(", \"\u91d1\u984d\" : ");
            sb.append(Long.toString(debtor.getAmount()));
            if (i + 1 < this.debtors.size()) {
                sb.append("}, ");
                continue;
            }
            sb.append("} ");
        }
        sb.append("]\r\n");
        sb.append("  \"\u8cb8\u65b9\" : [ ");
        for (i = 0; i < this.creditors.size(); ++i) {
            Creditor creditor = this.creditors.get(i);
            sb.append("{\"\u52d8\u5b9a\u79d1\u76ee\" : ");
            accountTitle = creditor.getAccountTitle();
            displayName = accountTitle != null ? accountTitle.getDisplayName() : null;
            sb.append((String)(displayName != null ? "\"" + YamlBeansUtil.escape(displayName) + "\"" : "null"));
            sb.append(", \"\u91d1\u984d\" : ");
            sb.append(Long.toString(creditor.getAmount()));
            if (i + 1 < this.creditors.size()) {
                sb.append("}, ");
                continue;
            }
            sb.append("} ");
        }
        sb.append("]\r\n");
        this.yaml = sb.toString();
        return this.yaml;
    }

    public String getYaml() {
        if (this.yaml == null) {
            this.updateYaml();
        }
        return this.yaml;
    }

    public JournalEntry clone() {
        ArrayList<Debtor> debtors = new ArrayList<Debtor>(this.debtors.size());
        for (Debtor debtor : this.debtors) {
            debtors.add(debtor.clone());
        }
        ArrayList<Creditor> creditors = new ArrayList<Creditor>(this.creditors.size());
        for (Creditor creditor : this.creditors) {
            creditors.add(creditor.clone());
        }
        return new JournalEntry(this.date, this.description, debtors, creditors);
    }

    public String toString() {
        String displayName;
        AccountTitle accountTitle;
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.date != null) {
            sb.append(DateTimeFormatter.ISO_LOCAL_DATE.format(this.date));
        } else {
            sb.append("null");
        }
        sb.append(", \u501f\u65b9:[");
        for (i = 0; i < this.debtors.size(); ++i) {
            Debtor debtor = this.debtors.get(i);
            sb.append("{");
            accountTitle = debtor.getAccountTitle();
            displayName = accountTitle != null ? accountTitle.getDisplayName() : null;
            sb.append(displayName != null ? displayName : "null");
            sb.append(":");
            sb.append(debtor.getAmount());
            sb.append("}");
            if (i + 1 >= this.debtors.size()) continue;
            sb.append(", ");
        }
        sb.append("], \u8cb8\u65b9:[");
        for (i = 0; i < this.creditors.size(); ++i) {
            Creditor creditor = this.creditors.get(i);
            sb.append("{");
            accountTitle = creditor.getAccountTitle();
            displayName = accountTitle != null ? accountTitle.getDisplayName() : null;
            sb.append(displayName != null ? displayName : "null");
            sb.append(":");
            sb.append(creditor.getAmount());
            sb.append("}");
            if (i + 1 >= this.creditors.size()) continue;
            sb.append(", ");
        }
        sb.append("], ");
        sb.append(this.description);
        return sb.toString();
    }
}

