/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.PdfBrewer;

public class GeneralJournal {
    private static final int ROWS = 50;
    private static final double ROW_HEIGHT = 5.0;
    private List<JournalEntry> entries;
    int financialYear;
    boolean isFromNewYearsDay;
    private List<String> pageData = new ArrayList<String>();
    private List<String> printData;
    private FontLoader fontLoader;
    private boolean bindingMarginEnabled = true;
    private boolean pageNumberEnabled = true;

    public GeneralJournal(List<JournalEntry> journalEntries, boolean isSoloProprietorship) throws IOException {
        String line;
        this.entries = journalEntries;
        InputStream in = this.getClass().getResourceAsStream("/templates/\u4ed5\u8a33\u5e33.pb");
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = r.readLine()) != null) {
            this.pageData.add(line);
        }
        r.close();
        LocalDate closing = AccountSettlement.getClosingDate(this.entries, isSoloProprietorship);
        if (closing.getMonthValue() == 12 && closing.getDayOfMonth() == 31) {
            this.financialYear = closing.getYear();
            this.isFromNewYearsDay = true;
        } else {
            this.financialYear = closing.getYear() - 1;
            this.isFromNewYearsDay = false;
        }
        this.prepare();
    }

    public List<JournalEntry> getJournalEntries() {
        return this.entries;
    }

    protected void prepare() {
        int pageNumber = 0;
        int restOfRows = 0;
        int currentRow = 0;
        long debtorTotal = 0L;
        long creditorTotal = 0L;
        this.printData = new ArrayList<String>();
        if (this.bindingMarginEnabled) {
            this.printData.add("\\media A4");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 148.5 5 148.5");
        } else {
            this.printData.add("\\media 195 297");
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int j;
            Iterator<Creditor> nextEntry;
            int nextEntryRowsRequired;
            JournalEntry entry = this.entries.get(i);
            int month = entry.getDate().getMonthValue();
            int day = entry.getDate().getDayOfMonth();
            boolean isCarriedForward = false;
            int rowsRequired = this.getRowsRequired(entry);
            if (i == this.entries.size() - 1) {
                ++rowsRequired;
            } else if (currentRow != 0 && rowsRequired <= restOfRows && rowsRequired + (nextEntryRowsRequired = this.getRowsRequired((JournalEntry)((Object)(nextEntry = this.entries.get(i + 1))))) + 1 > restOfRows) {
                isCarriedForward = true;
                ++rowsRequired;
            }
            if (rowsRequired > restOfRows) {
                if (++pageNumber >= 2) {
                    this.printData.add("\\new-page");
                }
                if (!this.bindingMarginEnabled) {
                    this.printData.add("\\box 10 0 -10 -10");
                    this.printData.addAll(this.pageData);
                    if (this.pageNumberEnabled) {
                        if (pageNumber % 2 == 1) {
                            this.printData.add("\t\\box 0 0 -3 22");
                            this.printData.add("\t\\font serif 10.5");
                            this.printData.add("\t\\align bottom right");
                            this.printData.add("\t\\text " + pageNumber);
                        } else {
                            this.printData.add("\t\\box 3 0 10 22");
                            this.printData.add("\t\\font serif 10.5");
                            this.printData.add("\t\\align bottom left");
                            this.printData.add("\t\\text " + pageNumber);
                        }
                    }
                } else if (pageNumber % 2 == 1) {
                    this.printData.add("\\box 15 0 0 0");
                    this.printData.add("\\line-style thin dot");
                    this.printData.add("\\line 0 0 0 -0");
                    this.printData.add("\\box 25 0 -10 -10");
                    this.printData.addAll(this.pageData);
                    if (this.pageNumberEnabled) {
                        this.printData.add("\t\\box 0 0 -3 22");
                        this.printData.add("\t\\font serif 10.5");
                        this.printData.add("\t\\align bottom right");
                        this.printData.add("\t\\text " + pageNumber);
                    }
                } else {
                    this.printData.add("\\box 0 0 -15 0");
                    this.printData.add("\\line-style thin dot");
                    this.printData.add("\\line -0 0 -0 -0");
                    this.printData.add("\\box 10 0 -25 -10");
                    this.printData.addAll(this.pageData);
                    if (this.pageNumberEnabled) {
                        this.printData.add("\t\\box 3 0 10 22");
                        this.printData.add("\t\\font serif 10.5");
                        this.printData.add("\t\\align bottom left");
                        this.printData.add("\t\\text " + pageNumber);
                    }
                }
                if (this.isFromNewYearsDay) {
                    this.printData.add("\t\\box 0 25 14.5 6");
                    this.printData.add("\t\\align center right");
                    this.printData.add("\t\\font serif 8");
                    this.printData.add("\t\\text \u5e74");
                    this.printData.add("\t\\box 0 25 10.5 6");
                    this.printData.add("\t\\font serif 10");
                    this.printData.add("\t\\align center right");
                    this.printData.add("\t\\text " + this.financialYear);
                } else {
                    this.printData.add("\t\\box 0 25 14.7 6");
                    this.printData.add("\t\\align center right");
                    this.printData.add("\t\\font serif 8");
                    this.printData.add("\t\\text \u5e74\u5ea6");
                    this.printData.add("\t\\box 0 25 8.6 6");
                    this.printData.add("\t\\font serif 10");
                    this.printData.add("\t\\align center right");
                    this.printData.add("\t\\text " + this.financialYear);
                }
                this.printData.add("\t\\box 0 37 -0 -0");
                restOfRows = 50;
                currentRow = 0;
                if (pageNumber >= 2) {
                    this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)currentRow * 5.0, 5.0));
                    this.printData.add("\t\t\t\\box " + String.format("16 0 75 %.2f", 5.0));
                    this.printData.add("\t\t\t\\align center right");
                    this.printData.add("\t\t\t\\font serif 10");
                    this.printData.add("\t\t\t\\text \u524d\u9801\u7e70\u8d8a");
                    this.printData.add("\t\t\t\\box " + String.format("101 0 32 %.2f", 5.0));
                    this.printData.add("\t\t\t\\text " + String.format("%,d", debtorTotal));
                    this.printData.add("\t\t\t\\box " + String.format("138 0 32 %.2f", 5.0));
                    this.printData.add("\t\t\t\\text " + String.format("%,d", creditorTotal));
                    ++currentRow;
                    --restOfRows;
                }
            }
            for (Debtor debtor : entry.getDebtors()) {
                debtor.setJournalPageNumber(pageNumber);
            }
            nextEntry = entry.getCreditors().iterator();
            while (nextEntry.hasNext()) {
                Creditor creditor = nextEntry.next();
                creditor.setJournalPageNumber(pageNumber);
            }
            this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)currentRow * 5.0, 5.0));
            this.printData.add("\t\t\\font serif 10");
            this.printData.add("\t\t\t\\box " + String.format("0 0 6 %.2f", 5.0));
            this.printData.add("\t\t\t\\align center right");
            this.printData.add("\t\t\t\\text " + month);
            this.printData.add("\t\t\t\\box " + String.format("8 0 6.2 %.2f", 5.0));
            this.printData.add("\t\t\t\\align center right");
            this.printData.add("\t\t\t\\text " + day);
            double y = 0.0;
            if (entry.getDebtors().size() >= 2) {
                this.printData.add("\t\t\t\\box " + String.format("18 0 34 %.2f", 5.0));
                this.printData.add("\t\t\t\\align center left");
                this.printData.add("\t\t\t\\text \u8af8\u53e3");
                y += 5.0;
            }
            for (j = 0; j < entry.getDebtors().size(); ++j) {
                Debtor debtor = entry.getDebtors().get(j);
                debtorTotal += debtor.getAmount();
                this.printData.add("\t\t\t\\box " + String.format("16 %.2f 77 %.2f", y, 5.0));
                this.printData.add("\t\t\t\\align center left");
                this.printData.add("\t\t\t\\text \uff08" + debtor.getAccountTitle().getDisplayName() + "\uff09");
                this.printData.add("\t\t\t\\box " + String.format("101 %.2f 32 %.2f", y, 5.0));
                this.printData.add("\t\t\t\\align center right");
                this.printData.add("\t\t\t\\text " + String.format("%,d", debtor.getAmount()));
                if (debtor.getLedgerPageNumber() >= 1) {
                    this.printData.add("\t\t\t\\box " + String.format("93 %.2f 8 %.2f", y, 5.0));
                    this.printData.add("\t\t\t\\align center");
                    this.printData.add("\t\t\t\\text " + debtor.getLedgerPageNumber());
                }
                y += 5.0;
            }
            if (entry.getDebtors().size() >= 2 && entry.getCreditors().size() == 1) {
                Creditor creditor = entry.getCreditors().get(0);
                creditorTotal += creditor.getAmount();
                this.printData.add("\t\t\t\\box " + String.format("16 0 77 %.2f", 5.0));
                this.printData.add("\t\t\t\\align center right");
                this.printData.add("\t\t\t\\text \uff08" + creditor.getAccountTitle().getDisplayName() + "\uff09");
                this.printData.add("\t\t\t\\box " + String.format("138 0 32 %.2f", 5.0));
                this.printData.add("\t\t\t\\align center right");
                this.printData.add("\t\t\t\\text " + String.format("%,d", creditor.getAmount()));
                if (creditor.getLedgerPageNumber() >= 1) {
                    this.printData.add("\t\t\t\\box " + String.format("93 0 8 %.2f", 5.0));
                    this.printData.add("\t\t\t\\align center");
                    this.printData.add("\t\t\t\\text " + creditor.getLedgerPageNumber());
                }
            } else {
                if (entry.getCreditors().size() >= 2) {
                    this.printData.add("\t\t\t\\box " + String.format("54.5 0 36.5 %.2f", 5.0));
                    this.printData.add("\t\t\t\\align center right");
                    this.printData.add("\t\t\t\\text \u8af8\u53e3");
                }
                for (j = 0; j < entry.getCreditors().size(); ++j) {
                    Creditor creditor = entry.getCreditors().get(j);
                    creditorTotal += creditor.getAmount();
                    this.printData.add("\t\t\t\\box " + String.format("16 %.2f 77 %.2f", y, 5.0));
                    this.printData.add("\t\t\t\\align center right");
                    this.printData.add("\t\t\t\\text \uff08" + creditor.getAccountTitle().getDisplayName() + "\uff09");
                    this.printData.add("\t\t\t\\box " + String.format("138 %.2f 32 %.2f", y, 5.0));
                    this.printData.add("\t\t\t\\align center right");
                    this.printData.add("\t\t\t\\text " + String.format("%,d", creditor.getAmount()));
                    if (creditor.getLedgerPageNumber() >= 1) {
                        this.printData.add("\t\t\t\\box " + String.format("93 %.2f 8 %.2f", y, 5.0));
                        this.printData.add("\t\t\t\\align center");
                        this.printData.add("\t\t\t\\text " + creditor.getLedgerPageNumber());
                    }
                    y += 5.0;
                }
            }
            this.printData.add("\t\t\t\\box " + String.format("18 %.2f 75 %.2f", y, 5.0));
            this.printData.add("\t\t\t\\font serif 8");
            this.printData.add("\t\t\t\\align center left");
            this.printData.add("\t\t\t\\text " + entry.getDescription());
            if (!isCarriedForward && i + 1 < this.entries.size()) {
                this.printData.add("\t\t\t\\box " + String.format("16 %.2f 77 %.2f", y, 5.0));
                this.printData.add("\t\t\t\\line-style medium solid");
                this.printData.add("\t\t\t\\line 0.325 -0 -0.325 -0");
            }
            if (isCarriedForward) {
                if ((double)(50 - currentRow - rowsRequired) * 5.0 > 0.0) {
                    this.printData.add("\t\t\t\\box " + String.format("16 %.2f 77 %.2f", y + 5.0, (double)(50 - currentRow - rowsRequired) * 5.0));
                    this.printData.add("\t\t\t\\line-style medium solid");
                    this.printData.add("\t\t\t\\line -0.325 0.15 0.325 -0.15");
                }
                this.printData.add("\t\t\\line-style medium solid");
                this.printData.add("\t\t\\box " + String.format("16 %.2f 77 %.2f", 245.0, 5.0));
                this.printData.add("\t\t\\line 0.325 0 -0.325 0");
                this.printData.add("\t\t\\box " + String.format("101 %.2f -0 %.2f", 245.0, 5.0));
                this.printData.add("\t\t\\line 0.325 0 -0.125 0");
                this.printData.add("\t\t\\box " + String.format("16 %.2f 75 %.2f", 245.0, 5.0));
                this.printData.add("\t\t\\align center right");
                this.printData.add("\t\t\\font serif 10");
                this.printData.add("\t\t\\text \u6b21\u9801\u7e70\u8d8a");
                this.printData.add("\t\t\\box " + String.format("101 %.2f 32 %.2f", 245.0, 5.0));
                this.printData.add("\t\t\\text " + String.format("%,d", debtorTotal));
                this.printData.add("\t\t\\box " + String.format("138 %.2f 32 %.2f", 245.0, 5.0));
                this.printData.add("\t\t\\text " + String.format("%,d", creditorTotal));
            }
            currentRow += rowsRequired;
            restOfRows -= rowsRequired;
            if (i != this.entries.size() - 1) continue;
            this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)(currentRow - 1) * 5.0, 5.5));
            this.printData.add("\t\t\\line-style medium solid");
            this.printData.add("\t\t\\line 101.325 0 -0.125 0");
            this.printData.add("\t\t\\line 0.125 -0.5 15.675 -0.5");
            this.printData.add("\t\t\\line 0.125 -0.0 15.675 -0.0");
            this.printData.add("\t\t\\line 101.325 -0.5 -0.125 -0.5");
            this.printData.add("\t\t\\line 101.325 -0.0 -0.125 -0.0");
            this.printData.add("\t\t\t\\align center right");
            this.printData.add("\t\t\t\\font serif 10");
            this.printData.add("\t\t\t\\box " + String.format("101 0 32 %.2f", 5.0));
            this.printData.add("\t\t\t\\text " + String.format("%,d", debtorTotal));
            this.printData.add("\t\t\t\\box " + String.format("138 0 32 %.2f", 5.0));
            this.printData.add("\t\t\t\\text " + String.format("%,d", creditorTotal));
        }
    }

    public int getRowsRequired(JournalEntry entry) {
        int rowsRequired = 0;
        if (entry.getDebtors().size() >= 2) {
            ++rowsRequired;
        }
        rowsRequired += entry.getDebtors().size();
        if (entry.getDebtors().size() < 2 || entry.getCreditors().size() != 1) {
            rowsRequired += entry.getCreditors().size();
        }
        return ++rowsRequired;
    }

    public void setFontLoader(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    public void setBindingMarginEnabled(boolean enabled) {
        this.bindingMarginEnabled = enabled;
    }

    public void setPageNumberEnabled(boolean enabled) {
        this.pageNumberEnabled = enabled;
    }

    public void writeTo(Path path) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u4ed5\u8a33\u5e33");
        brewer.process(pb);
        brewer.save(path);
        brewer.close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u4ed5\u8a33\u5e33");
        brewer.process(pb);
        brewer.save(out);
        brewer.close();
    }
}

