/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.JapaneseChronology;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.Node;
import net.osdn.aoiro.report.layout.ProfitAndLossLayout;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.PdfBrewer;

public class ProfitAndLoss {
    public static String MINUS_SIGN = "\u25b3";
    private static final int ROWS = 40;
    private static final double ROW_HEIGHT = 6.0;
    private ProfitAndLossLayout plLayout;
    private List<JournalEntry> journalEntries;
    private boolean isSoloProprietorship;
    private LocalDate openingDate;
    private LocalDate closingDate;
    private Map<AccountTitle, Amount> incomeSummaries = new HashMap<AccountTitle, Amount>();
    private List<Node<Map.Entry<List<AccountTitle>, Amount>>> list;
    private List<Map.Entry<String, Amount[]>> monthlyTotals;
    private List<String> pageData = new ArrayList<String>();
    private List<String> printData;
    private FontLoader fontLoader;
    private boolean bindingMarginEnabled = true;

    public ProfitAndLoss(ProfitAndLossLayout plLayout, List<JournalEntry> journalEntries, boolean isSoloProprietorship) throws IOException {
        String line;
        this.plLayout = plLayout;
        this.journalEntries = journalEntries;
        this.isSoloProprietorship = isSoloProprietorship;
        this.openingDate = AccountSettlement.getOpeningDate(journalEntries, isSoloProprietorship);
        this.closingDate = AccountSettlement.getClosingDate(journalEntries, isSoloProprietorship);
        for (JournalEntry entry : journalEntries) {
            Amount amount;
            if (!entry.isIncomeSummary()) continue;
            for (Debtor debtor : entry.getDebtors()) {
                if (debtor.getAccountTitle().equals(AccountTitle.INCOME_SUMMARY)) continue;
                amount = this.incomeSummaries.get(debtor.getAccountTitle());
                if (amount == null) {
                    amount = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                    this.incomeSummaries.put(debtor.getAccountTitle(), amount);
                }
                if (debtor.getAccountTitle().getType().getNormalBalance() != Debtor.class) {
                    amount.increase(debtor.getAmount());
                    continue;
                }
                amount.decrease(debtor.getAmount());
            }
            for (Creditor creditor : entry.getCreditors()) {
                if (creditor.getAccountTitle().equals(AccountTitle.INCOME_SUMMARY)) continue;
                amount = this.incomeSummaries.get(creditor.getAccountTitle());
                if (amount == null) {
                    amount = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                    this.incomeSummaries.put(creditor.getAccountTitle(), amount);
                }
                if (creditor.getAccountTitle().getType().getNormalBalance() != Creditor.class) {
                    amount.increase(creditor.getAmount());
                    continue;
                }
                amount.decrease(creditor.getAmount());
            }
        }
        this.retrieve(plLayout.getRoot());
        this.list = this.createList(plLayout.getRoot());
        this.monthlyTotals = this.getMonthlyTotals(journalEntries);
        InputStream in = this.getClass().getResourceAsStream("/templates/\u640d\u76ca\u8a08\u7b97\u66f8.pb");
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = r.readLine()) != null) {
            this.pageData.add(line);
        }
        r.close();
    }

    public List<JournalEntry> getJournalEntries() {
        return this.journalEntries;
    }

    public Map<AccountTitle, Amount> getIncomeSummaries() {
        return this.incomeSummaries;
    }

    public List<Node<Map.Entry<List<AccountTitle>, Amount>>> getList() {
        return this.list;
    }

    public List<Map.Entry<String, Amount[]>> getMonthlyTotals() {
        return this.monthlyTotals;
    }

    private Amount retrieve(Node<Map.Entry<List<AccountTitle>, Amount>> node) {
        Amount a;
        Amount amount = null;
        for (Node<Map.Entry<List<AccountTitle>, Amount>> child : node.getChildren()) {
            a = this.retrieve(child);
            if (a == null) continue;
            if (amount == null) {
                amount = new Amount(a.getNormalBalance(), a.getValue());
                continue;
            }
            amount.increase(a);
        }
        if (node.getValue().getKey() != null) {
            for (AccountTitle accountTitle : node.getValue().getKey()) {
                a = this.incomeSummaries.get(accountTitle);
                if (a == null) continue;
                if (amount == null) {
                    amount = new Amount(a.getNormalBalance(), a.getValue());
                    continue;
                }
                amount.increase(a);
            }
        }
        node.getValue().setValue(amount);
        return amount;
    }

    protected List<Node<Map.Entry<List<AccountTitle>, Amount>>> createList(Node<Map.Entry<List<AccountTitle>, Amount>> plRoot) {
        ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>> list = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>>();
        Amount cumulativeAmount = new Amount(Creditor.class, 0L);
        for (Node<Map.Entry<List<AccountTitle>, Amount>> topLevelNode : plRoot.getChildren()) {
            cumulativeAmount.increase(topLevelNode.getValue().getValue());
            topLevelNode.getValue().setValue(cumulativeAmount.clone());
            topLevelNode.setSubTotal(true);
            for (Node<Map.Entry<List<AccountTitle>, Amount>> childNode : topLevelNode.getChildren()) {
                list.addAll(this.getSubList(childNode));
            }
            list.add(topLevelNode);
        }
        return list;
    }

    protected List<Node<Map.Entry<List<AccountTitle>, Amount>>> getSubList(Node<Map.Entry<List<AccountTitle>, Amount>> node) {
        ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>> list = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>>();
        list.add(node);
        for (Node<Map.Entry<List<AccountTitle>, Amount>> child : node.getChildren()) {
            list.addAll(this.getSubList(child));
        }
        return list;
    }

    protected Set<AccountTitle> getGroupAccounts(Node<Map.Entry<List<AccountTitle>, Amount>> node, String displayName) {
        HashSet<AccountTitle> result = new HashSet<AccountTitle>();
        for (Node<Map.Entry<List<AccountTitle>, Amount>> child : node.getChildren()) {
            Set<AccountTitle> s = this.getGroupAccounts(child, displayName);
            if (s.size() <= 0) continue;
            result.addAll(s);
        }
        if (node.getValue().getKey() != null) {
            boolean containsSales = false;
            for (AccountTitle accountTitle : node.getValue().getKey()) {
                if (!accountTitle.getDisplayName().equals(displayName)) continue;
                containsSales = true;
                break;
            }
            if (containsSales) {
                result.addAll((Collection<AccountTitle>)node.getValue().getKey());
            }
        }
        return result;
    }

    protected List<Map.Entry<String, Amount[]>> getMonthlyTotals(List<JournalEntry> journalEntries) {
        LinkedHashMap<Object, Amount[]> map = new LinkedHashMap<Object, Amount[]>();
        if (this.openingDate != null) {
            YearMonth ym = YearMonth.from(this.openingDate);
            for (int i = 0; i < 12; ++i) {
                String month = ym.plusMonths(i).getMonthValue() + "\u6708";
                map.put(month, new Amount[2]);
            }
        }
        if (this.isSoloProprietorship) {
            map.put("\u5bb6\u4e8b\u6d88\u8cbb\u7b49", new Amount[2]);
        }
        map.put("\u96d1\u53ce\u5165", new Amount[2]);
        Set<AccountTitle> salesAccounts = this.getGroupAccounts(this.plLayout.getRoot(), "\u58f2\u4e0a");
        Set<AccountTitle> purchaseAccounts = this.getGroupAccounts(this.plLayout.getRoot(), "\u4ed5\u5165");
        for (JournalEntry entry : journalEntries) {
            Amount[] amounts;
            Amount[] amounts2;
            String displayName;
            if (entry.isOpening() || entry.isClosing()) continue;
            String month = entry.getDate().getMonthValue() + "\u6708";
            for (Debtor debtor : entry.getDebtors()) {
                if (salesAccounts.contains(debtor.getAccountTitle())) {
                    displayName = debtor.getAccountTitle().getDisplayName();
                    if (displayName.equals("\u5bb6\u4e8b\u6d88\u8cbb\u7b49") || displayName.equals("\u96d1\u53ce\u5165")) {
                        amounts2 = (Amount[])map.get(displayName);
                        if (amounts2 == null) continue;
                        if (amounts2[0] == null) {
                            amounts2[0] = new Amount(Creditor.class, 0L);
                        }
                        amounts2[0].decrease(debtor.getAmount());
                        continue;
                    }
                    amounts2 = (Amount[])map.get(month);
                    if (amounts2[0] == null) {
                        amounts2[0] = new Amount(Creditor.class, 0L);
                    }
                    amounts2[0].decrease(debtor.getAmount());
                    continue;
                }
                if (!purchaseAccounts.contains(debtor.getAccountTitle())) continue;
                amounts = (Amount[])map.get(month);
                if (amounts[1] == null) {
                    amounts[1] = new Amount(Debtor.class, 0L);
                }
                amounts[1].increase(debtor.getAmount());
            }
            for (Creditor creditor : entry.getCreditors()) {
                if (salesAccounts.contains(creditor.getAccountTitle())) {
                    displayName = creditor.getAccountTitle().getDisplayName();
                    if (displayName.equals("\u5bb6\u4e8b\u6d88\u8cbb\u7b49") || displayName.equals("\u96d1\u53ce\u5165")) {
                        amounts2 = (Amount[])map.get(displayName);
                        if (amounts2 == null) continue;
                        if (amounts2[0] == null) {
                            amounts2[0] = new Amount(Creditor.class, 0L);
                        }
                        amounts2[0].increase(creditor.getAmount());
                        continue;
                    }
                    amounts2 = (Amount[])map.get(month);
                    if (amounts2[0] == null) {
                        amounts2[0] = new Amount(Creditor.class, 0L);
                    }
                    amounts2[0].increase(creditor.getAmount());
                    continue;
                }
                if (!purchaseAccounts.contains(creditor.getAccountTitle())) continue;
                amounts = (Amount[])map.get(month);
                if (amounts[1] == null) {
                    amounts[1] = new Amount(Debtor.class, 0L);
                }
                amounts[1].decrease(creditor.getAmount());
            }
        }
        ArrayList<Map.Entry<String, Amount[]>> list = new ArrayList<Map.Entry<String, Amount[]>>();
        for (Map.Entry e : map.entrySet()) {
            list.add(e);
        }
        return list;
    }

    protected void prepare() {
        if (this.list.size() == 0) {
            return;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("GGGG y \u5e74 M \u6708 d \u65e5").withChronology(JapaneseChronology.INSTANCE);
        String openingDate = dtf.format(this.openingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        String closingDate = dtf.format(this.closingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        this.printData = new ArrayList<String>();
        if (this.bindingMarginEnabled) {
            this.printData.add("\\media A4");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 148.5 5 148.5");
            this.printData.add("\\box 15 0 0 0");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 0 0 -0");
            this.printData.add("\\box 25 0 -10 -10");
        } else {
            this.printData.add("\\media 195 297");
            this.printData.add("\\box 10 0 -10 -10");
        }
        this.printData.addAll(this.pageData);
        this.printData.add("\t\\box 0 16 -0 7");
        this.printData.add("\t\\font serif 10");
        this.printData.add("\t\\align center");
        this.printData.add("\t\\text " + openingDate + " \uff5e " + closingDate);
        this.printData.add("\t\\box 0 37 -0 -0");
        this.printData.add("\t\\font serif 10");
        this.printData.add("\t\\line-style thin dot");
        double y = 0.0;
        for (int i = 0; i < this.list.size(); ++i) {
            Node<Map.Entry<List<AccountTitle>, Amount>> node = this.list.get(i);
            Amount amount = node.getValue().getValue();
            if (amount == null && !this.plLayout.isAlwaysShown(node.getName()) || (amount == null || amount.getValue() == 0L) && this.plLayout.isHidden(node.getName())) continue;
            if (i >= 1) {
                if (node.isSubTotal()) {
                    this.printData.add("\t\\line-style thin solid");
                } else {
                    this.printData.add("\t\\line-style thin dot");
                }
                this.printData.add("\t\\line " + String.format("0 %.2f 95 %.2f", y, y));
            }
            if (node.getLevel() == 0 || this.plLayout.getRoot().getChildren().size() == 1 && node.getLevel() == 1) {
                this.printData.add("\t\t\\font serif 10 bold");
            } else {
                this.printData.add("\t\t\\font serif 10");
            }
            StringBuilder displayName = new StringBuilder();
            for (int j = 1; j < node.getLevel(); ++j) {
                displayName.append("\u3000 ");
            }
            displayName.append(node.getName());
            this.printData.add("\t\t\\box " + String.format("2 %.2f 63 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName);
            if (amount != null) {
                this.printData.add("\t\t\\box " + String.format("63 %.2f 27 %.2f", y, 6.0));
                this.printData.add("\t\t\\align center right");
                int sign = this.plLayout.isSignReversed(node.getName()) ? -1 : 1;
                this.printData.add("\t\t\\text " + ProfitAndLoss.formatMoney((long)sign * amount.getValue()));
            }
            y += 6.0;
        }
        this.printData.add("\t\\line-style thin solid");
        if (y > 0.0) {
            this.printData.add("\t\\line " + String.format("0 %.2f 95 %.2f", y - 6.0, y - 6.0));
            this.printData.add("\t\\line " + String.format("0 %.2f 95 %.2f", y, y));
            this.printData.add("\t\\line " + String.format("0 %.2f 95 %.2f", y + 0.4, y + 0.4));
        }
        this.printData.add("\t\\box 0 0 -0 -0");
        this.printData.add("\t\\line " + String.format("63 31.2 63 %.2f", 37.0 + y));
        this.printData.add("\t\\line-style thin dot");
        this.printData.add("\t\\line " + String.format(" 0 31.2  0 %.2f", 37.0 + y));
        this.printData.add("\t\\line " + String.format("95 31.2 95 %.2f", 37.0 + y));
        this.printData.add("\t\\box 0 37 -0 -0");
        Amount salesTotal = null;
        Amount purchaseTotal = null;
        long maxAmount = 0L;
        long cTotal = 0L;
        long dTotal = 0L;
        for (Map.Entry<String, Amount[]> e : this.monthlyTotals) {
            long v;
            Amount[] amounts = e.getValue();
            if (amounts[0] != null) {
                cTotal += amounts[0].getValue();
                v = Math.abs(amounts[0].getValue());
                if (v > maxAmount) {
                    maxAmount = v;
                }
            }
            if (amounts[1] == null) continue;
            dTotal += amounts[1].getValue();
            v = Math.abs(amounts[1].getValue());
            if (v <= maxAmount) continue;
            maxAmount = v;
        }
        if (cTotal > maxAmount) {
            maxAmount = cTotal;
        }
        if (dTotal > maxAmount) {
            maxAmount = dTotal;
        }
        double amountPrintWidth = 21.0;
        if (maxAmount > 99999999999L) {
            amountPrintWidth = 26.0;
        } else if (maxAmount > 9999999999L) {
            amountPrintWidth = 25.0;
        } else if (maxAmount > 999999999L) {
            amountPrintWidth = 24.0;
        } else if (maxAmount > 99999999L) {
            amountPrintWidth = 22.0;
        }
        y = 0.0;
        this.printData.add("\t\\box 0 37 -0 -0");
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\line-style thin dot");
        for (Map.Entry<String, Amount[]> e : this.monthlyTotals) {
            String displayName = e.getKey();
            Amount[] amounts = e.getValue();
            if (y > 0.0) {
                this.printData.add("\t\t\\line " + String.format("105 %.2f -0 %.2f", y, y));
            }
            if (displayName.endsWith("\u6708")) {
                this.printData.add("\t\t\t\\box " + String.format("105 %.2f 13.5 %.2f", y, 6.0));
                this.printData.add("\t\t\t\\align center right");
            } else {
                this.printData.add("\t\t\\line " + String.format("-0 %.2f 150 %.2f", y + 0.15, y + 6.0 - 0.15));
                this.printData.add("\t\t\t\\box " + String.format("105 %.2f 20 %.2f", y, 6.0));
                this.printData.add("\t\t\t\\align center");
            }
            this.printData.add("\t\t\t\\text " + displayName);
            if (amounts[0] != null) {
                this.printData.add("\t\t\t\\box " + String.format("125 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\t\\align center right");
                this.printData.add("\t\t\t\\text " + ProfitAndLoss.formatMoney(amounts[0].getValue()));
                if (salesTotal == null) {
                    salesTotal = new Amount(Creditor.class, 0L);
                }
                salesTotal.increase(amounts[0].getValue());
            }
            if (amounts[1] != null) {
                this.printData.add("\t\t\t\\box " + String.format("150 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\t\\align center right");
                this.printData.add("\t\t\t\\text " + ProfitAndLoss.formatMoney(amounts[1].getValue()));
                if (purchaseTotal == null) {
                    purchaseTotal = new Amount(Debtor.class, 0L);
                }
                purchaseTotal.increase(amounts[1].getValue());
            }
            y += 6.0;
        }
        this.printData.add("\t\t\\line-style thin solid");
        this.printData.add("\t\t\\line " + String.format("105 %.2f -0 %.2f", y, y));
        this.printData.add("\t\t\\line " + String.format("105 %.2f -0 %.2f", y + 6.0, y + 6.0));
        this.printData.add("\t\t\\line " + String.format("105 %.2f -0 %.2f", y + 6.0 + 0.4, y + 6.0 + 0.4));
        this.printData.add("\t\t\\font serif 10 bold");
        this.printData.add("\t\t\t\\box " + String.format("105 %.2f 20 %.2f", y, 6.0));
        this.printData.add("\t\t\t\\align center");
        this.printData.add("\t\t\t\\text \u8a08");
        if (salesTotal != null) {
            this.printData.add("\t\t\t\\box " + String.format("125 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\t\\align center right");
            this.printData.add("\t\t\t\\text " + ProfitAndLoss.formatMoney(salesTotal.getValue()));
        }
        if (purchaseTotal != null) {
            this.printData.add("\t\t\t\\box " + String.format("150 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\t\\align center right");
            this.printData.add("\t\t\t\\text " + ProfitAndLoss.formatMoney(purchaseTotal.getValue()));
        }
        this.printData.add("\t\\box 0 31 -0 -0");
        this.printData.add("\t\t\\line-style thin dot");
        this.printData.add("\t\t\\line " + String.format("105 0.2 105 %.2f", y + 6.0 + 6.0));
        this.printData.add("\t\t\\line " + String.format(" -0 0.2  -0 %.2f", y + 6.0 + 6.0));
        this.printData.add("\t\t\\line-style thin solid");
        this.printData.add("\t\t\\line " + String.format("126 0.2 126 %.2f", y + 6.0 + 6.0));
        this.printData.add("\t\t\\line " + String.format("150 0.2 150 %.2f", y + 6.0 + 6.0));
    }

    public void setFontLoader(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    public void setBindingMarginEnabled(boolean enabled) {
        this.bindingMarginEnabled = enabled;
    }

    public void writeTo(Path path) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u640d\u76ca\u8a08\u7b97\u66f8");
        brewer.process(pb);
        brewer.save(path);
        brewer.close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u640d\u76ca\u8a08\u7b97\u66f8");
        brewer.process(pb);
        brewer.save(out);
        brewer.close();
    }

    private static String formatMoney(long amount) {
        if (MINUS_SIGN != null && amount < 0L) {
            return MINUS_SIGN + String.format("%,d", -amount);
        }
        return String.format("%,d", amount);
    }
}

