/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report.layout;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Node;

public class BalanceSheetLayout {
    private Node<Map.Entry<List<AccountTitle>, Amount[]>> root = new Node(0, "\u8cb8\u501f\u5bfe\u7167\u8868");
    private Set<String> signReversedNames = new LinkedHashSet<String>();
    private Set<String> alwaysShownNames = new LinkedHashSet<String>();
    private Set<String> hiddenNamesIfZero = new LinkedHashSet<String>();

    public Node<Map.Entry<List<AccountTitle>, Amount[]>> getRoot() {
        return this.root;
    }

    public Set<String> getSignReversedNames() {
        return this.signReversedNames;
    }

    public Set<String> getAlwaysShownNames() {
        return this.alwaysShownNames;
    }

    public Set<String> getHiddenNamesIfZero() {
        return this.hiddenNamesIfZero;
    }

    public boolean isSignReversed(String name) {
        return this.signReversedNames.contains(name);
    }

    public boolean isAlwaysShown(String name) {
        return this.alwaysShownNames.contains(name);
    }

    public boolean isHidden(String name) {
        return this.hiddenNamesIfZero.contains(name);
    }

    public String getYaml() {
        StringBuilder out = new StringBuilder();
        this.retrieve(out, this.getRoot());
        out.append("\r\n");
        out.append("\"\u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1\" :\r\n");
        out.append("  \"\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\" : [");
        Iterator<String> it1 = this.getSignReversedNames().iterator();
        while (it1.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it1.next()));
            out.append("\"");
            if (!it1.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("  \"\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\" : [");
        Iterator<String> it2 = this.getAlwaysShownNames().iterator();
        while (it2.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it2.next()));
            out.append("\"");
            if (!it2.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("  \"\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\" : [");
        Iterator<String> it3 = this.getHiddenNamesIfZero().iterator();
        while (it3.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it3.next()));
            out.append("\"");
            if (!it3.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("\r\n\r\n");
        return out.toString();
    }

    private void retrieve(StringBuilder out, Node<Map.Entry<List<AccountTitle>, Amount[]>> node) {
        List<AccountTitle> accountTitles = node.getValue().getKey();
        String indent = "  ".repeat(node.getLevel() + 0);
        out.append(indent);
        out.append("\"");
        out.append(YamlBeansUtil.escape(node.getName()));
        out.append("\" :");
        if (accountTitles.size() > 0) {
            out.append(" [");
            for (int i = 0; i < accountTitles.size(); ++i) {
                out.append("\"");
                out.append(accountTitles.get(i).getDisplayName());
                out.append("\"");
                if (i + 1 >= accountTitles.size()) continue;
                out.append(", ");
            }
            out.append("]");
        }
        out.append("\r\n");
        for (Node<Map.Entry<List<AccountTitle>, Amount[]>> child : node.getChildren()) {
            this.retrieve(out, child);
        }
    }
}

