/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.universalchardet.UniversalDetector;

public class AutoDetectReader
extends BufferedReader {
    private Impl reader;

    private AutoDetectReader(Impl reader) {
        super(reader);
        this.reader = reader;
    }

    private AutoDetectReader(Impl reader, int bufferSize) {
        super(reader, bufferSize);
        this.reader = reader;
    }

    public AutoDetectReader(InputStream in) {
        this(new Impl(in));
    }

    public AutoDetectReader(InputStream in, int bufferSize) {
        this(new Impl(in), bufferSize);
    }

    public AutoDetectReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public AutoDetectReader(File file, int bufferSize) throws FileNotFoundException {
        this(new FileInputStream(file), bufferSize);
    }

    public AutoDetectReader(String filename) throws FileNotFoundException {
        this(new FileInputStream(filename));
    }

    public AutoDetectReader(String filename, int bufferSize) throws FileNotFoundException {
        this(new FileInputStream(filename), bufferSize);
    }

    public AutoDetectReader(Path path) throws IOException {
        this(Files.newInputStream(path, new OpenOption[0]));
    }

    public AutoDetectReader(Path path, int bufferSize) throws IOException {
        this(Files.newInputStream(path, new OpenOption[0]), bufferSize);
    }

    public Charset getCharset() throws IOException {
        return this.reader.getCharset();
    }

    public boolean isDetected() throws IOException {
        return this.reader.isDetected();
    }

    public static List<String> readAllLines(Path path) throws IOException {
        try (AutoDetectReader reader = new AutoDetectReader(path);){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static List<String> readAllLines(Path path, long timeout) throws IOException, InterruptedException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            long s = System.currentTimeMillis();
            while (timeout == 0L || System.currentTimeMillis() - s < timeout) {
                try (FileLock lock = fc.tryLock(0L, Long.MAX_VALUE, true);){
                    if (lock != null) {
                        FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                        List<String> lines = AutoDetectReader.readAllLines(path);
                        if (lastModifiedTime.equals(Files.getLastModifiedTime(path, new LinkOption[0]))) {
                            List<String> list = lines;
                            return list;
                        }
                    }
                }
                Thread.sleep(16L);
            }
        }
        return null;
    }

    public static String readAll(Path path) throws IOException {
        try (AutoDetectReader reader = new AutoDetectReader(path);){
            int len;
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[8192];
            while ((len = reader.read(cbuf)) >= 0) {
                if (len <= 0) continue;
                sb.append(cbuf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String readAll(Path path, long timeout) throws IOException, InterruptedException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            long s = System.currentTimeMillis();
            while (timeout == 0L || System.currentTimeMillis() - s < timeout) {
                try (FileLock lock = fc.tryLock(0L, Long.MAX_VALUE, true);){
                    if (lock != null) {
                        FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                        String lines = AutoDetectReader.readAll(path);
                        if (lastModifiedTime.equals(Files.getLastModifiedTime(path, new LinkOption[0]))) {
                            String string = lines;
                            return string;
                        }
                    }
                }
                Thread.sleep(16L);
            }
        }
        return null;
    }

    private static class Impl
    extends Reader {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private static final Charset UTF_16BE = Charset.forName("UTF-16BE");
        private static final Charset UTF_16LE = Charset.forName("UTF-16LE");
        private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
        private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
        private static final int BUFSIZ = 65536;
        private PushbackInputStream in;
        private boolean isDetected;
        private Charset charset;
        private Reader reader;

        public Impl(InputStream in) {
            this.in = new PushbackInputStream(in, 65536);
        }

        public boolean isDetected() throws IOException {
            if (this.reader == null) {
                this.detect();
            }
            return this.isDetected;
        }

        public Charset getCharset() throws IOException {
            if (this.reader == null) {
                this.detect();
            }
            return this.charset;
        }

        private void detect() throws IOException {
            byte[] bom;
            int n;
            int size;
            if (this.reader != null) {
                return;
            }
            UniversalDetector detector = new UniversalDetector(null);
            byte[] buf = new byte[65536];
            int offset = 0;
            int length = 65536;
            while ((size = this.in.read(buf, offset, length)) > 0) {
                detector.handleData(buf, offset, size);
                offset += size;
                if (!detector.isDone() && (length -= size) > 0) continue;
            }
            this.in.unread(buf, 0, offset);
            detector.dataEnd();
            if (detector.getDetectedCharset() != null) {
                this.charset = Charset.forName(detector.getDetectedCharset());
                this.isDetected = true;
            }
            if (this.charset == null) {
                this.charset = Charset.defaultCharset();
            }
            if (this.charset.equals(UTF_8) && offset >= 3) {
                byte[] bom2 = new byte[3];
                int n2 = this.in.read(bom2);
                if (n2 != 3 || bom2[0] != -17 || bom2[1] != -69 || bom2[2] != -65) {
                    this.in.unread(bom2, 0, n2);
                }
            } else if (this.charset.equals(UTF_16BE) && offset >= 2) {
                byte[] bom3 = new byte[2];
                int n3 = this.in.read(bom3);
                if (n3 != 2 || bom3[0] != -2 || bom3[1] != -1) {
                    this.in.unread(bom3, 0, n3);
                }
            } else if (this.charset.equals(UTF_16LE) && offset >= 2) {
                byte[] bom4 = new byte[2];
                int n4 = this.in.read(bom4);
                if (n4 != 2 || bom4[0] != -1 || bom4[1] != -2) {
                    this.in.unread(bom4, 0, n4);
                }
            } else if (this.charset.equals(UTF_32BE) && offset >= 4) {
                byte[] bom5 = new byte[4];
                int n5 = this.in.read(bom5);
                if (n5 != 4 || bom5[0] != 0 || bom5[1] != 0 || bom5[2] != -2 || bom5[3] != -1) {
                    this.in.unread(bom5, 0, n5);
                }
            } else if (this.charset.equals(UTF_32LE) && offset >= 4 && ((n = this.in.read(bom = new byte[4])) != 4 || bom[0] != -1 || bom[1] != -2 || bom[2] != 0 || bom[3] != 0)) {
                this.in.unread(bom, 0, n);
            }
            this.reader = new InputStreamReader((InputStream)this.in, this.charset);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.charset == null) {
                this.getCharset();
            }
            return this.reader.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
                this.in = null;
            } else if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }
}

