/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro;

import java.io.PrintStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.ProportionalDivision;

public class AccountSettlement {
    private boolean isSoloProprietorship;
    private LocalDate date;
    private Set<AccountTitle> accountTitles;
    private PrintStream out;

    public AccountSettlement(Set<AccountTitle> accountTitles, boolean isSoloproprietorship) {
        this.accountTitles = accountTitles;
        this.isSoloProprietorship = isSoloproprietorship;
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public void addClosingEntries(List<JournalEntry> journalEntries, List<ProportionalDivision> proportionalDivisions) {
        String description;
        Debtor debtor;
        Iterator debtor2;
        JournalEntry entry;
        Object creditor;
        Object creditor2;
        Object debtor3;
        List<JournalEntry> entries;
        long total;
        AccountTitle ownersDrawing;
        if (this.date == null) {
            this.date = AccountSettlement.getClosingDate(journalEntries, this.isSoloProprietorship);
        }
        if (this.date == null) {
            throw new IllegalStateException("\u6c7a\u7b97\u65e5\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        ArrayList<AccountTitle> order = new ArrayList<AccountTitle>(this.accountTitles);
        if (proportionalDivisions != null && (ownersDrawing = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u8cb8")) != null) {
            JournalEntry entry2;
            ArrayList<Debtor> debtors = new ArrayList<Debtor>();
            ArrayList<Creditor> creditors = new ArrayList<Creditor>();
            for (ProportionalDivision proportionalDivision : proportionalDivisions) {
                double total2;
                long longTotal;
                long debtorTotal = 0L;
                long creditorTotal = 0L;
                for (int i = 0; i < journalEntries.size(); ++i) {
                    JournalEntry entry3 = journalEntries.get(i);
                    for (Debtor debtor4 : entry3.getDebtors()) {
                        if (!debtor4.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                        debtorTotal += debtor4.getAmount();
                    }
                    for (Creditor creditor3 : entry3.getCreditors()) {
                        if (!creditor3.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                        creditorTotal += creditor3.getAmount();
                    }
                }
                if (debtorTotal > creditorTotal) {
                    double total3 = (double)(debtorTotal - creditorTotal) * (1.0 - proportionalDivision.getBusinessRatio());
                    long longTotal2 = Math.round(total3);
                    if (longTotal2 == 0L) continue;
                    creditors.add(new Creditor(proportionalDivision.getAccountTitle(), longTotal2));
                    continue;
                }
                if (creditorTotal <= debtorTotal || (longTotal = Math.round(total2 = (double)(creditorTotal - debtorTotal) * (1.0 - proportionalDivision.getBusinessRatio()))) == 0L) continue;
                debtors.add(new Debtor(proportionalDivision.getAccountTitle(), longTotal));
            }
            if (debtors.size() > 0) {
                Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
                long creditorTotal = 0L;
                for (Debtor debtor5 : debtors) {
                    creditorTotal += debtor5.getAmount();
                }
                Creditor creditor4 = new Creditor(ownersDrawing, creditorTotal);
                entry2 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", debtors, Arrays.asList(creditor4));
                journalEntries.add(entry2);
            }
            if (creditors.size() > 0) {
                Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
                long debtorTotal = 0L;
                for (Creditor creditor5 : creditors) {
                    debtorTotal += creditor5.getAmount();
                }
                Debtor debtor6 = new Debtor(ownersDrawing, debtorTotal);
                entry2 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", Arrays.asList(debtor6), creditors);
                journalEntries.add(entry2);
            }
            if (this.out != null && (debtors.size() > 0 || creditors.size() > 0)) {
                this.out.println("  \u5bb6\u4e8b\u6309\u5206\u306e\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
        }
        LinkedHashSet<AccountTitle> revenueAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> expenseAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> assetsAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> liabilitiesAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> equityAccountTitles = new LinkedHashSet<AccountTitle>();
        for (JournalEntry entry2 : journalEntries) {
            for (Creditor creditor6 : entry2.getCreditors()) {
                if (creditor6.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(creditor6.getAccountTitle());
                }
                if (creditor6.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(creditor6.getAccountTitle());
                }
                if (creditor6.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor6.getAccountTitle());
                }
                if (creditor6.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor6.getAccountTitle());
            }
            for (Debtor debtor7 : entry2.getDebtors()) {
                if (debtor7.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(debtor7.getAccountTitle());
                }
                if (debtor7.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(debtor7.getAccountTitle());
                }
                if (debtor7.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor7.getAccountTitle());
                }
                if (debtor7.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor7.getAccountTitle());
            }
        }
        long incomeSummary = 0L;
        ArrayList<Debtor> debtors = new ArrayList<Debtor>();
        long debtorsTotal = 0L;
        ArrayList<Creditor> creditors = new ArrayList<Creditor>();
        long creditorsTotal = 0L;
        for (AccountTitle accountTitle : revenueAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry4 : entries) {
                for (Creditor creditor7 : entry4.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor7.getAmount();
                }
                for (Debtor debtor8 : entry4.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor8.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
            } else {
                creditor2 = new Creditor(accountTitle, -total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += -total;
            }
            incomeSummary += total;
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor2 = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : expenseAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry4 : entries) {
                for (Debtor debtor8 : entry4.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor8.getAmount();
                }
                for (Creditor creditor7 : entry4.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor7.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
            } else {
                debtor3 = new Debtor(accountTitle, -total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += -total;
            }
            incomeSummary -= total;
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor2 = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry);
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry5 : journalEntries) {
            for (Creditor creditor8 : entry5.getCreditors()) {
                if (creditor8.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor8.getAccountTitle());
                }
                if (creditor8.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor8.getAccountTitle());
            }
            for (Debtor debtor9 : entry5.getDebtors()) {
                if (debtor9.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor9.getAccountTitle());
                }
                if (debtor9.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor9.getAccountTitle());
            }
        }
        if (incomeSummary >= 0L) {
            debtor = new Debtor(AccountTitle.INCOME_SUMMARY, incomeSummary);
            Creditor creditor9 = this.isSoloProprietorship ? new Creditor(AccountTitle.PRETAX_INCOME, incomeSummary) : new Creditor(AccountTitle.RETAINED_EARNINGS, incomeSummary);
            JournalEntry entry6 = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor), Arrays.asList(creditor9));
            journalEntries.add(entry6);
        } else if (incomeSummary < 0L) {
            debtor = this.isSoloProprietorship ? new Debtor(AccountTitle.PRETAX_INCOME, -incomeSummary) : new Debtor(AccountTitle.RETAINED_EARNINGS, -incomeSummary);
            Creditor creditor10 = new Creditor(AccountTitle.INCOME_SUMMARY, -incomeSummary);
            JournalEntry entry7 = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor), Arrays.asList(creditor10));
            journalEntries.add(entry7);
        }
        if (this.out != null) {
            this.out.println("  \u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : assetsAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry4 : entries) {
                for (Debtor debtor8 : entry4.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor8.getAmount();
                }
                for (Creditor creditor7 : entry4.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor7.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            debtor3 = new Debtor(accountTitle, -total);
            debtors.add((Debtor)debtor3);
            debtorsTotal += -total;
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor2 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry);
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : liabilitiesAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry4 : entries) {
                for (Creditor creditor7 : entry4.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor7.getAmount();
                }
                for (Debtor debtor8 : entry4.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor8.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor2 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor2), creditors);
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry8 : journalEntries) {
            for (Creditor creditor8 : entry8.getCreditors()) {
                if (creditor8.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(creditor8.getAccountTitle());
            }
            for (Debtor debtor9 : entry8.getDebtors()) {
                if (debtor9.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(debtor9.getAccountTitle());
            }
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : equityAccountTitles) {
            total = 0L;
            entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry4 : entries) {
                for (Creditor creditor7 : entry4.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor7.getAmount();
                }
                for (Debtor debtor8 : entry4.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor8.getAmount();
                }
            }
            if (total >= 0L) {
                debtor3 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor3);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        String string = description = this.isSoloProprietorship ? "\u8cc7\u672c\u306e\u6b8b\u9ad8\u632f\u66ff" : "\u7d14\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff";
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            Creditor creditor11 = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, debtors, Arrays.asList(creditor11));
            journalEntries.add(incomeSummaryEntry);
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            Debtor debtor10 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, Arrays.asList(debtor10), creditors);
            journalEntries.add(incomeSummaryEntry);
        }
        if (this.out != null) {
            this.out.println("  " + description + "\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static LocalDate getOpeningDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        for (JournalEntry entry : journalEntries) {
            if (date == null) {
                date = entry.getDate();
                continue;
            }
            LocalDate date2 = entry.getDate();
            if (date2 == null || !date2.isBefore(date)) continue;
            date = date2;
        }
        return date;
    }

    public static LocalDate getClosingDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        if (isSoloProprietorship) {
            if (journalEntries.size() > 0) {
                for (JournalEntry entry : journalEntries) {
                    if (entry.getDate() == null) continue;
                    date = LocalDate.of(entry.getDate().getYear(), 12, 31);
                    break;
                }
            }
        } else {
            LocalDate opening = null;
            for (JournalEntry entry : journalEntries) {
                if (opening == null) {
                    opening = entry.getDate();
                    continue;
                }
                LocalDate opening2 = entry.getDate();
                if (opening2 == null || !opening2.isBefore(opening2)) continue;
                opening = opening2;
            }
            if (opening != null) {
                date = opening.plusYears(1L).minusMonths(1L);
                date = date.withDayOfMonth(date.lengthOfMonth());
            }
        }
        return date;
    }

    public static List<JournalEntry> getJournalEntriesByAccount(List<JournalEntry> journalEntries, AccountTitle accountTitle) {
        ArrayList<JournalEntry> entriesByAccount = new ArrayList<JournalEntry>();
        if (accountTitle != null) {
            block0: for (JournalEntry entry : journalEntries) {
                for (Debtor debtor : entry.getDebtors()) {
                    if (!accountTitle.equals(debtor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
                for (Creditor creditor : entry.getCreditors()) {
                    if (!accountTitle.equals(creditor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
            }
        }
        return entriesByAccount;
    }
}

