/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.loader.yaml;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.parser.Parser;
import com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.ErrorMessage;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;

public class JournalEntriesLoader {
    private static DateTimeFormatter dateParser = DateTimeFormatter.ofPattern("y-M-d");
    private Path path;
    private Map<String, AccountTitle> accountTitleByDisplayName;

    public JournalEntriesLoader(Path path, Set<AccountTitle> accountTitles) {
        this.path = path;
        this.accountTitleByDisplayName = new HashMap<String, AccountTitle>();
        for (AccountTitle accountTitle : accountTitles) {
            this.accountTitleByDisplayName.put(accountTitle.getDisplayName(), accountTitle);
        }
    }

    public List<JournalEntry> getJournalEntries() throws IOException {
        return this.getJournalEntries(false, false);
    }

    public List<JournalEntry> getJournalEntries(boolean ignoreWarnings, boolean skipErrors) throws IOException {
        try {
            ItemReader reader = new ItemReader(this.path, ignoreWarnings, skipErrors);
            reader.read();
            return reader.journalEntries;
        }
        catch (YamlException e) {
            YamlBeansUtil.Message m = YamlBeansUtil.getMessage(e);
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + m.getLine() + "\u884c\u76ee, " + m.getColumn() + "\u6841\u76ee)\r\n " + m.getMessage());
        }
    }

    private static LocalDate parseDate(String s) {
        s = s.replace('/', '-').replace('.', '-').replace('\u5e74', '-').replace('\u6708', '-').replace('\u65e5', ' ').trim();
        try {
            return LocalDate.from(dateParser.parse(s));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Long parseAmount(String s) {
        s = s.replace(",", "").trim();
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void write(Path file, List<JournalEntry> journalEntries) throws IOException {
        String yaml = JournalEntriesLoader.getYaml(journalEntries);
        Path tmpFile = null;
        try {
            Path dir = file.getParent();
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            tmpFile = dir.resolve("\u4ed5\u8a33\u30c7\u30fc\u30bf.tmp");
            Files.writeString(tmpFile, (CharSequence)yaml, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            try {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING);
            }
            if (tmpFile == null) return;
        }
        catch (Throwable throwable) {
            if (tmpFile == null) throw throwable;
            try {
                Files.deleteIfExists(tmpFile);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            Files.deleteIfExists(tmpFile);
            return;
        }
        catch (Exception exception) {}
    }

    public static String getYaml(List<JournalEntry> journalEntries) {
        StringBuilder sb = new StringBuilder();
        if (journalEntries != null) {
            for (JournalEntry journalEntry : journalEntries) {
                sb.append(journalEntry.getYaml());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    private static class ChildItem {
        public String \u52d8\u5b9a\u79d1\u76ee;
        public String \u91d1\u984d;

        private ChildItem() {
        }
    }

    private static class Item {
        public String \u65e5\u4ed8;
        public String \u6458\u8981;
        public ChildItem[] \u501f\u65b9;
        public ChildItem[] \u8cb8\u65b9;

        private Item() {
        }
    }

    private class ItemReader
    extends YamlReader {
        private Path path;
        private boolean ignoreWarnings;
        private boolean skipErrors;
        private List<JournalEntry> journalEntries;

        public ItemReader(Path path, boolean ignoreWarnings, boolean skipErrors) throws IOException {
            super(Files.readString(path, StandardCharsets.UTF_8));
            this.journalEntries = new ArrayList<JournalEntry>();
            this.path = path;
            this.ignoreWarnings = ignoreWarnings;
            this.skipErrors = skipErrors;
        }

        public List<Item> read() throws YamlException {
            return (List)super.read(List.class, Item.class);
        }

        protected Object readValue(Class type, Class elementType, Class defaultType) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
            if (type != Item.class) {
                return super.readValue(type, elementType, defaultType);
            }
            YamlBeansUtil.Position pos = YamlBeansUtil.getPosition(this);
            int line = pos.line + 1;
            Object obj = super.readValue(type, elementType, defaultType);
            if (obj instanceof Item) {
                Item item = (Item)obj;
                if (item.\u65e5\u4ed8 == null && !this.ignoreWarnings && !this.skipErrors) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u65e5\u4ed8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                LocalDate date = JournalEntriesLoader.parseDate(item.\u65e5\u4ed8);
                if (date == null && !this.ignoreWarnings && !this.skipErrors) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u65e5\u4ed8\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059: " + item.\u65e5\u4ed8);
                }
                if (item.\u6458\u8981 == null) {
                    if (!this.skipErrors) {
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u6458\u8981\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    item.\u6458\u8981 = "";
                }
                String description = item.\u6458\u8981.trim();
                if (item.\u501f\u65b9 == null) {
                    if (!this.skipErrors) {
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    item.\u501f\u65b9 = new ChildItem[0];
                }
                ArrayList<Debtor> debtors = new ArrayList<Debtor>();
                long debtorsAmount = 0L;
                for (ChildItem childItem : item.\u501f\u65b9) {
                    Long amount;
                    if (childItem == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    if (childItem.\u52d8\u5b9a\u79d1\u76ee == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    AccountTitle accountTitle = JournalEntriesLoader.this.accountTitleByDisplayName.get(childItem.\u52d8\u5b9a\u79d1\u76ee.trim());
                    if (accountTitle == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u306b\u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + childItem.\u52d8\u5b9a\u79d1\u76ee);
                    }
                    if (childItem.\u91d1\u984d == null) {
                        if (!this.skipErrors) {
                            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee\r\n \u501f\u65b9\u306e\u91d1\u984d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        }
                        childItem.\u91d1\u984d = "-1";
                    }
                    if ((amount = JournalEntriesLoader.parseAmount(childItem.\u91d1\u984d)) == null) {
                        if (!this.skipErrors) {
                            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u306e\u91d1\u984d\u306f\u6570\u5024\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044: " + childItem.\u91d1\u984d);
                        }
                        amount = -1L;
                    }
                    if (amount < 0L && !this.ignoreWarnings && !this.skipErrors) {
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u306e\u91d1\u984d\u306b\u30de\u30a4\u30ca\u30b9\u306e\u6570\u5024\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + childItem.\u91d1\u984d);
                    }
                    if (amount > 0L) {
                        debtorsAmount += amount.longValue();
                    }
                    debtors.add(new Debtor(accountTitle, amount));
                }
                if (item.\u8cb8\u65b9 == null) {
                    if (!this.skipErrors) {
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    item.\u8cb8\u65b9 = new ChildItem[0];
                }
                ArrayList<Creditor> creditors = new ArrayList<Creditor>();
                long creditorsAmount = 0L;
                for (ChildItem c : item.\u8cb8\u65b9) {
                    Long amount;
                    if (c == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    if (c.\u52d8\u5b9a\u79d1\u76ee == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    }
                    AccountTitle accountTitle = JournalEntriesLoader.this.accountTitleByDisplayName.get(c.\u52d8\u5b9a\u79d1\u76ee.trim());
                    if (accountTitle == null) {
                        if (this.skipErrors) continue;
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u306b\u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + c.\u52d8\u5b9a\u79d1\u76ee);
                    }
                    if (c.\u91d1\u984d == null) {
                        if (!this.skipErrors) {
                            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u306e\u91d1\u984d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        }
                        c.\u91d1\u984d = "-1";
                    }
                    if ((amount = JournalEntriesLoader.parseAmount(c.\u91d1\u984d)) == null) {
                        if (!this.skipErrors) {
                            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u306e\u91d1\u984d\u306f\u6570\u5024\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044: " + c.\u91d1\u984d);
                        }
                        amount = -1L;
                    }
                    if (amount < 0L && !this.ignoreWarnings && !this.skipErrors) {
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u8cb8\u65b9\u306e\u91d1\u984d\u306b\u30de\u30a4\u30ca\u30b9\u306e\u6570\u5024\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + c.\u91d1\u984d);
                    }
                    if (amount > 0L) {
                        creditorsAmount += amount.longValue();
                    }
                    creditors.add(new Creditor(accountTitle, amount));
                }
                if (debtorsAmount != creditorsAmount && !this.ignoreWarnings && !this.skipErrors) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u501f\u65b9\u3068\u8cb8\u65b9\u306e\u91d1\u984d\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093: \u501f\u65b9\u91d1\u984d " + debtorsAmount + ", \u8cb8\u65b9\u91d1\u984d " + creditorsAmount);
                }
                JournalEntry journalEntry = new JournalEntry(date, description, debtors, creditors);
                this.journalEntries.add(journalEntry);
            }
            return obj;
        }
    }
}

