/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.loader.yaml;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.ErrorMessage;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Node;
import net.osdn.aoiro.model.NodeUtil;
import net.osdn.aoiro.report.layout.BalanceSheetLayout;
import net.osdn.aoiro.report.layout.ProfitAndLossLayout;
import net.osdn.aoiro.report.layout.StatementOfChangesInEquityLayout;

public class AccountTitlesLoader {
    private Path path;
    private Set<AccountTitle> accountTitles;
    private ProfitAndLossLayout plLayout = new ProfitAndLossLayout();
    private BalanceSheetLayout bsLayout = new BalanceSheetLayout();
    private StatementOfChangesInEquityLayout sceLayout = new StatementOfChangesInEquityLayout();
    private Map<String, AccountTitle> builtinAccountTitles = new HashMap<String, AccountTitle>(){
        {
            this.put(AccountTitle.INCOME_SUMMARY.getDisplayName(), AccountTitle.INCOME_SUMMARY);
            this.put(AccountTitle.BALANCE.getDisplayName(), AccountTitle.BALANCE);
            this.put(AccountTitle.PRETAX_INCOME.getDisplayName(), AccountTitle.PRETAX_INCOME);
            this.put(AccountTitle.RETAINED_EARNINGS.getDisplayName(), AccountTitle.RETAINED_EARNINGS);
        }
    };
    private Map<String, AccountTitle> accountTitleByDisplayName = new HashMap<String, AccountTitle>(){
        {
            for (AccountTitle builtinAccountTitle : AccountTitlesLoader.this.builtinAccountTitles.values()) {
                this.put(builtinAccountTitle.getDisplayName(), builtinAccountTitle);
            }
        }
    };
    private Set<AccountTitle> unusedAccountTitles;

    public AccountTitlesLoader(Path path) {
        this.path = path;
    }

    /*
     * WARNING - void declaration
     */
    private void read(final boolean skipErrors) throws IOException {
        List list;
        Map map;
        List list2;
        Object obj;
        if (this.accountTitles != null) {
            return;
        }
        this.accountTitles = new LinkedHashSet<AccountTitle>();
        String yaml = Files.readString(this.path, StandardCharsets.UTF_8);
        try {
            obj = new YamlReader(yaml).read();
        }
        catch (YamlException e) {
            YamlBeansUtil.Message m = YamlBeansUtil.getMessage(e);
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + m.getLine() + "\u884c\u76ee, " + m.getColumn() + "\u6841\u76ee)\r\n " + m.getMessage());
        }
        if (obj == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        if (!(obj instanceof Map)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        Map root = (Map)obj;
        if ((obj = root.get("\u4ed5\u8a33")) == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u4ed5\u8a33\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj instanceof Map)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u4ed5\u8a33\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        Map map2 = (Map)obj;
        Object obj22 = map2.get("\u8cc7\u7523");
        if (obj22 == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cc7\u7523\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj22 instanceof List)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cc7\u7523\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        List list3 = (List)obj22;
        for (String string : list3) {
            void var10_64;
            AccountTitle accountTitle = this.builtinAccountTitles.get(string);
            if (accountTitle == null) {
                AccountTitle accountTitle2 = new AccountTitle(AccountType.Assets, string);
            }
            this.accountTitles.add((AccountTitle)var10_64);
            this.accountTitleByDisplayName.put(string, (AccountTitle)var10_64);
        }
        obj22 = map2.get("\u8ca0\u50b5");
        if (obj22 == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8ca0\u50b5\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj22 instanceof List)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8ca0\u50b5\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        List liabilities = (List)obj22;
        Iterator iterator = liabilities.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AccountTitle accountTitle = this.builtinAccountTitles.get(string);
            if (accountTitle == null) {
                accountTitle = new AccountTitle(AccountType.Liabilities, string);
            }
            this.accountTitles.add(accountTitle);
            this.accountTitleByDisplayName.put(string, accountTitle);
        }
        obj22 = map2.get("\u7d14\u8cc7\u7523");
        if (obj22 == null) {
            obj22 = map2.get("\u8cc7\u672c");
            if (obj22 == null) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cc7\u672c\u30fb\u7d14\u8cc7\u7523\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\uff08\u3069\u3061\u3089\u304b\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059\u3002\uff09");
            }
            if (!(obj22 instanceof List)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cc7\u672c\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
        } else if (!(obj22 instanceof List)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u7d14\u8cc7\u7523\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        if ((list2 = (List)obj22) != null) {
            for (Object displayName4 : list2) {
                AccountTitle accountTitle = this.builtinAccountTitles.get(displayName4);
                if (accountTitle == null) {
                    accountTitle = new AccountTitle(AccountType.Equity, (String)displayName4);
                }
                this.accountTitles.add(accountTitle);
                this.accountTitleByDisplayName.put((String)displayName4, accountTitle);
            }
        }
        if ((obj22 = map2.get("\u53ce\u76ca")) == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u53ce\u76ca\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj22 instanceof List)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u53ce\u76ca\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        List list4 = (List)obj22;
        for (Object displayName5 : list4) {
            AccountTitle accountTitle = this.builtinAccountTitles.get(displayName5);
            if (accountTitle == null) {
                accountTitle = new AccountTitle(AccountType.Revenue, (String)displayName5);
            }
            this.accountTitles.add(accountTitle);
            this.accountTitleByDisplayName.put((String)displayName5, accountTitle);
        }
        obj22 = map2.get("\u8cbb\u7528");
        if (obj22 == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cbb\u7528\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj22 instanceof List)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cbb\u7528\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        List expense = (List)obj22;
        for (String displayName6 : expense) {
            Object accountTitle = this.builtinAccountTitles.get(displayName6);
            if (accountTitle == null) {
                accountTitle = new AccountTitle(AccountType.Expense, displayName6);
            }
            this.accountTitles.add((AccountTitle)accountTitle);
            this.accountTitleByDisplayName.put(displayName6, (AccountTitle)accountTitle);
        }
        obj = root.get("\u640d\u76ca\u8a08\u7b97\u66f8");
        if (obj == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj instanceof Map)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        Map map3 = (Map)obj;
        this.plLayout.getRoot().setValue(new AbstractMap.SimpleEntry(new ArrayList(), null));
        this.retrieve(this.plLayout.getRoot(), map3, new NodeCallback<Map.Entry<List<AccountTitle>, Amount>>(){

            @Override
            public void initialize(Node<Map.Entry<List<AccountTitle>, Amount>> node) {
                node.setValue(new AbstractMap.SimpleEntry(new ArrayList(), null));
            }

            @Override
            public void setAccountTitles(Node<Map.Entry<List<AccountTitle>, Amount>> node, List<AccountTitle> list) {
                node.getValue().getKey().addAll(list);
            }

            @Override
            public AccountTitle findAccountTitle(String displayName) {
                AccountTitle accountTitle = AccountTitlesLoader.this.accountTitleByDisplayName.get(displayName);
                if (accountTitle == null) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306b\u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059: " + displayName);
                }
                if (accountTitle.getType() == AccountType.Assets) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306b\u8cc7\u7523\u306e\u52d8\u5b9a\u79d1\u76ee\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + displayName);
                }
                if (accountTitle.getType() == AccountType.Liabilities) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306b\u8ca0\u50b5\u306e\u52d8\u5b9a\u79d1\u76ee\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + displayName);
                }
                if (accountTitle.getType() == AccountType.Equity) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306b\u8cc7\u672c\uff08\u7d14\u8cc7\u7523\uff09\u306e\u52d8\u5b9a\u79d1\u76ee\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + displayName);
                }
                return accountTitle;
            }
        });
        for (Node node : this.plLayout.getRoot().getChildren()) {
            for (Node node2 : node.getChildren()) {
                List list5;
                if (!node2.getName().equals("\u58f2\u4e0a\u91d1\u984d\uff08\u96d1\u53ce\u5165\u3092\u542b\u3080\uff09") || (list5 = (List)((Map.Entry)node2.getValue()).getKey()) == null || list5.size() <= 0) continue;
                ArrayList<AccountTitle> accountTitles1 = new ArrayList<AccountTitle>();
                ArrayList<AccountTitle> accountTitles2 = new ArrayList<AccountTitle>();
                ArrayList<AccountTitle> accountTitles3 = new ArrayList<AccountTitle>();
                for (AccountTitle accountTitle : list5) {
                    if (accountTitle.getDisplayName().equals("\u5bb6\u4e8b\u6d88\u8cbb\u7b49")) {
                        accountTitles2.add(accountTitle);
                        continue;
                    }
                    if (accountTitle.getDisplayName().equals("\u96d1\u53ce\u5165")) {
                        accountTitles3.add(accountTitle);
                        continue;
                    }
                    accountTitles1.add(accountTitle);
                }
                Node child1 = new Node(node2.getLevel() + 1, "\u58f2\u4e0a\u91d1\u984d", new AbstractMap.SimpleEntry(accountTitles1, null));
                Node child2 = new Node(node2.getLevel() + 1, "\u5bb6\u4e8b\u6d88\u8cbb\u7b49", new AbstractMap.SimpleEntry(accountTitles2, null));
                Node child3 = new Node(node2.getLevel() + 1, "\u96d1\u53ce\u5165", new AbstractMap.SimpleEntry(accountTitles3, null));
                node2.getChildren().add(child1);
                node2.getChildren().add(child2);
                node2.getChildren().add(child3);
                node2.setValue(new AbstractMap.SimpleEntry(new ArrayList(), null));
            }
        }
        Map<Node<Map.Entry<List<AccountTitle>, Amount>>, List<Node<Map.Entry<List<AccountTitle>, Amount>>>> ancestors = NodeUtil.createAncestors(this.plLayout.getRoot());
        obj = root.get("\u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1");
        if (obj != null) {
            Object v;
            Object v2;
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v3 = map.get("\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057");
            if (v3 != null) {
                if (!(v3 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\uff08\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v3;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getSignReversedNames().add(e.toString().trim());
                }
            }
            if ((v2 = map.get("\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057")) != null) {
                if (!(v2 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\uff08\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v2;
                for (Object e : list) {
                    if (e == null) continue;
                    String name = e.toString().trim();
                    this.plLayout.getAlwaysShownNames().add(name);
                    for (Node<Map.Entry<List<AccountTitle>, Amount>> node : NodeUtil.findByName(this.plLayout.getRoot(), name)) {
                        for (Node<Map.Entry<List<AccountTitle>, Amount>> ancestor : ancestors.get(node)) {
                            this.plLayout.getAlwaysShownNames().add(ancestor.getName());
                        }
                    }
                }
            }
            if (NodeUtil.findByName(this.plLayout.getRoot(), "\u58f2\u4e0a\u91d1\u984d\uff08\u96d1\u53ce\u5165\u3092\u542b\u3080\uff09").size() > 0) {
                this.plLayout.getAlwaysShownNames().add("\u58f2\u4e0a\u91d1\u984d\uff08\u96d1\u53ce\u5165\u3092\u542b\u3080\uff09");
            }
            if ((v = map.get("\u5e38\u306b\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057")) == null) {
                this.plLayout.getAlwaysHiddenNames().add("\u58f2\u4e0a\u91d1\u984d");
                this.plLayout.getAlwaysHiddenNames().add("\u5bb6\u4e8b\u6d88\u8cbb\u7b49");
                this.plLayout.getAlwaysHiddenNames().add("\u96d1\u53ce\u5165");
            } else {
                if (!(v instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\uff08\u5e38\u306b\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getAlwaysHiddenNames().add(e.toString().trim());
                }
            }
            Object v4 = map.get("\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057");
            if (v4 != null) {
                if (!(v4 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\uff08\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v4;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getHiddenNamesIfZero().add(e.toString().trim());
                }
            }
        }
        if ((obj = root.get("\u8cb8\u501f\u5bfe\u7167\u8868")) == null) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!(obj instanceof Map)) {
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        map = (Map)obj;
        this.bsLayout.getRoot().setValue(new AbstractMap.SimpleEntry(new ArrayList(), null));
        this.retrieve(this.bsLayout.getRoot(), map, new NodeCallback<Map.Entry<List<AccountTitle>, Amount[]>>(){

            @Override
            public void initialize(Node<Map.Entry<List<AccountTitle>, Amount[]>> node) {
                node.setValue(new AbstractMap.SimpleEntry(new ArrayList(), null));
            }

            @Override
            public void setAccountTitles(Node<Map.Entry<List<AccountTitle>, Amount[]>> node, List<AccountTitle> list) {
                node.getValue().getKey().addAll(list);
            }

            @Override
            public AccountTitle findAccountTitle(String displayName) {
                AccountTitle accountTitle = AccountTitlesLoader.this.accountTitleByDisplayName.get(displayName);
                if (accountTitle == null) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306b\u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059: " + displayName);
                }
                if (accountTitle.getType() == AccountType.Revenue) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306b\u53ce\u76ca\u306e\u52d8\u5b9a\u79d1\u76ee\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + displayName);
                }
                if (accountTitle.getType() == AccountType.Expense) {
                    if (skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306b\u8cbb\u7528\u306e\u52d8\u5b9a\u79d1\u76ee\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093: " + displayName);
                }
                return accountTitle;
            }
        });
        obj = root.get("\u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1");
        if (obj != null) {
            Object v;
            Object v5;
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v6 = map.get("\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057");
            if (v6 != null) {
                if (!(v6 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1\uff08\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v6;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getSignReversedNames().add(e.toString().trim());
                }
            }
            if ((v5 = map.get("\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057")) != null) {
                if (!(v5 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1\uff08\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v5;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getAlwaysShownNames().add(e.toString().trim());
                }
            }
            if ((v = map.get("\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057")) != null) {
                if (!(v instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u8868\u793a\u5236\u5fa1\uff08\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getHiddenNamesIfZero().add(e.toString().trim());
                }
            }
        }
        if ((obj = root.get("\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8")) != null) {
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v = map.remove("\u5909\u52d5\u4e8b\u7531");
            if (v == null) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8\uff08\u5909\u52d5\u4e8b\u7531\uff09\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            if (!(v instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8\uff08\u5909\u52d5\u4e8b\u7531\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            Map map22 = (Map)v;
            for (Map.Entry entry : map22.entrySet()) {
                this.sceLayout.getReasons().put((String)entry.getKey(), (List)entry.getValue());
            }
            this.sceLayout.getRoot().setValue(new ArrayList());
            this.retrieve(this.sceLayout.getRoot(), map, new NodeCallback<List<AccountTitle>>(){

                @Override
                public void initialize(Node<List<AccountTitle>> node) {
                    node.setValue(new ArrayList());
                }

                @Override
                public void setAccountTitles(Node<List<AccountTitle>> node, List<AccountTitle> list) {
                    node.getValue().addAll(list);
                }

                @Override
                public AccountTitle findAccountTitle(String displayName) {
                    AccountTitle accountTitle = AccountTitlesLoader.this.accountTitleByDisplayName.get(displayName);
                    if (accountTitle == null) {
                        if (skipErrors) {
                            return null;
                        }
                        throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + AccountTitlesLoader.this.path + "\r\n \u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8\u306b\u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059: " + displayName);
                    }
                    return accountTitle;
                }
            });
        }
        if ((obj = root.get("\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057")) != null) {
            Object v;
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v7 = map.get("\u640d\u76ca\u8a08\u7b97\u66f8");
            if (v7 != null) {
                if (!(v7 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff08\u640d\u76ca\u8a08\u7b97\u66f8\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v7;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getSignReversedNames().add(e.toString().trim());
                }
            }
            if ((v = map.get("\u8cb8\u501f\u5bfe\u7167\u8868")) != null) {
                if (!(v instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff08\u8cb8\u501f\u5bfe\u7167\u8868\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getSignReversedNames().add(e.toString().trim());
                }
            }
        }
        if ((obj = root.get("\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057")) != null) {
            Object v;
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v8 = map.get("\u640d\u76ca\u8a08\u7b97\u66f8");
            if (v8 != null) {
                if (!(v8 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff08\u640d\u76ca\u8a08\u7b97\u66f8\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v8;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getAlwaysShownNames().add(e.toString().trim());
                }
            }
            if ((v = map.get("\u8cb8\u501f\u5bfe\u7167\u8868")) != null) {
                if (!(v instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\uff08\u8cb8\u501f\u5bfe\u7167\u8868\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getAlwaysShownNames().add(e.toString().trim());
                }
            }
        }
        if ((obj = root.get("\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057")) != null) {
            Object v;
            if (!(obj instanceof Map)) {
                throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            map = (Map)obj;
            Object v9 = map.get("\u640d\u76ca\u8a08\u7b97\u66f8");
            if (v9 != null) {
                if (!(v9 instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\uff08\u640d\u76ca\u8a08\u7b97\u66f8\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v9;
                for (Object e : list) {
                    if (e == null) continue;
                    this.plLayout.getHiddenNamesIfZero().add(e.toString().trim());
                }
            }
            if ((v = map.get("\u8cb8\u501f\u5bfe\u7167\u8868")) != null) {
                if (!(v instanceof List)) {
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + "\r\n \u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\uff08\u8cb8\u501f\u5bfe\u7167\u8868\uff09\u306e\u5f62\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                list = (List)v;
                for (Object e : list) {
                    if (e == null) continue;
                    this.bsLayout.getHiddenNamesIfZero().add(e.toString().trim());
                }
            }
        }
    }

    private <T> void retrieve(Node<T> parent, Map<String, Object> map, NodeCallback<T> callback) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Node node = new Node(parent.getLevel() + 1, key);
            callback.initialize(node);
            parent.getChildren().add(node);
            if (value == null) continue;
            if (value instanceof String) {
                AccountTitle accountTitle;
                String displayName = ((String)value).trim();
                if (displayName.length() <= 0 || (accountTitle = callback.findAccountTitle(displayName)) == null) continue;
                LinkedList<AccountTitle> list = new LinkedList<AccountTitle>();
                list.add(accountTitle);
                callback.setAccountTitles(node, list);
                continue;
            }
            if (value instanceof Map) {
                Map m = (Map)value;
                this.retrieve(node, m, callback);
                continue;
            }
            if (!(value instanceof List)) continue;
            LinkedList<AccountTitle> list = new LinkedList<AccountTitle>();
            List l = (List)value;
            for (Object obj : l) {
                String displayName = obj.toString().trim();
                AccountTitle accountTitle = callback.findAccountTitle(displayName);
                if (accountTitle == null) continue;
                list.add(accountTitle);
            }
            callback.setAccountTitles(node, list);
        }
    }

    private static <V> Set<AccountTitle> retrieve(Node<Map.Entry<List<AccountTitle>, V>> node) {
        HashSet<AccountTitle> accountTitles = new HashSet<AccountTitle>();
        for (AccountTitle accountTitle : node.getValue().getKey()) {
            accountTitles.add(accountTitle);
        }
        for (Node node2 : node.getChildren()) {
            accountTitles.addAll(AccountTitlesLoader.retrieve(node2));
        }
        return accountTitles;
    }

    public boolean validate() {
        boolean valid;
        Set<AccountTitle> unusedAccountTitles = this.getUnusedAccountTitles();
        boolean bl = valid = unusedAccountTitles.size() == 0;
        if (!valid) {
            for (AccountTitle accountTitle : unusedAccountTitles) {
                AccountType type = accountTitle.getType();
                if (type == AccountType.Revenue || type == AccountType.Expense) {
                    System.out.println(" [\u8b66\u544a] \u640d\u76ca\u8a08\u7b97\u66f8\u306b\u300c" + accountTitle.getDisplayName() + "\u300d\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    continue;
                }
                if (type != AccountType.Assets && type != AccountType.Liabilities && type != AccountType.Equity) continue;
                System.out.println(" [\u8b66\u544a] \u8cb8\u501f\u5bfe\u7167\u8868\u306b\u300c" + accountTitle.getDisplayName() + "\u300d\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            System.out.println();
        }
        return valid;
    }

    public Set<AccountTitle> getUnusedAccountTitles() {
        if (this.unusedAccountTitles == null) {
            this.unusedAccountTitles = AccountTitlesLoader.getUnusedAccountTitles(this.accountTitles, this.plLayout, this.bsLayout);
        }
        return this.unusedAccountTitles;
    }

    public static Set<AccountTitle> getUnusedAccountTitles(Set<AccountTitle> accountTitles, ProfitAndLossLayout plLayout, BalanceSheetLayout bsLayout) {
        LinkedHashSet<AccountTitle> unusedAccountTitles = new LinkedHashSet<AccountTitle>();
        Set<AccountTitle> plAccountTitles = AccountTitlesLoader.retrieve(plLayout.getRoot());
        Set<AccountTitle> bsAccountTitles = AccountTitlesLoader.retrieve(bsLayout.getRoot());
        for (AccountTitle accountTitle : accountTitles) {
            AccountType type = accountTitle.getType();
            if (!(type != AccountType.Revenue && type != AccountType.Expense || plAccountTitles.contains(accountTitle))) {
                unusedAccountTitles.add(accountTitle);
            }
            if (type != AccountType.Assets && type != AccountType.Liabilities && type != AccountType.Equity || bsAccountTitles.contains(accountTitle)) continue;
            unusedAccountTitles.add(accountTitle);
        }
        return unusedAccountTitles;
    }

    public Set<AccountTitle> getAccountTitles() throws IOException {
        this.read(false);
        return this.accountTitles;
    }

    public Set<AccountTitle> getAccountTitles(boolean skipErrors) throws IOException {
        this.read(skipErrors);
        return this.accountTitles;
    }

    public ProfitAndLossLayout getProfitAndLossLayout() throws IOException {
        this.read(false);
        return this.plLayout;
    }

    public ProfitAndLossLayout getProfitAndLossLayout(boolean skipErrors) throws IOException {
        this.read(skipErrors);
        return this.plLayout;
    }

    public BalanceSheetLayout getBalanceSheetLayout() throws IOException {
        this.read(false);
        return this.bsLayout;
    }

    public BalanceSheetLayout getBalanceSheetLayout(boolean skipErrors) throws IOException {
        this.read(skipErrors);
        return this.bsLayout;
    }

    public StatementOfChangesInEquityLayout getStatementOfChangesInEquityLayout() throws IOException {
        this.read(false);
        return this.sceLayout;
    }

    public StatementOfChangesInEquityLayout getStatementOfChangesInEquityLayout(boolean skipErrors) throws IOException {
        this.read(skipErrors);
        return this.sceLayout;
    }

    public static synchronized void write(Path file, Set<AccountTitle> accountTitles, ProfitAndLossLayout plLayout, BalanceSheetLayout bsLayout) throws IOException {
        AccountTitlesLoader.write(file, accountTitles, plLayout, bsLayout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void write(Path file, Set<AccountTitle> accountTitles, ProfitAndLossLayout plLayout, BalanceSheetLayout bsLayout, StatementOfChangesInEquityLayout sceLayout) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(AccountTitlesLoader.getYaml(accountTitles));
        sb.append(plLayout.getYaml(accountTitles));
        sb.append(bsLayout.getYaml(accountTitles));
        if (sceLayout != null) {
            sb.append(sceLayout.getYaml(accountTitles));
        }
        Path tmpFile = null;
        try {
            Path dir = file.getParent();
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            tmpFile = dir.resolve("\u52d8\u5b9a\u79d1\u76ee.tmp");
            Files.writeString(tmpFile, (CharSequence)sb.toString(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            try {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING);
            }
            if (tmpFile == null) return;
        }
        catch (Throwable throwable) {
            if (tmpFile == null) throw throwable;
            try {
                Files.deleteIfExists(tmpFile);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            Files.deleteIfExists(tmpFile);
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - void declaration
     */
    public static String getYaml(Set<AccountTitle> accountTitles) {
        void var8_16;
        void var8_14;
        void var8_12;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> assets = new ArrayList<String>();
        ArrayList<String> liabilities = new ArrayList<String>();
        ArrayList<String> equity = new ArrayList<String>();
        ArrayList<String> revenue = new ArrayList<String>();
        ArrayList<String> expense = new ArrayList<String>();
        for (AccountTitle accountTitle : accountTitles) {
            switch (accountTitle.getType()) {
                case Assets: {
                    assets.add(accountTitle.getDisplayName());
                    break;
                }
                case Liabilities: {
                    liabilities.add(accountTitle.getDisplayName());
                    break;
                }
                case Equity: {
                    equity.add(accountTitle.getDisplayName());
                    break;
                }
                case Revenue: {
                    revenue.add(accountTitle.getDisplayName());
                    break;
                }
                case Expense: {
                    expense.add(accountTitle.getDisplayName());
                }
            }
        }
        sb.append("\"\u4ed5\u8a33\":\r\n");
        sb.append("  \"\u8cc7\u7523\" : [ ");
        for (int i2 = 0; i2 < assets.size(); ++i2) {
            sb.append("\"");
            sb.append(YamlBeansUtil.escape((String)assets.get(i2)));
            sb.append("\"");
            if (i2 + 1 >= assets.size()) continue;
            sb.append(", ");
        }
        sb.append(" ]\r\n");
        sb.append("  \"\u8ca0\u50b5\" : [ ");
        for (int i = 0; i < liabilities.size(); ++i) {
            sb.append("\"");
            sb.append(YamlBeansUtil.escape((String)liabilities.get(i)));
            sb.append("\"");
            if (i + 1 >= liabilities.size()) continue;
            sb.append(", ");
        }
        sb.append(" ]\r\n");
        boolean isSoloProprietorship = true;
        for (String name : equity) {
            if (!name.equals("\u8cc7\u672c\u91d1")) continue;
            isSoloProprietorship = false;
            break;
        }
        if (isSoloProprietorship) {
            sb.append("  \"\u8cc7\u672c\" : [ ");
        } else {
            sb.append("  \"\u7d14\u8cc7\u7523\" : [ ");
        }
        boolean bl = false;
        while (var8_12 < equity.size()) {
            sb.append("\"");
            sb.append(YamlBeansUtil.escape((String)equity.get((int)var8_12)));
            sb.append("\"");
            if (var8_12 + true < equity.size()) {
                sb.append(", ");
            }
            ++var8_12;
        }
        sb.append(" ]\r\n");
        sb.append("  \"\u53ce\u76ca\" : [ ");
        boolean bl2 = false;
        while (var8_14 < revenue.size()) {
            sb.append("\"");
            sb.append(YamlBeansUtil.escape((String)revenue.get((int)var8_14)));
            sb.append("\"");
            if (var8_14 + true < revenue.size()) {
                sb.append(", ");
            }
            ++var8_14;
        }
        sb.append(" ]\r\n");
        sb.append("  \"\u8cbb\u7528\" : [ ");
        boolean bl3 = false;
        while (var8_16 < expense.size()) {
            sb.append("\"");
            sb.append(YamlBeansUtil.escape((String)expense.get((int)var8_16)));
            sb.append("\"");
            if (var8_16 + true < expense.size()) {
                sb.append(", ");
            }
            ++var8_16;
        }
        sb.append(" ]\r\n");
        sb.append("\r\n\r\n");
        return sb.toString();
    }

    private static interface NodeCallback<T> {
        public void initialize(Node<T> var1);

        public void setAccountTitles(Node<T> var1, List<AccountTitle> var2);

        public AccountTitle findAccountTitle(String var1);
    }
}

