/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.loader.yaml;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.parser.Parser;
import com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.ErrorMessage;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.ProportionalDivision;

public class ProportionalDivisionsLoader {
    private Path path;
    private Map<String, AccountTitle> accountTitleByDisplayName;

    public ProportionalDivisionsLoader(Path path, Set<AccountTitle> accountTitles) {
        this.path = path;
        this.accountTitleByDisplayName = new HashMap<String, AccountTitle>();
        for (AccountTitle accountTitle : accountTitles) {
            this.accountTitleByDisplayName.put(accountTitle.getDisplayName(), accountTitle);
        }
    }

    public List<ProportionalDivision> getProportionalDivisions() throws IOException {
        return this.getProportionalDivisions(false);
    }

    public List<ProportionalDivision> getProportionalDivisions(boolean skipErrors) throws IOException {
        try {
            ItemReader reader = new ItemReader(this.path, skipErrors);
            reader.read();
            return reader.proportionalDivisions;
        }
        catch (YamlException e) {
            YamlBeansUtil.Message m = YamlBeansUtil.getMessage(e);
            throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + m.getLine() + "\u884c\u76ee, " + m.getColumn() + "\u6841\u76ee)\r\n " + m.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void write(Path file, List<ProportionalDivision> proportionalDivisions) throws IOException {
        String yaml = ProportionalDivisionsLoader.getYaml(proportionalDivisions);
        Path tmpFile = null;
        try {
            Path dir = file.getParent();
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            tmpFile = dir.resolve("\u5bb6\u4e8b\u6309\u5206.tmp");
            Files.writeString(tmpFile, (CharSequence)yaml, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            try {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tmpFile, file, StandardCopyOption.REPLACE_EXISTING);
            }
            if (tmpFile == null) return;
        }
        catch (Throwable throwable) {
            if (tmpFile == null) throw throwable;
            try {
                Files.deleteIfExists(tmpFile);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            Files.deleteIfExists(tmpFile);
            return;
        }
        catch (Exception exception) {}
    }

    public static String getYaml(List<ProportionalDivision> proportionalDivisions) {
        return ProportionalDivisionsLoader.getYaml(proportionalDivisions, null);
    }

    public static String getYaml(List<ProportionalDivision> proportionalDivisions, Set<AccountTitle> filter) {
        StringBuilder sb = new StringBuilder();
        if (proportionalDivisions != null) {
            for (ProportionalDivision proportionalDivision : proportionalDivisions) {
                if (filter != null && !filter.contains(proportionalDivision.getAccountTitle())) continue;
                sb.append("- { \"\u52d8\u5b9a\u79d1\u76ee\" : \"");
                sb.append(YamlBeansUtil.escape(proportionalDivision.getAccountTitle().getDisplayName()));
                sb.append("\", \"\u4e8b\u696d\u5272\u5408\" : ");
                sb.append(proportionalDivision.getBusinessRatio() * 100.0);
                sb.append(" }\r\n");
            }
        }
        return sb.toString();
    }

    private static class Item {
        public String \u52d8\u5b9a\u79d1\u76ee;
        public String \u4e8b\u696d\u5272\u5408;

        private Item() {
        }
    }

    private class ItemReader
    extends YamlReader {
        private Path path;
        private boolean skipErrors;
        private List<ProportionalDivision> proportionalDivisions;

        public ItemReader(Path path, boolean skipErrors) throws IOException {
            super(Files.readString(path, StandardCharsets.UTF_8));
            this.proportionalDivisions = new ArrayList<ProportionalDivision>();
            this.path = path;
            this.skipErrors = skipErrors;
        }

        public List<Item> read() throws YamlException {
            return (List)super.read(List.class, Item.class);
        }

        protected Object readValue(Class type, Class elementType, Class defaultType) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
            if (type != Item.class) {
                return super.readValue(type, elementType, defaultType);
            }
            YamlBeansUtil.Position pos = YamlBeansUtil.getPosition(this);
            int line = pos.line + 0;
            Object obj = super.readValue(type, elementType, defaultType);
            if (obj instanceof Item) {
                double businessRatio;
                Item item = (Item)obj;
                if (item.\u52d8\u5b9a\u79d1\u76ee == null) {
                    if (this.skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                AccountTitle accountTitle = ProportionalDivisionsLoader.this.accountTitleByDisplayName.get(item.\u52d8\u5b9a\u79d1\u76ee.trim());
                if (accountTitle == null) {
                    if (this.skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u672a\u5b9a\u7fa9\u306e\u52d8\u5b9a\u79d1\u76ee\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + item.\u52d8\u5b9a\u79d1\u76ee);
                }
                if (item.\u4e8b\u696d\u5272\u5408 == null) {
                    if (this.skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u4e8b\u696d\u5272\u5408\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                item.\u4e8b\u696d\u5272\u5408 = item.\u4e8b\u696d\u5272\u5408.trim();
                try {
                    businessRatio = Double.parseDouble(item.\u4e8b\u696d\u5272\u5408) / 100.0;
                }
                catch (Exception e) {
                    if (this.skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u4e8b\u696d\u5272\u5408\u306f\u6570\u5024\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044: " + item.\u4e8b\u696d\u5272\u5408);
                }
                if (businessRatio < 0.0 || businessRatio > 1.0) {
                    if (this.skipErrors) {
                        return null;
                    }
                    throw ErrorMessage.error(" [\u30a8\u30e9\u30fc] " + this.path + " (" + line + "\u884c\u76ee)\r\n \u4e8b\u696d\u5272\u5408\u306f 0\uff5e100 \u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044: " + item.\u4e8b\u696d\u5272\u5408);
                }
                ProportionalDivision proportionalDivision = new ProportionalDivision(accountTitle, businessRatio);
                this.proportionalDivisions.add(proportionalDivision);
            }
            return obj;
        }
    }
}

