/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.chrono.JapaneseChronology;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.Account;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.Node;
import net.osdn.aoiro.report.layout.BalanceSheetLayout;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.PdfBrewer;

public class BalanceSheet {
    public static String MINUS_SIGN = "\u25b3";
    private static final int ROWS = 40;
    private static final double ROW_HEIGHT = 6.0;
    private BalanceSheetLayout bsLayout;
    private List<JournalEntry> journalEntries;
    private boolean isSoloProprietorship;
    private LocalDate openingDate;
    private LocalDate closingDate;
    private Map<AccountTitle, Amount> openingBalances = new HashMap<AccountTitle, Amount>();
    private Map<AccountTitle, Amount> closingBalances = new HashMap<AccountTitle, Amount>();
    private List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> assetsList;
    private List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> liabilitiesList;
    private List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> equityList;
    private List<String> pageData = new ArrayList<String>();
    private List<String> printData;
    private FontLoader fontLoader;
    private boolean bindingMarginEnabled = true;
    private List<String> warnings = new ArrayList<String>();

    public BalanceSheet(BalanceSheetLayout bsLayout, List<JournalEntry> journalEntries, boolean isSoloProprietorship) throws IOException {
        String msg;
        Amount amount;
        AccountTitle accountTitle;
        String line;
        this.bsLayout = bsLayout;
        this.journalEntries = journalEntries;
        this.isSoloProprietorship = isSoloProprietorship;
        this.openingDate = AccountSettlement.getOpeningDate(journalEntries, isSoloProprietorship);
        this.closingDate = AccountSettlement.getClosingDate(journalEntries, isSoloProprietorship);
        InputStream in = this.getClass().getResourceAsStream("/templates/\u8cb8\u501f\u5bfe\u7167\u8868.pb");
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = r.readLine()) != null) {
            this.pageData.add(line);
        }
        r.close();
        for (JournalEntry journalEntry : journalEntries) {
            Amount amount2;
            if (journalEntry.isOpening(isSoloProprietorship, this.openingDate)) {
                for (Debtor debtor : journalEntry.getDebtors()) {
                    Amount amount22 = this.openingBalances.get(debtor.getAccountTitle());
                    if (amount22 == null) {
                        amount22 = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.openingBalances.put(debtor.getAccountTitle(), amount22);
                    }
                    if (debtor.getAccountTitle().getType().getNormalBalance() == Debtor.class) {
                        amount22.increase(debtor.getAmount());
                        continue;
                    }
                    amount22.decrease(debtor.getAmount());
                }
                for (Creditor creditor : journalEntry.getCreditors()) {
                    amount2 = this.openingBalances.get(creditor.getAccountTitle());
                    if (amount2 == null) {
                        amount2 = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.openingBalances.put(creditor.getAccountTitle(), amount2);
                    }
                    if (creditor.getAccountTitle().getType().getNormalBalance() == Creditor.class) {
                        amount2.increase(creditor.getAmount());
                        continue;
                    }
                    amount2.decrease(creditor.getAmount());
                }
            }
            if (!journalEntry.isBalance()) continue;
            for (Debtor debtor : journalEntry.getDebtors()) {
                if (debtor.getAccountTitle().equals(AccountTitle.BALANCE)) continue;
                amount2 = this.closingBalances.get(debtor.getAccountTitle());
                if (amount2 == null) {
                    amount2 = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                    this.closingBalances.put(debtor.getAccountTitle(), amount2);
                }
                if (debtor.getAccountTitle().getType().getNormalBalance() != Debtor.class) {
                    amount2.increase(debtor.getAmount());
                    continue;
                }
                amount2.decrease(debtor.getAmount());
            }
            for (Creditor creditor : journalEntry.getCreditors()) {
                if (creditor.getAccountTitle().equals(AccountTitle.BALANCE)) continue;
                amount2 = this.closingBalances.get(creditor.getAccountTitle());
                if (amount2 == null) {
                    amount2 = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                    this.closingBalances.put(creditor.getAccountTitle(), amount2);
                }
                if (creditor.getAccountTitle().getType().getNormalBalance() != Creditor.class) {
                    amount2.increase(creditor.getAmount());
                    continue;
                }
                amount2.decrease(creditor.getAmount());
            }
        }
        this.retrieve(null, bsLayout.getRoot(), journalEntries);
        for (Node node : bsLayout.getRoot().getChildren()) {
            if (node.getName().equals("\u8cc7\u7523")) {
                this.assetsList = this.getList(node);
                continue;
            }
            if (node.getName().equals("\u8ca0\u50b5")) {
                this.liabilitiesList = this.getList(node);
                continue;
            }
            if (!node.getName().equals("\u8cc7\u672c") && !node.getName().equals("\u7d14\u8cc7\u7523")) continue;
            this.equityList = this.getList(node);
        }
        if (this.assetsList == null) {
            this.assetsList = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount[]>>>();
        }
        if (this.liabilitiesList == null) {
            this.liabilitiesList = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount[]>>>();
        }
        if (this.equityList == null) {
            this.equityList = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount[]>>>();
        }
        for (Map.Entry entry : this.openingBalances.entrySet()) {
            accountTitle = (AccountTitle)entry.getKey();
            amount = (Amount)entry.getValue();
            NumberFormat.getNumberInstance();
            int sign = bsLayout.isSignReversed(accountTitle.getDisplayName()) ? -1 : 1;
            if ((long)sign * amount.getValue() >= 0L || accountTitle.getType() != AccountType.Assets && accountTitle.getType() != AccountType.Liabilities) continue;
            msg = " [\u8b66\u544a] \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u300c" + accountTitle.getDisplayName() + "\u300d\u671f\u9996\u6b8b\u9ad8\u304c\u30de\u30a4\u30ca\u30b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002(" + accountTitle.getDisplayName() + " " + NumberFormat.getNumberInstance().format(amount.getValue()) + ")";
            this.warnings.add(msg);
        }
        for (Map.Entry entry : this.closingBalances.entrySet()) {
            accountTitle = (AccountTitle)entry.getKey();
            amount = (Amount)entry.getValue();
            NumberFormat.getNumberInstance();
            int sign = bsLayout.isSignReversed(accountTitle.getDisplayName()) ? -1 : 1;
            if ((long)sign * amount.getValue() >= 0L || accountTitle.getType() != AccountType.Assets && accountTitle.getType() != AccountType.Liabilities) continue;
            msg = " [\u8b66\u544a] \u8cb8\u501f\u5bfe\u7167\u8868\u306e\u300c" + accountTitle.getDisplayName() + "\u300d\u671f\u672b\u6b8b\u9ad8\u304c\u30de\u30a4\u30ca\u30b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002(" + accountTitle.getDisplayName() + " " + NumberFormat.getNumberInstance().format(amount.getValue()) + ")";
            this.warnings.add(msg);
        }
    }

    public List<JournalEntry> getJournalEntries() {
        return this.journalEntries;
    }

    public Map<AccountTitle, Amount> getOpeningBalances() {
        return this.openingBalances;
    }

    public Map<AccountTitle, Amount> getClosingBalances() {
        return this.closingBalances;
    }

    public List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> getAssetsList() {
        return this.assetsList;
    }

    public List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> getLiabilitiesList() {
        return this.liabilitiesList;
    }

    public List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> getEquityList() {
        return this.equityList;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    private Amount[] retrieve(Class<? extends Account> normalBalance, Node<Map.Entry<List<AccountTitle>, Amount[]>> node, List<JournalEntry> journalEntries) {
        if (normalBalance == null && node.getLevel() == 1) {
            if (node.getName().equals("\u8cc7\u7523")) {
                normalBalance = Debtor.class;
            } else if (node.getName().equals("\u8ca0\u50b5") || node.getName().equals("\u8cc7\u672c") || node.getName().equals("\u7d14\u8cc7\u7523")) {
                normalBalance = Creditor.class;
            }
        }
        Amount openingBalance = null;
        Amount closingBalance = null;
        for (Node<Map.Entry<List<AccountTitle>, Amount[]>> child : node.getChildren()) {
            Amount[] a = this.retrieve(normalBalance, child, journalEntries);
            if (a[0] != null) {
                if (openingBalance == null) {
                    openingBalance = new Amount(normalBalance != null ? normalBalance : a[0].getNormalBalance(), 0L);
                }
                openingBalance.increase(a[0]);
            }
            if (a[1] == null) continue;
            if (closingBalance == null) {
                closingBalance = new Amount(normalBalance != null ? normalBalance : a[1].getNormalBalance(), 0L);
            }
            closingBalance.increase(a[1]);
        }
        if (node.getValue().getKey() != null) {
            for (AccountTitle accountTitle : node.getValue().getKey()) {
                Amount c;
                Amount o = this.openingBalances.get(accountTitle);
                if (o != null) {
                    if (openingBalance == null) {
                        openingBalance = new Amount(normalBalance != null ? normalBalance : o.getNormalBalance(), 0L);
                    }
                    openingBalance.increase(o);
                }
                if ((c = this.closingBalances.get(accountTitle)) == null) continue;
                if (closingBalance == null) {
                    closingBalance = new Amount(normalBalance != null ? normalBalance : o.getNormalBalance(), 0L);
                }
                closingBalance.increase(c);
            }
        }
        Amount[] amounts = new Amount[]{openingBalance, closingBalance};
        node.getValue().setValue(amounts);
        return amounts;
    }

    protected List<Node<Map.Entry<List<AccountTitle>, Amount[]>>> getList(Node<Map.Entry<List<AccountTitle>, Amount[]>> node) {
        ArrayList<Node<Map.Entry<List<AccountTitle>, Amount[]>>> list = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount[]>>>();
        list.add(node);
        for (Node<Map.Entry<List<AccountTitle>, Amount[]>> child : node.getChildren()) {
            list.addAll(this.getList(child));
        }
        return list;
    }

    protected void prepare() {
        int sign;
        Amount closingAmount;
        Amount openingAmount;
        String displayName;
        Node<Map.Entry<List<AccountTitle>, Amount[]>> node;
        int i;
        long v;
        Amount closingAmount2;
        Amount openingAmount2;
        Node<Map.Entry<List<AccountTitle>, Amount[]>> node2;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("GGGG y \u5e74 M \u6708 d \u65e5").withChronology(JapaneseChronology.INSTANCE);
        String openingDate = dtf.format(this.openingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        String openingMonth = Integer.toString(this.openingDate.getMonthValue());
        String openingDay = Integer.toString(this.openingDate.getDayOfMonth());
        String closingDate = dtf.format(this.closingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        String closingMonth = Integer.toString(this.closingDate.getMonthValue());
        String closingDay = Integer.toString(this.closingDate.getDayOfMonth());
        this.printData = new ArrayList<String>();
        if (this.bindingMarginEnabled) {
            this.printData.add("\\media A4");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 148.5 5 148.5");
            this.printData.add("\\box 15 0 0 0");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 0 0 -0");
            this.printData.add("\\box 25 0 -10 -10");
        } else {
            this.printData.add("\\media 195 297");
            this.printData.add("\\box 10 0 -10 -10");
        }
        this.printData.addAll(this.pageData);
        this.printData.add("\t\\box 0 16 -0 7");
        this.printData.add("\t\\font serif 10");
        this.printData.add("\t\\align center");
        this.printData.add("\t\\text " + openingDate + " \uff5e " + closingDate);
        this.printData.add("\t\\box 0 31 -0 6");
        this.printData.add("\t\\align center center");
        this.printData.add("\t\t\\box 37.0 0 5 -0");
        this.printData.add("\t\t\\text " + openingMonth);
        this.printData.add("\t\t\\box 44.7 0 5 -0");
        this.printData.add("\t\t\\text " + openingDay);
        this.printData.add("\t\t\\box 124.5 0 5 -0");
        this.printData.add("\t\t\\text " + openingMonth);
        this.printData.add("\t\t\\box 132.2 0 5 -0");
        this.printData.add("\t\t\\text " + openingDay);
        this.printData.add("\t\t\\box 63.0 0 5 -0");
        this.printData.add("\t\t\\text " + closingMonth);
        this.printData.add("\t\t\\box 70.7 0 5 -0");
        this.printData.add("\t\t\\text " + closingDay);
        this.printData.add("\t\t\\box 150.5 0 5 -0");
        this.printData.add("\t\t\\text " + closingMonth);
        this.printData.add("\t\t\\box 158.2 0 5 -0");
        this.printData.add("\t\t\\text " + closingDay);
        this.printData.add("\t\\box 0 25 -0 6");
        this.printData.add("\t\t\\font sans-serif 9");
        this.printData.add("\t\t\\align center");
        this.printData.add("\t\t\\box 87.5 0 87.5 -0");
        if (this.isSoloProprietorship) {
            this.printData.add("\t\t\\text \u8ca0\u3000\u50b5\u3000\u30fb\u3000\u8cc7\u3000\u672c\u3000\u306e\u3000\u90e8");
        } else {
            this.printData.add("\t\t\\text \u8ca0\u3000\u50b5\u3000\u30fb\u3000\u7d14\u3000\u8cc7\u3000\u7523\u3000\u306e\u3000\u90e8");
        }
        long maxAmount = 0L;
        if (this.assetsList.size() > 0) {
            node2 = this.assetsList.get(0);
            openingAmount2 = node2.getValue().getValue()[0];
            closingAmount2 = node2.getValue().getValue()[1];
            if (openingAmount2 != null && (v = Math.abs(openingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
            if (closingAmount2 != null && (v = Math.abs(closingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
        }
        if (this.liabilitiesList.size() > 0) {
            node2 = this.liabilitiesList.get(0);
            openingAmount2 = node2.getValue().getValue()[0];
            closingAmount2 = node2.getValue().getValue()[1];
            if (openingAmount2 != null && (v = Math.abs(openingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
            if (closingAmount2 != null && (v = Math.abs(closingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
        }
        if (this.equityList.size() > 0) {
            node2 = this.liabilitiesList.get(0);
            openingAmount2 = node2.getValue().getValue()[0];
            closingAmount2 = node2.getValue().getValue()[1];
            if (openingAmount2 != null && (v = Math.abs(openingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
            if (closingAmount2 != null && (v = Math.abs(closingAmount2.getValue())) > maxAmount) {
                maxAmount = v;
            }
        }
        int assetsRows = 1;
        for (int i2 = 1; i2 < this.assetsList.size(); ++i2) {
            long v2;
            Node<Map.Entry<List<AccountTitle>, Amount[]>> node3 = this.assetsList.get(i2);
            String displayName2 = node3.getName();
            Amount openingAmount3 = node3.getValue().getValue()[0];
            Amount closingAmount3 = node3.getValue().getValue()[1];
            if (openingAmount3 != null && (v2 = Math.abs(openingAmount3.getValue())) > maxAmount) {
                maxAmount = v2;
            }
            if (closingAmount3 != null && (v2 = Math.abs(closingAmount3.getValue())) > maxAmount) {
                maxAmount = v2;
            }
            if (openingAmount3 == null && closingAmount3 == null && !this.bsLayout.isAlwaysShown(displayName2) || (openingAmount3 == null || openingAmount3.getValue() == 0L) && (closingAmount3 == null || closingAmount3.getValue() == 0L) && this.bsLayout.isHidden(displayName2)) continue;
            ++assetsRows;
        }
        int liabilitiesRows = 1;
        for (int i3 = 1; i3 < this.liabilitiesList.size(); ++i3) {
            long v3;
            Node<Map.Entry<List<AccountTitle>, Amount[]>> node4 = this.liabilitiesList.get(i3);
            String displayName3 = node4.getName();
            Amount openingAmount4 = node4.getValue().getValue()[0];
            Amount closingAmount4 = node4.getValue().getValue()[1];
            if (openingAmount4 != null && (v3 = Math.abs(openingAmount4.getValue())) > maxAmount) {
                maxAmount = v3;
            }
            if (closingAmount4 != null && (v3 = Math.abs(closingAmount4.getValue())) > maxAmount) {
                maxAmount = v3;
            }
            if (openingAmount4 == null && closingAmount4 == null && !this.bsLayout.isAlwaysShown(displayName3) || (openingAmount4 == null || openingAmount4.getValue() == 0L) && (closingAmount4 == null || closingAmount4.getValue() == 0L) && this.bsLayout.isHidden(displayName3)) continue;
            ++liabilitiesRows;
        }
        int equityRows = 1;
        for (int i4 = 1; i4 < this.equityList.size(); ++i4) {
            long v4;
            Node<Map.Entry<List<AccountTitle>, Amount[]>> node5 = this.equityList.get(i4);
            String displayName4 = node5.getName();
            Amount openingAmount5 = node5.getValue().getValue()[0];
            Amount closingAmount5 = node5.getValue().getValue()[1];
            if (openingAmount5 != null && (v4 = Math.abs(openingAmount5.getValue())) > maxAmount) {
                maxAmount = v4;
            }
            if (closingAmount5 != null && (v4 = Math.abs(closingAmount5.getValue())) > maxAmount) {
                maxAmount = v4;
            }
            if (openingAmount5 == null && closingAmount5 == null && !this.bsLayout.isAlwaysShown(displayName4) || (openingAmount5 == null || openingAmount5.getValue() == 0L) && (closingAmount5 == null || closingAmount5.getValue() == 0L) && this.bsLayout.isHidden(displayName4)) continue;
            ++equityRows;
        }
        double amountPrintWidth = 22.0;
        if (maxAmount > 99999999999L) {
            amountPrintWidth = 26.0;
        } else if (maxAmount > 9999999999L) {
            amountPrintWidth = 25.0;
        } else if (maxAmount > 999999999L) {
            amountPrintWidth = 24.0;
        }
        int rows = Math.max(assetsRows, liabilitiesRows + equityRows);
        this.printData.add("\t\\box 0 0 -0 -0");
        this.printData.add("\t\\line-style thin solid");
        this.printData.add("\t\\line " + String.format("87.3 %.2f 87.3 %.2f", 25.2, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\line " + String.format("87.7 %.2f 87.7 %.2f", 25.2, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\line " + String.format("35.5 %.2f 35.5 %.2f", 31.0, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\line " + String.format("61.5 %.2f 61.5 %.2f", 31.0, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\line " + String.format("123  %.2f 123  %.2f", 31.0, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\line " + String.format("149  %.2f 149  %.2f", 31.0, 37.0 + (double)rows * 6.0));
        this.printData.add("\t\\box 0 37 -0 -0");
        this.printData.add("\t\\font serif 10");
        this.printData.add("\t\\line-style thin dot");
        double y = 0.0;
        for (i = 1; i < rows; ++i) {
            this.printData.add("\t\\line " + String.format("0 %.2f -0 %.2f", y, y));
            y += 6.0;
        }
        this.printData.add("\t\\line-style thin solid");
        this.printData.add("\t\\line " + String.format("0 %.2f -0 %.2f", y, y));
        this.printData.add("\t\\line " + String.format("0 %.2f -0 %.2f", y += 6.0, y));
        this.printData.add("\t\\line " + String.format("0 %.2f -0 %.2f", y + 0.4, y + 0.4));
        y = 0.0;
        for (i = 1; i < this.assetsList.size(); ++i) {
            node = this.assetsList.get(i);
            displayName = node.getName();
            openingAmount = node.getValue().getValue()[0];
            closingAmount = node.getValue().getValue()[1];
            int n = sign = this.bsLayout.isSignReversed(node.getName()) ? -1 : 1;
            if ("\u4e8b\u696d\u4e3b\u8cb8".equals(node.getName())) {
                this.printData.add("\t\t\\box " + String.format("35.5 %.2f 26 %.2f", y, 6.0));
                this.printData.add("\t\t\\line-style thin dot");
                this.printData.add("\t\t\\line -0 0.15 0 -0.15");
            }
            if (openingAmount == null && closingAmount == null && !this.bsLayout.isAlwaysShown(displayName) || (openingAmount == null || openingAmount.getValue() == 0L) && (closingAmount == null || closingAmount.getValue() == 0L) && this.bsLayout.isHidden(displayName)) continue;
            this.printData.add("\t\t\\box " + String.format("2 %.2f 35.5 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName);
            this.printData.add("\t\t\\align center right");
            if (openingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("35.5 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * openingAmount.getValue()));
            }
            if (closingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("61.5 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * closingAmount.getValue()));
            }
            y += 6.0;
        }
        y = 0.0;
        for (i = 1; i < this.liabilitiesList.size(); ++i) {
            node = this.liabilitiesList.get(i);
            displayName = node.getName();
            openingAmount = node.getValue().getValue()[0];
            closingAmount = node.getValue().getValue()[1];
            int n = sign = this.bsLayout.isSignReversed(node.getName()) ? -1 : 1;
            if (openingAmount == null && closingAmount == null && !this.bsLayout.isAlwaysShown(displayName) || (openingAmount == null || openingAmount.getValue() == 0L) && (closingAmount == null || closingAmount.getValue() == 0L) && this.bsLayout.isHidden(displayName)) continue;
            this.printData.add("\t\t\\box " + String.format("89.5 %.2f 35.5 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName);
            this.printData.add("\t\t\\align center right");
            if (openingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("123 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * openingAmount.getValue()));
            }
            if (closingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("149 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * closingAmount.getValue()));
            }
            y += 6.0;
        }
        y = (double)(rows - this.equityList.size()) * 6.0;
        this.printData.add("\t\\line " + String.format("87.7 %.2f -0 %.2f", y, y));
        for (i = 1; i < this.equityList.size(); ++i) {
            node = this.equityList.get(i);
            displayName = node.getName();
            openingAmount = node.getValue().getValue()[0];
            closingAmount = node.getValue().getValue()[1];
            int n = sign = this.bsLayout.isSignReversed(node.getName()) ? -1 : 1;
            if ("\u4e8b\u696d\u4e3b\u501f".equals(node.getName()) || "\u63a7\u9664\u524d\u306e\u6240\u5f97\u91d1\u984d".equals(node.getName())) {
                this.printData.add("\t\t\\box " + String.format("123 %.2f 26 %.2f", y, 6.0));
                this.printData.add("\t\t\\line-style thin dot");
                this.printData.add("\t\t\\line -0 0.15 0 -0.15");
            }
            if (openingAmount == null && closingAmount == null && !this.bsLayout.isAlwaysShown(displayName) || (openingAmount == null || openingAmount.getValue() == 0L) && (closingAmount == null || closingAmount.getValue() == 0L) && this.bsLayout.isHidden(displayName)) continue;
            this.printData.add("\t\t\\box " + String.format("89.5 %.2f 35.5 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName);
            this.printData.add("\t\t\\align center right");
            if (openingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("123 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * openingAmount.getValue()));
            }
            if (closingAmount != null) {
                this.printData.add("\t\t\\box " + String.format("149 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
                this.printData.add("\t\t\\text " + BalanceSheet.formatMoney((long)sign * closingAmount.getValue()));
            }
            y += 6.0;
        }
        y = (double)(rows - 1) * 6.0;
        if (this.assetsList.size() > 0) {
            Node<Map.Entry<List<AccountTitle>, Amount[]>> node6 = this.assetsList.get(0);
            String displayName5 = "\u5408\u8a08";
            Amount openingAmount6 = node6.getValue().getValue()[0];
            Amount closingAmount6 = node6.getValue().getValue()[1];
            this.printData.add("\t\t\\font serif 10 bold");
            this.printData.add("\t\t\\box " + String.format("2 %.2f 35.5 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName5);
            this.printData.add("\t\t\\align center right");
            this.printData.add("\t\t\\box " + String.format("35.5 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\\text " + BalanceSheet.formatMoney(openingAmount6 != null ? openingAmount6.getValue() : 0L));
            this.printData.add("\t\t\\box " + String.format("61.5 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\\text " + BalanceSheet.formatMoney(closingAmount6 != null ? closingAmount6.getValue() : 0L));
        }
        if (this.liabilitiesList.size() > 0 || this.equityList.size() > 0) {
            Amount c;
            Amount o;
            String displayName6 = "\u5408\u8a08";
            int openingAmount7 = 0;
            int closingAmount7 = 0;
            if (this.liabilitiesList.size() > 0) {
                o = this.liabilitiesList.get(0).getValue().getValue()[0];
                if (o != null) {
                    openingAmount7 = (int)((long)openingAmount7 + o.getValue());
                }
                if ((c = this.liabilitiesList.get(0).getValue().getValue()[1]) != null) {
                    closingAmount7 = (int)((long)closingAmount7 + c.getValue());
                }
            }
            if (this.equityList.size() > 0) {
                o = this.equityList.get(0).getValue().getValue()[0];
                if (o != null) {
                    openingAmount7 = (int)((long)openingAmount7 + o.getValue());
                }
                if ((c = this.equityList.get(0).getValue().getValue()[1]) != null) {
                    closingAmount7 = (int)((long)closingAmount7 + c.getValue());
                }
            }
            this.printData.add("\t\t\\font serif 10 bold");
            this.printData.add("\t\t\\box " + String.format("89.5 %.2f 35.5 %.2f", y, 6.0));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\text " + displayName6);
            this.printData.add("\t\t\\align center right");
            this.printData.add("\t\t\\box " + String.format("123 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\\text " + BalanceSheet.formatMoney(openingAmount7));
            this.printData.add("\t\t\\box " + String.format("149 %.2f %.2f %.2f", y, amountPrintWidth, 6.0));
            this.printData.add("\t\t\\text " + BalanceSheet.formatMoney(closingAmount7));
        }
    }

    public void setFontLoader(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    public void setBindingMarginEnabled(boolean enabled) {
        this.bindingMarginEnabled = enabled;
    }

    public void writeTo(Path path) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u8cb8\u501f\u5bfe\u7167\u8868");
        brewer.process(pb);
        brewer.save(path);
        brewer.close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u8cb8\u501f\u5bfe\u7167\u8868");
        brewer.process(pb);
        brewer.save(out);
        brewer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNextOpeningJournalEntries(List<AccountTitle> accountTitles, Path path) throws IOException {
        Amount amount;
        AccountTitle accountTitle;
        Object list;
        ArrayList<Map.Entry> debtors = new ArrayList<Map.Entry>();
        long debtorsTotal = 0L;
        ArrayList<Map.Entry> creditors = new ArrayList<Map.Entry>();
        long creditorsTotal = 0L;
        StringBuilder sb = new StringBuilder();
        String nextOpeningDate = null;
        if (this.closingDate != null) {
            nextOpeningDate = DateTimeFormatter.ISO_LOCAL_DATE.format(this.closingDate.plusDays(1L));
        }
        if (this.isSoloProprietorship) {
            Map.Entry<AccountTitle, Amount> e;
            list = new ArrayList<Map.Entry<AccountTitle, Amount>>(this.closingBalances.entrySet());
            Collections.sort(list, (o1, o2) -> accountTitles.indexOf(o1.getKey()) - accountTitles.indexOf(o2.getKey()));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                e = (Map.Entry<AccountTitle, Amount>)iterator.next();
                accountTitle = (AccountTitle)e.getKey();
                amount = (Amount)e.getValue();
                if (accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u8cb8") || accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u501f") || accountTitle.getDisplayName().equals("\u5143\u5165\u91d1") || accountTitle.equals(AccountTitle.PRETAX_INCOME)) continue;
                if (accountTitle.getType() == AccountType.Assets) {
                    if (amount.getValue() == 0L) continue;
                    if (amount.getValue() > 0L) {
                        debtors.add(e);
                        debtorsTotal += amount.getValue();
                        continue;
                    }
                    creditors.add(e);
                    creditorsTotal -= amount.getValue();
                    continue;
                }
                if (accountTitle.getType() != AccountType.Liabilities && accountTitle.getType() != AccountType.Equity || amount.getValue() == 0L) continue;
                if (amount.getValue() > 0L) {
                    creditors.add(e);
                    creditorsTotal += amount.getValue();
                    continue;
                }
                debtors.add(e);
                debtorsTotal -= amount.getValue();
            }
            AccountTitle capital = AccountTitle.getByDisplayName(new HashSet<AccountTitle>(accountTitles), "\u5143\u5165\u91d1");
            if (capital != null) {
                e = Map.entry(capital, new Amount(Creditor.class, debtorsTotal - creditorsTotal));
                if (debtorsTotal >= creditorsTotal) {
                    creditors.add(e);
                } else {
                    debtors.add(e);
                }
            }
            if (debtors.size() > 0 && creditors.size() > 0) {
                int i;
                sb.append("- \"\u65e5\u4ed8\" : \"" + nextOpeningDate + "\"\r\n");
                sb.append("  \"\u6458\u8981\" : \"\u5143\u5165\u91d1\"\r\n");
                sb.append("  \"\u501f\u65b9\" : [ ");
                for (i = 0; i < debtors.size(); ++i) {
                    accountTitle = (AccountTitle)((Map.Entry)debtors.get(i)).getKey();
                    amount = (Amount)((Map.Entry)debtors.get(i)).getValue();
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(accountTitle.getDisplayName()) + "\", \"\u91d1\u984d\" : " + Math.abs(amount.getValue()) + " }");
                    if (i + 1 >= debtors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("  \"\u8cb8\u65b9\" : [ ");
                for (i = 0; i < creditors.size(); ++i) {
                    accountTitle = (AccountTitle)((Map.Entry)creditors.get(i)).getKey();
                    amount = (Amount)((Map.Entry)creditors.get(i)).getValue();
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(accountTitle.getDisplayName()) + "\", \"\u91d1\u984d\" : " + Math.abs(amount.getValue()) + " }");
                    if (i + 1 >= creditors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
            }
        } else {
            list = new ArrayList<Map.Entry<AccountTitle, Amount>>(this.closingBalances.entrySet());
            Collections.sort(list, (o1, o2) -> accountTitles.indexOf(o1.getKey()) - accountTitles.indexOf(o2.getKey()));
            Iterator capital = list.iterator();
            while (capital.hasNext()) {
                Map.Entry e = (Map.Entry)capital.next();
                accountTitle = (AccountTitle)e.getKey();
                amount = (Amount)e.getValue();
                if (accountTitle.getType() == AccountType.Assets) {
                    if (amount.getValue() == 0L) continue;
                    if (amount.getValue() > 0L) {
                        debtors.add(e);
                        continue;
                    }
                    creditors.add(e);
                    continue;
                }
                if (accountTitle.getType() != AccountType.Liabilities && accountTitle.getType() != AccountType.Equity || amount.getValue() == 0L) continue;
                if (amount.getValue() > 0L) {
                    creditors.add(e);
                    continue;
                }
                debtors.add(e);
            }
            if (debtors.size() > 0 && creditors.size() > 0) {
                Amount amount2;
                AccountTitle accountTitle2;
                int i;
                sb.append("- \"\u65e5\u4ed8\" : \"" + nextOpeningDate + "\"\r\n");
                sb.append("  \"\u6458\u8981\" : \"\u524d\u671f\u7e70\u8d8a\"\r\n");
                sb.append("  \"\u501f\u65b9\" : [ ");
                for (i = 0; i < debtors.size(); ++i) {
                    accountTitle2 = (AccountTitle)((Map.Entry)debtors.get(i)).getKey();
                    amount2 = (Amount)((Map.Entry)debtors.get(i)).getValue();
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(accountTitle2.getDisplayName()) + "\", \"\u91d1\u984d\" : " + Math.abs(amount2.getValue()) + " }");
                    if (i + 1 >= debtors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("  \"\u8cb8\u65b9\" : [ ");
                for (i = 0; i < creditors.size(); ++i) {
                    accountTitle2 = (AccountTitle)((Map.Entry)creditors.get(i)).getKey();
                    amount2 = (Amount)((Map.Entry)creditors.get(i)).getValue();
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(accountTitle2.getDisplayName()) + "\", \"\u91d1\u984d\" : " + Math.abs(amount2.getValue()) + " }");
                    if (i + 1 >= creditors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
            }
        }
        block15: for (JournalEntry entry : this.journalEntries) {
            int i;
            if (entry.isClosing()) continue;
            for (Creditor creditor : entry.getCreditors()) {
                if (!creditor.getAccountTitle().getDisplayName().equals("\u671f\u672b\u5546\u54c1\u68da\u5378\u9ad8")) continue;
                sb.append("- \"\u65e5\u4ed8\" : \"" + nextOpeningDate + "\"\r\n");
                sb.append("  \"\u6458\u8981\" : \"\u671f\u9996\u68da\u5378\"\r\n");
                sb.append("  \"\u501f\u65b9\" : [ { \"\u52d8\u5b9a\u79d1\u76ee\" : \"\u671f\u9996\u5546\u54c1\u68da\u5378\u9ad8\", \"\u91d1\u984d\" : " + creditor.getAmount() + " } ]\r\n");
                sb.append("  \"\u8cb8\u65b9\" : [ ");
                for (i = 0; i < entry.getDebtors().size(); ++i) {
                    Debtor debtor = entry.getDebtors().get(i);
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(debtor.getAccountTitle().getDisplayName()) + "\", \"\u91d1\u984d\": " + debtor.getAmount() + " }");
                    if (i + 1 >= entry.getDebtors().size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
                break;
            }
            for (Debtor debtor : entry.getDebtors()) {
                if (!debtor.getAccountTitle().getDisplayName().equals("\u671f\u672b\u5546\u54c1\u68da\u5378\u9ad8")) continue;
                sb.append("- \"\u65e5\u4ed8\" : \"" + nextOpeningDate + "\"\r\n");
                sb.append("  \"\u6458\u8981\" : \"\u671f\u9996\u68da\u5378\"\r\n");
                sb.append("  \"\u501f\u65b9\" : [ ");
                for (i = 0; i < entry.getCreditors().size(); ++i) {
                    Creditor creditor = entry.getCreditors().get(i);
                    sb.append("{ \"\u52d8\u5b9a\u79d1\u76ee\" : \"" + YamlBeansUtil.escape(creditor.getAccountTitle().getDisplayName()) + "\", \"\u91d1\u984d\" : " + creditor.getAmount() + " }");
                    if (i + 1 >= entry.getCreditors().size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
                continue block15;
            }
        }
        String s = sb.toString();
        if (path != null && Files.isDirectory(path.getParent(), new LinkOption[0])) {
            Path tmpFile = null;
            try {
                Path dir = path.getParent();
                tmpFile = dir.resolve("\u6b21\u5e74\u5ea6\u306e\u958b\u59cb\u4ed5\u8a33.tmp");
                Files.writeString(tmpFile, (CharSequence)s, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
                try {
                    Files.move(tmpFile, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tmpFile, path, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                if (tmpFile != null) {
                    try {
                        Files.deleteIfExists(tmpFile);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNextOpeningJournalEntriesCompat(List<AccountTitle> accountTitles, Path path) throws IOException {
        Amount amount;
        AccountTitle accountTitle;
        Object list;
        ArrayList<Map.Entry> debtors = new ArrayList<Map.Entry>();
        long debtorsTotal = 0L;
        ArrayList<Map.Entry> creditors = new ArrayList<Map.Entry>();
        long creditorsTotal = 0L;
        StringBuilder sb = new StringBuilder();
        String nextOpeningDate = null;
        if (this.closingDate != null) {
            nextOpeningDate = DateTimeFormatter.ISO_LOCAL_DATE.format(this.closingDate.plusDays(1L));
        }
        if (this.isSoloProprietorship) {
            Map.Entry<AccountTitle, Amount> e;
            list = new ArrayList<Map.Entry<AccountTitle, Amount>>(this.closingBalances.entrySet());
            Collections.sort(list, (o1, o2) -> accountTitles.indexOf(o1.getKey()) - accountTitles.indexOf(o2.getKey()));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                e = (Map.Entry<AccountTitle, Amount>)iterator.next();
                accountTitle = (AccountTitle)e.getKey();
                amount = (Amount)e.getValue();
                if (accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u8cb8") || accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u501f") || accountTitle.getDisplayName().equals("\u5143\u5165\u91d1") || accountTitle.equals(AccountTitle.PRETAX_INCOME)) continue;
                if (accountTitle.getType() == AccountType.Assets) {
                    if (amount.getValue() == 0L) continue;
                    if (amount.getValue() > 0L) {
                        debtors.add(e);
                        debtorsTotal += amount.getValue();
                        continue;
                    }
                    creditors.add(e);
                    creditorsTotal -= amount.getValue();
                    continue;
                }
                if (accountTitle.getType() != AccountType.Liabilities && accountTitle.getType() != AccountType.Equity || amount.getValue() == 0L) continue;
                if (amount.getValue() > 0L) {
                    creditors.add(e);
                    creditorsTotal += amount.getValue();
                    continue;
                }
                debtors.add(e);
                debtorsTotal -= amount.getValue();
            }
            AccountTitle capital = AccountTitle.getByDisplayName(new HashSet<AccountTitle>(accountTitles), "\u5143\u5165\u91d1");
            if (capital != null) {
                e = Map.entry(capital, new Amount(Creditor.class, debtorsTotal - creditorsTotal));
                if (debtorsTotal >= creditorsTotal) {
                    creditors.add(e);
                } else {
                    debtors.add(e);
                }
            }
            if (debtors.size() > 0 && creditors.size() > 0) {
                int i;
                sb.append("- \u65e5\u4ed8: " + nextOpeningDate + "\r\n");
                sb.append("  \u6458\u8981: \u5143\u5165\u91d1\r\n");
                sb.append("  \u501f\u65b9: [ ");
                for (i = 0; i < debtors.size(); ++i) {
                    accountTitle = (AccountTitle)((Map.Entry)debtors.get(i)).getKey();
                    amount = (Amount)((Map.Entry)debtors.get(i)).getValue();
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + accountTitle.getDisplayName() + ", \u91d1\u984d: " + Math.abs(amount.getValue()) + "}");
                    if (i + 1 >= debtors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("  \u8cb8\u65b9: [ ");
                for (i = 0; i < creditors.size(); ++i) {
                    accountTitle = (AccountTitle)((Map.Entry)creditors.get(i)).getKey();
                    amount = (Amount)((Map.Entry)creditors.get(i)).getValue();
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + accountTitle.getDisplayName() + ", \u91d1\u984d: " + Math.abs(amount.getValue()) + "}");
                    if (i + 1 >= creditors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
            }
        } else {
            list = new ArrayList<Map.Entry<AccountTitle, Amount>>(this.closingBalances.entrySet());
            Collections.sort(list, (o1, o2) -> accountTitles.indexOf(o1.getKey()) - accountTitles.indexOf(o2.getKey()));
            Iterator capital = list.iterator();
            while (capital.hasNext()) {
                Map.Entry e = (Map.Entry)capital.next();
                accountTitle = (AccountTitle)e.getKey();
                amount = (Amount)e.getValue();
                if (accountTitle.getType() == AccountType.Assets) {
                    if (amount.getValue() == 0L) continue;
                    if (amount.getValue() > 0L) {
                        debtors.add(e);
                        continue;
                    }
                    creditors.add(e);
                    continue;
                }
                if (accountTitle.getType() != AccountType.Liabilities && accountTitle.getType() != AccountType.Equity || amount.getValue() == 0L) continue;
                if (amount.getValue() > 0L) {
                    creditors.add(e);
                    continue;
                }
                debtors.add(e);
            }
            if (debtors.size() > 0 && creditors.size() > 0) {
                Amount amount2;
                AccountTitle accountTitle2;
                int i;
                sb.append("- \u65e5\u4ed8: " + nextOpeningDate + "\r\n");
                sb.append("  \u6458\u8981: \u524d\u671f\u7e70\u8d8a\r\n");
                sb.append("  \u501f\u65b9: [ ");
                for (i = 0; i < debtors.size(); ++i) {
                    accountTitle2 = (AccountTitle)((Map.Entry)debtors.get(i)).getKey();
                    amount2 = (Amount)((Map.Entry)debtors.get(i)).getValue();
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + accountTitle2.getDisplayName() + ", \u91d1\u984d: " + Math.abs(amount2.getValue()) + "}");
                    if (i + 1 >= debtors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("  \u8cb8\u65b9: [ ");
                for (i = 0; i < creditors.size(); ++i) {
                    accountTitle2 = (AccountTitle)((Map.Entry)creditors.get(i)).getKey();
                    amount2 = (Amount)((Map.Entry)creditors.get(i)).getValue();
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + accountTitle2.getDisplayName() + ", \u91d1\u984d: " + Math.abs(amount2.getValue()) + "}");
                    if (i + 1 >= creditors.size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
            }
        }
        block15: for (JournalEntry entry : this.journalEntries) {
            int i;
            if (entry.isClosing()) continue;
            for (Creditor creditor : entry.getCreditors()) {
                if (!creditor.getAccountTitle().getDisplayName().equals("\u671f\u672b\u5546\u54c1\u68da\u5378\u9ad8")) continue;
                sb.append("- \u65e5\u4ed8: " + nextOpeningDate + "\r\n");
                sb.append("  \u6458\u8981: \u671f\u9996\u68da\u5378\r\n");
                sb.append("  \u501f\u65b9: [ {\u52d8\u5b9a\u79d1\u76ee: \u671f\u9996\u5546\u54c1\u68da\u5378\u9ad8, \u91d1\u984d: " + creditor.getAmount() + "} ]\r\n");
                sb.append("  \u8cb8\u65b9: [ ");
                for (i = 0; i < entry.getDebtors().size(); ++i) {
                    Debtor debtor = entry.getDebtors().get(i);
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + debtor.getAccountTitle().getDisplayName() + ", \u91d1\u984d: " + debtor.getAmount() + "}");
                    if (i + 1 >= entry.getDebtors().size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
                break;
            }
            for (Debtor debtor : entry.getDebtors()) {
                if (!debtor.getAccountTitle().getDisplayName().equals("\u671f\u672b\u5546\u54c1\u68da\u5378\u9ad8")) continue;
                sb.append("- \u65e5\u4ed8: " + nextOpeningDate + "\r\n");
                sb.append("  \u6458\u8981: \u671f\u9996\u68da\u5378\r\n");
                sb.append("  \u501f\u65b9: [ ");
                for (i = 0; i < entry.getCreditors().size(); ++i) {
                    Creditor creditor = entry.getCreditors().get(i);
                    sb.append("{\u52d8\u5b9a\u79d1\u76ee: " + creditor.getAccountTitle().getDisplayName() + ", \u91d1\u984d: " + creditor.getAmount() + "}");
                    if (i + 1 >= entry.getCreditors().size()) continue;
                    sb.append(", ");
                }
                sb.append(" ]\r\n");
                sb.append("\r\n");
                continue block15;
            }
        }
        String s = sb.toString();
        if (path != null && Files.isDirectory(path.getParent(), new LinkOption[0])) {
            Path tmpFile = null;
            try {
                Path dir = path.getParent();
                tmpFile = dir.resolve("\u6b21\u5e74\u5ea6\u306e\u958b\u59cb\u4ed5\u8a33.tmp");
                Files.writeString(tmpFile, (CharSequence)s, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
                try {
                    Files.move(tmpFile, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tmpFile, path, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                if (tmpFile != null) {
                    try {
                        Files.deleteIfExists(tmpFile);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return s;
    }

    private static String formatMoney(long amount) {
        if (MINUS_SIGN != null && amount < 0L) {
            return MINUS_SIGN + String.format("%,d", -amount);
        }
        return String.format("%,d", amount);
    }

    private void dump(Node<Map.Entry<List<AccountTitle>, Amount[]>> node) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < node.getLevel(); ++i) {
            sb.append(" - ");
        }
        sb.append(node.getName());
        Amount[] amounts = node.getValue().getValue();
        sb.append("{ " + amounts[0] + ", " + amounts[1] + " } ");
        if (node.getValue().getKey() != null) {
            sb.append(": [");
            for (int i = 0; i < node.getValue().getKey().size(); ++i) {
                sb.append(node.getValue().getKey().get(i).getDisplayName());
                if (i + 1 >= node.getValue().getKey().size()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        System.out.println(sb.toString());
        for (Node<Map.Entry<List<AccountTitle>, Amount[]>> child : node.getChildren()) {
            this.dump(child);
        }
    }
}

