/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.chrono.JapaneseChronology;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.Node;
import net.osdn.aoiro.report.layout.StatementOfChangesInEquityLayout;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.PdfBrewer;

public class StatementOfChangesInEquity {
    public static String MINUS_SIGN = "\u25b3";
    private static final double HEADER_TITLE_WIDTH = 140.0;
    private static final double ROW_HEIGHT = 6.0;
    private StatementOfChangesInEquityLayout sceLayout;
    private List<JournalEntry> journalEntries;
    private LocalDate openingDate;
    private LocalDate closingDate;
    private Map<AccountTitle, Amount> openingBalances = new HashMap<AccountTitle, Amount>();
    private Map<AccountTitle, Amount> closingBalances = new HashMap<AccountTitle, Amount>();
    private Map<String, Map<AccountTitle, Amount>> changes = new LinkedHashMap<String, Map<AccountTitle, Amount>>();
    private int headerColumns;
    private int headerRows;
    private Map<Node<List<AccountTitle>>, Rectangle> headerRects = new LinkedHashMap<Node<List<AccountTitle>>, Rectangle>();
    private List<Node<Amount[]>> rows = new ArrayList<Node<Amount[]>>();
    private List<String> pageData = new ArrayList<String>();
    private List<String> printData;
    private FontLoader fontLoader;
    private boolean bindingMarginEnabled = true;

    public StatementOfChangesInEquity(StatementOfChangesInEquityLayout sceLayout, List<JournalEntry> journalEntries) throws IOException {
        Amount amount;
        String line;
        this.sceLayout = sceLayout;
        this.journalEntries = journalEntries;
        this.openingDate = AccountSettlement.getOpeningDate(journalEntries, false);
        this.closingDate = AccountSettlement.getClosingDate(journalEntries, false);
        InputStream in = this.getClass().getResourceAsStream("/templates/\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8.pb");
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = r.readLine()) != null) {
            this.pageData.add(line);
        }
        r.close();
        for (JournalEntry journalEntry : journalEntries) {
            Map<AccountTitle, Amount> map;
            Amount amount2;
            if (journalEntry.isOpening(false, this.openingDate)) {
                for (Debtor debtor : journalEntry.getDebtors()) {
                    if (debtor.getAccountTitle().getType() != AccountType.Equity) continue;
                    Amount amount22 = this.openingBalances.get(debtor.getAccountTitle());
                    if (amount22 == null) {
                        amount22 = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.openingBalances.put(debtor.getAccountTitle(), amount22);
                    }
                    if (debtor.getAccountTitle().getType().getNormalBalance() == Debtor.class) {
                        amount22.increase(debtor.getAmount());
                        continue;
                    }
                    amount22.decrease(debtor.getAmount());
                }
                for (Creditor creditor : journalEntry.getCreditors()) {
                    if (creditor.getAccountTitle().getType() != AccountType.Equity) continue;
                    amount2 = this.openingBalances.get(creditor.getAccountTitle());
                    if (amount2 == null) {
                        amount2 = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.openingBalances.put(creditor.getAccountTitle(), amount2);
                    }
                    if (creditor.getAccountTitle().getType().getNormalBalance() == Creditor.class) {
                        amount2.increase(creditor.getAmount());
                        continue;
                    }
                    amount2.decrease(creditor.getAmount());
                }
                continue;
            }
            if (journalEntry.isBalance()) {
                for (Debtor debtor : journalEntry.getDebtors()) {
                    if (debtor.getAccountTitle().getType() != AccountType.Equity) continue;
                    amount2 = this.closingBalances.get(debtor.getAccountTitle());
                    if (amount2 == null) {
                        amount2 = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.closingBalances.put(debtor.getAccountTitle(), amount2);
                    }
                    if (debtor.getAccountTitle().getType().getNormalBalance() != Debtor.class) {
                        amount2.increase(debtor.getAmount());
                        continue;
                    }
                    amount2.decrease(debtor.getAmount());
                }
                for (Creditor creditor : journalEntry.getCreditors()) {
                    if (creditor.getAccountTitle().getType() != AccountType.Equity) continue;
                    amount2 = this.closingBalances.get(creditor.getAccountTitle());
                    if (amount2 == null) {
                        amount2 = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                        this.closingBalances.put(creditor.getAccountTitle(), amount2);
                    }
                    if (creditor.getAccountTitle().getType().getNormalBalance() != Creditor.class) {
                        amount2.increase(creditor.getAmount());
                        continue;
                    }
                    amount2.decrease(creditor.getAmount());
                }
                continue;
            }
            for (Debtor debtor : journalEntry.getDebtors()) {
                if (debtor.getAccountTitle().getType() != AccountType.Equity) continue;
                map = this.changes.get(journalEntry.getDescription());
                if (map == null) {
                    map = new HashMap<AccountTitle, Amount>();
                    this.changes.put(journalEntry.getDescription(), map);
                }
                if ((amount = map.get(debtor.getAccountTitle())) == null) {
                    amount = new Amount(debtor.getAccountTitle().getType().getNormalBalance(), 0L);
                    map.put(debtor.getAccountTitle(), amount);
                }
                if (debtor.getAccountTitle().getType().getNormalBalance() == Debtor.class) {
                    amount.increase(debtor.getAmount());
                    continue;
                }
                amount.decrease(debtor.getAmount());
            }
            for (Creditor creditor : journalEntry.getCreditors()) {
                if (creditor.getAccountTitle().getType() != AccountType.Equity) continue;
                map = this.changes.get(journalEntry.getDescription());
                if (map == null) {
                    map = new HashMap<AccountTitle, Amount>();
                    this.changes.put(journalEntry.getDescription(), map);
                }
                if ((amount = map.get(creditor.getAccountTitle())) == null) {
                    amount = new Amount(creditor.getAccountTitle().getType().getNormalBalance(), 0L);
                    map.put(creditor.getAccountTitle(), amount);
                }
                if (creditor.getAccountTitle().getType().getNormalBalance() == Creditor.class) {
                    amount.increase(creditor.getAmount());
                    continue;
                }
                amount.decrease(creditor.getAmount());
            }
        }
        HashSet<String> descriptions = new HashSet<String>();
        for (List<String> list : sceLayout.getReasons().values()) {
            if (list == null) continue;
            for (String s : list) {
                descriptions.add(s);
            }
        }
        for (String string : this.changes.keySet()) {
            if (descriptions.contains(string)) continue;
            sceLayout.getReasons().put(string, Arrays.asList(string));
        }
        this.calculateHeaderRects(sceLayout.getRoot());
        Node<Amount[]> openingRow = new Node<Amount[]>(0, "\u5f53\u671f\u9996\u6b8b\u9ad8");
        openingRow.setValue(new Amount[this.headerColumns]);
        this.rows.add(openingRow);
        for (Map.Entry<AccountTitle, Amount> entry : this.openingBalances.entrySet()) {
            for (int columnIndex : this.getColumnIndexes(entry.getKey())) {
                amount = ((Amount[])openingRow.getValue())[columnIndex];
                if (amount == null) {
                    ((Amount[])openingRow.getValue())[columnIndex] = amount = new Amount(Creditor.class, 0L);
                }
                amount.increase(entry.getValue());
            }
        }
        Node<Amount[]> node = new Node<Amount[]>(0, "\u5f53\u671f\u5909\u52d5\u984d\u5408\u8a08");
        node.setValue(new Amount[this.headerColumns]);
        this.rows.add(node);
        for (Map.Entry<String, List<String>> entry : sceLayout.getReasons().entrySet()) {
            Node<Amount[]> changeRow = new Node<Amount[]>(1, "\u3000" + entry.getKey());
            changeRow.setValue(new Amount[this.headerColumns]);
            this.rows.add(changeRow);
            if (entry.getValue() == null) continue;
            for (String description : entry.getValue()) {
                Map<AccountTitle, Amount> map = this.changes.get(description);
                if (map == null) continue;
                for (Map.Entry<AccountTitle, Amount> ex : map.entrySet()) {
                    for (int columnIndex : this.getColumnIndexes(ex.getKey())) {
                        Amount amount3 = ((Amount[])changeRow.getValue())[columnIndex];
                        if (amount3 == null) {
                            ((Amount[])changeRow.getValue())[columnIndex] = amount3 = new Amount(Creditor.class, 0L);
                        }
                        amount3.increase(ex.getValue());
                        Amount amount4 = ((Amount[])node.getValue())[columnIndex];
                        if (amount4 == null) {
                            ((Amount[])node.getValue())[columnIndex] = amount4 = new Amount(Creditor.class, 0L);
                        }
                        amount4.increase(ex.getValue());
                    }
                }
            }
        }
        Node<Amount[]> node2 = new Node<Amount[]>(0, "\u5f53\u671f\u672b\u6b8b\u9ad8");
        node2.setValue(new Amount[this.headerColumns]);
        this.rows.add(node2);
        for (Map.Entry<AccountTitle, Amount> e : this.closingBalances.entrySet()) {
            Iterator<Object> iterator = this.getColumnIndexes(e.getKey()).iterator();
            while (iterator.hasNext()) {
                int columnIndex = (Integer)iterator.next();
                Amount amount4 = ((Amount[])node2.getValue())[columnIndex];
                if (amount4 == null) {
                    ((Amount[])node2.getValue())[columnIndex] = amount4 = new Amount(Creditor.class, 0L);
                }
                amount4.increase(e.getValue());
            }
        }
    }

    public List<JournalEntry> getJournalEntries() {
        return this.journalEntries;
    }

    protected List<Integer> getColumnIndexes(AccountTitle accountTitle) {
        ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
        for (Map.Entry<Node<List<AccountTitle>>, Rectangle> e : this.headerRects.entrySet()) {
            for (AccountTitle title : e.getKey().getValue()) {
                if (!title.equals(accountTitle)) continue;
                columnIndexes.add(e.getValue().columnIndex);
            }
        }
        return columnIndexes;
    }

    private void calculateHeaderRects(Node<List<AccountTitle>> ceRoot) {
        this.headerColumns = this.getHeaderColumns(ceRoot);
        this.headerRows = this.getHeaderRows(ceRoot);
        this.retrieveHeaderRects(this.headerColumns, this.headerRows, ceRoot, 0);
        ArrayList<Map.Entry<Node<List<AccountTitle>>, Rectangle>> entries = new ArrayList<Map.Entry<Node<List<AccountTitle>>, Rectangle>>(this.headerRects.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<Node<List<AccountTitle>>, Rectangle>>(){

            @Override
            public int compare(Map.Entry<Node<List<AccountTitle>>, Rectangle> o1, Map.Entry<Node<List<AccountTitle>>, Rectangle> o2) {
                int diffColumnIndex = o1.getValue().columnIndex - o2.getValue().columnIndex;
                if (diffColumnIndex == 0) {
                    return o1.getKey().getLevel() - o2.getKey().getLevel();
                }
                return diffColumnIndex;
            }
        });
        this.headerRects.clear();
        for (Map.Entry entry : entries) {
            this.headerRects.put((Node)entry.getKey(), (Rectangle)entry.getValue());
        }
    }

    private int getHeaderColumns(Node<List<AccountTitle>> node) {
        if (node.getChildren().isEmpty()) {
            return 1;
        }
        int columns = 0;
        for (Node<List<AccountTitle>> child : node.getChildren()) {
            columns += this.getHeaderColumns(child);
        }
        return columns;
    }

    private int getHeaderRows(Node<List<AccountTitle>> node) {
        if (node.getChildren().isEmpty()) {
            int lines = StatementOfChangesInEquity.getLines(node.getName());
            int level = node.getLevel();
            return lines + level - 1;
        }
        int maxRows = 0;
        for (Node<List<AccountTitle>> child : node.getChildren()) {
            int rows = this.getHeaderRows(child);
            if (rows <= maxRows) continue;
            maxRows = rows;
        }
        return maxRows;
    }

    private int retrieveHeaderRects(int headerColumns, int headerRows, Node<List<AccountTitle>> node, int left) {
        int width = 0;
        if (node.getChildren().isEmpty()) {
            width = 1;
        } else {
            for (Node<List<AccountTitle>> child : node.getChildren()) {
                width += this.retrieveHeaderRects(headerColumns, headerRows, child, left + width);
            }
        }
        if (node.getLevel() > 0) {
            Rectangle rect = new Rectangle();
            rect.columnIndex = left;
            rect.x = 140.0 * (double)left / (double)headerColumns;
            rect.y = 6.0 * (double)(node.getLevel() - 1);
            rect.width = 140.0 * (double)width / (double)headerColumns;
            rect.height = node.getChildren().isEmpty() ? 6.0 * (double)headerRows - rect.y : 6.0;
            this.headerRects.put(node, rect);
        }
        return width;
    }

    private static int getLines(String s) {
        int i;
        int lines = 1;
        int fromIndex = 0;
        while ((i = s.indexOf(10, fromIndex)) >= 0) {
            ++lines;
            fromIndex = i + 1;
        }
        return lines;
    }

    protected void prepare() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("GGGG y \u5e74 M \u6708 d \u65e5").withChronology(JapaneseChronology.INSTANCE);
        String openingDate = dtf.format(this.openingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        String closingDate = dtf.format(this.closingDate).replace(" 1 \u5e74", "\u5143\u5e74");
        this.printData = new ArrayList<String>();
        if (this.bindingMarginEnabled) {
            this.printData.add("\\media A4");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 148.5 5 148.5");
            this.printData.add("\\box 15 0 0 0");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 0 0 -0");
            this.printData.add("\\box 25 0 -10 -10");
        } else {
            this.printData.add("\\media 195 297");
            this.printData.add("\\box 10 0 -10 -10");
        }
        this.printData.addAll(this.pageData);
        this.printData.add("\t\\box 0 16 -0 7");
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center");
        this.printData.add("\t\t\\text " + openingDate + " \uff5e " + closingDate);
        this.printData.add("\t\\box 0 0 -0 -0");
        this.printData.add("\t\t\\line-style thin solid");
        double y = 25.2 + (double)this.headerRows * 6.0;
        this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y, y));
        this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y += 6.0, y));
        this.printData.add("\t\t\\line-style thin dot");
        for (int i = 0; i < this.sceLayout.getReasons().keySet().size(); ++i) {
            this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y += 6.0, y));
        }
        this.printData.add("\t\t\\line-style thin solid");
        this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y += 6.0, y));
        this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y += 6.0, y));
        this.printData.add("\t\t\\line " + String.format("0 %.2f -0 %.2f", y + 0.4, y + 0.4));
        this.printData.add("\t\\box " + String.format("35.0 25.2 %.2f %.2f", 140.0, y - 25.2));
        HashSet<Double> lineX = new HashSet<Double>();
        for (Map.Entry<Node<List<AccountTitle>>, Rectangle> entry : this.headerRects.entrySet()) {
            Rectangle rect = entry.getValue();
            Node<List<AccountTitle>> node = entry.getKey();
            this.printData.add("\t\t\\box " + String.format("%.2f %.2f %.2f %.2f", rect.x, rect.y, rect.width, rect.height));
            if (node.getChildren().size() > 0 && node.getName().length() > 7) {
                this.printData.add("\t\t\t\\font serif 7");
            } else {
                this.printData.add("\t\t\t\\font serif 8");
            }
            this.printData.add("\t\t\t\\text " + node.getName());
            this.printData.add("\t\t\t\\line " + String.format("0 %.2f -0 %.2f", rect.height, rect.height));
            if (lineX.contains(rect.x)) continue;
            this.printData.add("\t\t\\box " + String.format("%.2f %.2f %.2f -0", rect.x, rect.y, rect.width));
            this.printData.add("\t\t\t\\line 0 0 0 -0");
            lineX.add(rect.x);
        }
        y = 25.2 + (double)this.headerRows * 6.0;
        for (Node node : this.rows) {
            this.printData.add("\t\\box " + String.format("0 %.2f -0 -0", y));
            this.printData.add("\t\t\\font serif 10" + (node.getLevel() == 0 ? " bold" : ""));
            this.printData.add("\t\t\\align center left");
            this.printData.add("\t\t\\box " + String.format("2 0 33.0 %.2f", 6.0));
            this.printData.add("\t\t\t\\text " + node.getName());
            this.printData.add("\t\t\\align center right");
            Amount[] amounts = (Amount[])node.getValue();
            for (int i = 0; i < amounts.length; ++i) {
                if (amounts[i] == null) continue;
                double x = 35.0 + 140.0 * (double)i / (double)amounts.length;
                double w = 140.0 / (double)amounts.length - 2.0;
                this.printData.add("\t\t\\box " + String.format("%.2f 0 %.2f %.2f", x, w, 6.0));
                this.printData.add("\t\t\t\\text " + StatementOfChangesInEquity.formatMoney(amounts[i].getValue()));
            }
            y += 6.0;
        }
    }

    public void setFontLoader(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    public void setBindingMarginEnabled(boolean enabled) {
        this.bindingMarginEnabled = enabled;
    }

    public void writeTo(Path path) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8");
        brewer.process(pb);
        brewer.save(path);
        brewer.close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8");
        brewer.process(pb);
        brewer.save(out);
        brewer.close();
    }

    private static String formatMoney(long amount) {
        if (MINUS_SIGN != null && amount < 0L) {
            return MINUS_SIGN + String.format("%,d", -amount);
        }
        return String.format("%,d", amount);
    }

    private class Rectangle {
        public int columnIndex;
        public double x;
        public double y;
        public double width;
        public double height;

        private Rectangle() {
        }
    }
}

