/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report.layout;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Node;

public class StatementOfChangesInEquityLayout {
    private Node<List<AccountTitle>> root = new Node(0, "\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8");
    private Map<String, List<String>> reasons = new LinkedHashMap<String, List<String>>();

    public Node<List<AccountTitle>> getRoot() {
        return this.root;
    }

    public Map<String, List<String>> getReasons() {
        return this.reasons;
    }

    public String getYaml() {
        return this.getYaml(null);
    }

    public String getYaml(Set<AccountTitle> filter) {
        if (this.getRoot().getChildren().size() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append("\"\u793e\u54e1\u8cc7\u672c\u7b49\u5909\u52d5\u8a08\u7b97\u66f8\" :\r\n");
        out.append("  \"\u5909\u52d5\u4e8b\u7531\" :\r\n");
        for (Map.Entry<String, List<String>> entry : this.getReasons().entrySet()) {
            String name = entry.getKey();
            List<String> list = entry.getValue();
            out.append("    ");
            out.append("\"");
            out.append(YamlBeansUtil.escape(name));
            out.append("\" :");
            if (list != null && list.size() > 0) {
                out.append(" [");
                for (int i = 0; i < list.size(); ++i) {
                    out.append("\"");
                    out.append(YamlBeansUtil.escape(list.get(i)));
                    out.append("\"");
                    if (i + 1 >= list.size()) continue;
                    out.append(", ");
                }
                out.append("]");
            }
            out.append("\r\n");
        }
        for (Node node : this.getRoot().getChildren()) {
            this.retrieve(out, node, filter);
        }
        out.append("\r\n\r\n");
        return out.toString();
    }

    private void retrieve(StringBuilder out, Node<List<AccountTitle>> node, Set<AccountTitle> filter) {
        List<AccountTitle> accountTitles = node.getValue();
        if (filter != null) {
            ArrayList<AccountTitle> tmp = new ArrayList<AccountTitle>();
            for (AccountTitle accountTitle : accountTitles) {
                if (!filter.contains(accountTitle)) continue;
                tmp.add(accountTitle);
            }
            accountTitles = tmp;
        }
        String indent = "  ".repeat(node.getLevel() + 0);
        out.append(indent);
        out.append("\"");
        out.append(YamlBeansUtil.escape(node.getName()));
        out.append("\" :");
        if (accountTitles.size() > 0) {
            out.append(" [ ");
            for (int i = 0; i < accountTitles.size(); ++i) {
                out.append("\"");
                out.append(YamlBeansUtil.escape(accountTitles.get(i).getDisplayName()));
                out.append("\"");
                if (i + 1 >= accountTitles.size()) continue;
                out.append(", ");
            }
            out.append(" ]");
        }
        out.append("\r\n");
        if (accountTitles.size() == 0) {
            for (Node node2 : node.getChildren()) {
                this.retrieve(out, node2, filter);
            }
        }
    }
}

