# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
from node import AoisoNode
import elementtree.ElementTree as ET

class AoisoLogic:
    
    def __init__(self,model):
        self.model = model
    
    def resetNode(self,iter):
        node = AoisoNode("NonTitled","")
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)

    def addchild2dom(self,p_element,p_iter):
        i=0
        while i <= self.model.iter_n_children(p_iter)-1:
            iter = self.model.iter_nth_child(p_iter,i)
            self.add2dom(p_element,iter)
            i+=1

    def add2dom(self,p_element,iter):
        node = self.model.get_value(iter,1)
        item_element = ET.SubElement(p_element,"item")
        element = ET.SubElement(item_element,"text-h")
        element.text = node.title
        for str in node.text.split():
            element = ET.SubElement(item_element,"text-p")
            element.text = str
        self.addchild2dom(item_element,iter)        
    
    def saveDocument(self):
        print "saveDocument"
        
        root = ET.Element("document")
        head = ET.SubElement(root,"head")
        docprop = ET.SubElement(head,"document-property")
        docprop.set("date","yyyymmdd")
        body = ET.SubElement(root,"body")

        iter = self.model.get_iter_root()
        self.add2dom(body,iter)
        iter = self.model.iter_next(iter)
        while iter :
            self.add2dom(body,iter)
            iter = self.model.iter_next(iter)

        tree = ET.ElementTree(root)

        encode = 'UTF-8'
        fd = file('test.xml', 'wb')
        tree.write(fd, encode)
        fd.close()
        
    def openDocument(self):
        print "openDocument"

        fd = file('test.xml', 'rb')
        dom = ET.ElementTree(file=fd)

        self.model.clear()
        
        document = dom.getroot()
        head = ET.SubElement(document,"head")
        body = ET.SubElement(document,"body")
        items = dom.findall("//body/item")
        for item in items:
            self.domNode2TreeNode(item,None)

    def domNode2TreeNode(self,p_item,p_iter):
        iter = self.model.append(p_iter)
        text_h = p_item.find("text-h").text
        text_p = ""
        for element in p_item.getchildren():
            if element.tag =="text-p":
                text_p += element.text + "\r\n"
        node = AoisoNode(text_h,text_p)
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)
        elements = p_item.getchildren()
        for element in elements:
            if element.tag == "item":
                self.domNode2TreeNode(element,iter)

    def makeDummy(self):
        #DummyData
        iter = self.model.append(None)
        node = AoisoNode("aaa","bbb")
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)
        iter = self.model.append(iter)
        node = AoisoNode("ccc","d\ndd")
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)
        iter = self.model.append(None)
        node = AoisoNode("eee","fff")
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)
        iter = self.model.append(iter)
        node = AoisoNode("ggg","hhh")
        self.model.set_value(iter,0,node.title)
        self.model.set_value(iter,1,node)

    def store_node_text(self,iter,text):
        node = self.model.get_value(iter,1)
        node.text = text

    def store_node_title(self,iter,title):
        node = self.model.get_value(iter,1)
        node.title = title
        self.model.set_value(iter,0,title)
