
# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import gtk.glade
import pygtk
import gobject
    
from logic import AoisoLogic


drop_yes = ("drop_yes", gtk.TARGET_SAME_WIDGET, 0)
drop_no = ("drop_no", gtk.TARGET_SAME_WIDGET, 0)


class AoisoMainWindow:
    """This is an Aoiso application"""

    TARGETS = [
        ('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_WIDGET, 0),
        ('text/plain', 0, 1),
        ('TEXT', 0, 2),
        ('STRING', 0, 3),
        ]
    
    def __init__(self):

        #Set the Glade file
        self.gladefile = "aoisora.glade" 
        self.wTree = gtk.glade.XML(self.gladefile)
        
        #Get the Main Window, and connect the "destroy" event
        self.window = self.wTree.get_widget("AoisoMainWindow")
        if (self.window):
            self.window.connect("destroy", gtk.main_quit)

        #Get Glade widgets
        self.treeView = self.wTree.get_widget("treeviewAoisoMain")
        self.editor   = self.wTree.get_widget("textviewAoisoMain")

        self.title_entry = self.wTree.get_widget("entryNodeTitle")
        
        #TreeModel
        self.model = gtk.TreeStore(gobject.TYPE_STRING,gobject.TYPE_PYOBJECT)
        column = gtk.TreeViewColumn("aaa",gtk.CellRendererText(),text=0)
        self.treeView.append_column(column)
        self.treeView.set_model(self.model)

        self.current_iter = None

        #DnD
        """self.treeView.enable_model_drag_source( gtk.gdk.BUTTON1_MASK,
                                                self.TARGETS,
                                                gtk.gdk.ACTION_DEFAULT|
                                                gtk.gdk.ACTION_MOVE)
        self.treeView.enable_model_drag_dest(self.TARGETS,
                                             gtk.gdk.ACTION_DEFAULT)"""

        self.treeView.enable_model_drag_source( gtk.gdk.BUTTON1_MASK, [drop_yes], gtk.gdk.ACTION_MOVE)
        self.treeView.enable_model_drag_dest( [drop_yes], gtk.gdk.ACTION_MOVE)
                
        
        #self.treeView.connect("drag_data_get", self.on_drag_data_get)
        self.treeView.connect("drag_data_received", self.on_drag_data_received)
        self.treeView.connect("drag_motion", self.on_drag_motion)
        
        #LogicClass
        self.logic = AoisoLogic(self.model)

        #DummyData
        self.logic.makeDummy()
        
        #Create our dictionay and connect it
        dic = { "on_treeview4_cursor_changed"  : self.showSelectedItem
                ,"on_button2_clicked"          : self.newDocument
                ,"on_mitemAppendNode_activate" : self.appendNode
                ,"on_tbtnAppendNode_clicked"   : self.appendNode
                ,"on_mitemAppendChildNode_activate" : self.appendChildNode
                ,"on_tbtnAppendChildNode_clicked"   : self.appendChildNode
                ,"on_tbtnSave_clicked" : self.saveDocument
                ,"on_tbtnOpen_clicked" : self.openDocument
                ,"on_tbtnNodeLeft_clicked" : self.moveNodeLeft
                ,"on_tbtnNodeRight_clicked" : self.moveNodeRight
                ,"on_tbtnNodeUp_clicked" : self.moveNodeUp
                ,"on_tbtnNodeDown_clicked" : self.moveNodeDown
                ,"on_tbtnTrashNode_clicked" : self.moveNodeTrash
                ,"on_btnTest1_clicked" : self.test1
                ,"on_btnTest2_clicked" : self.test2
                }
        self.wTree.signal_autoconnect(dic)
        self.editor.connect("event-after",self.on_editor_changed)
        self.title_entry.connect("event-after",self.on_title_entry_changed)
        
        self.treeView.set_cursor(0)

    def test1(self,widget):
        print "test1"
        self.logic.openWZText()
        self.treeView.set_cursor(0)
        
    def test2(self,widget):
        print "test2"
        self.logic.saveWZText()

    def on_editor_changed(self,widget,event):
        #print "on_editor_changed"
        if self.current_iter==None:
            return None
        buffer = self.editor.get_buffer() 
        text = buffer.get_text(buffer.get_start_iter(),buffer.get_end_iter())
        self.logic.store_node_text(self.current_iter,text)

    def on_title_entry_changed(self,widget,event):
        #print "on_title_editor_changed"
        if self.current_iter==None:
            return None
        title = self.title_entry.get_text()
        self.logic.store_node_title(self.current_iter,title)
        
    def newDocument(self, widget):
        print "clicked!"
        self.logic.clearDocument()
        self.treeView.set_cursor(0)
        
    def showSelectedItem(self, widget):
        #print "selected!"
        model,iter = self.treeView.get_selection().get_selected()
        self.current_iter = iter
        node = model.get_value(iter,1)
        self.editor.get_buffer().set_text(node.text)
        self.title_entry.set_text(node.title)

    def appendNode(self,widget):
        print "appendNode"
        iter = self.model.insert_after(self.model.iter_parent(self.current_iter)
                                       ,self.current_iter)
        self.logic.resetNode(iter)
        self.treeView.expand_to_path(self.model.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.showSelectedItem(widget)
        
    def appendChildNode(self,widget):
        print "appendChildNode"
        iter = self.model.append(self.current_iter)
        self.logic.resetNode(iter)
        self.treeView.expand_to_path(self.model.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.showSelectedItem(widget)        
        
    def saveDocument(self,widget):
        self.logic.saveDocument()
        
    def openDocument(self,weight):
        self.logic.openDocument()
        self.treeView.set_cursor(0)
        
    def moveNodeLeft(self,widget):
        print "moveNodeLeft"

    def moveNodeRight(self,widget):
        print "moveNodeRight"

    def moveNodeUp(self,widget):
        print "moveNodeUp"

    def moveNodeDown(self,widget):
        print "moveNodeDown"

    def moveNodeTrash(self,widget):
        print "moveNodeTrash"

    def _moveNodeBefore(self,src_iter,dest_iter):
        print "moveNodeBefore"
        node = self.model.get_value(src_iter,1)
        new_iter = self.model.insert_before(self.model.iter_parent(dest_iter), dest_iter)
        self.model.set_value(new_iter,0,node.title)
        self.model.set_value(new_iter,1,node)
        i = 0
        while i <= self.model.iter_n_children(src_iter) - 1:
            iter = self.model.iter_nth_child(src_iter,i)
            self._moveNodeToChild(iter,new_iter)
            i += 1

    def _moveNodeAfter(self,src_iter,dest_iter):
        print "moveNodeAfter"
        node = self.model.get_value(src_iter,1)
        new_iter = self.model.insert_after(self.model.iter_parent(dest_iter), dest_iter)
        self.model.set_value(new_iter,0,node.title)
        self.model.set_value(new_iter,1,node)
        i = 0
        while i <= self.model.iter_n_children(src_iter) - 1:
            iter = self.model.iter_nth_child(src_iter,i)
            self._moveNodeToChild(iter,new_iter)
            i += 1

    def _moveNodeToChild(self,src_iter,dest_iter):
        print "moveNodeChild"
        node = self.model.get_value(src_iter,1)
        new_iter = self.model.append(dest_iter)
        self.model.set_value(new_iter,0,node.title)
        self.model.set_value(new_iter,1,node)
        i = 0
        while i <= self.model.iter_n_children(src_iter) - 1:
            iter = self.model.iter_nth_child(src_iter,i)
            self._moveNodeToChild(iter,new_iter)
            i += 1
    
    def on_drag_data_get(self, treeView, context, selection, target_id, etime):
        print "aaa"
        treeselection = treeView.get_selection()
        model, iter = treeselection.get_selected()
        data = model.get_value(iter, 0)
        selection.set(selection.target, 8, data)

    def on_drag_data_received(self, treeView, context, x, y, selection, info, etime):
        print "bbb"
        model,src_iter = treeView.get_selection().get_selected()
        node = self.model.get_value(src_iter,1)
        drop_info = treeView.get_dest_row_at_pos(x, y)
        if drop_info:
            print "drop_info"
            dest_path,dest_position = drop_info
            print dest_position
            dest_iter = self.model.get_iter(dest_path)
            #self.current_iter = src_iter
            if (dest_position == gtk.TREE_VIEW_DROP_BEFORE):
                self._moveNodeBefore(src_iter,dest_iter)
            elif (dest_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE) or (dest_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER):
                self._moveNodeToChild(src_iter,dest_iter)
            elif (dest_position == gtk.TREE_VIEW_DROP_AFTER):
                self._moveNodeAfter(src_iter,dest_iter)
        else:
            print "else"
            self._moveNodeToChild(src_iter,dest_iter)
        
        if context.action == gtk.gdk.ACTION_MOVE:
            context.finish(True, True, etime)
        return

    def checkSanity(self, model, source, target):
        source_path = model.get_path(source)
        target_path = model.get_path(target)
        if target_path[0:len(source_path)] == source_path:
            print "Sanity_False"
            return False
        else:
            print "Sanity_True"
            return True

    def checkParentability(self, model, target, drop_position):
        if (drop_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE
            or drop_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER):
            print "Parentability_False"
            return False
        else:
            return True                                                                       


    def on_drag_motion(self, treeview, drag_context, x, y, eventtime):
        try:
            target_path, drop_position = treeview.get_dest_row_at_pos(x, y)
            model, source = treeview.get_selection().get_selected()
            target = model.get_iter(target_path)
        except:
            return
        is_sane = self.checkSanity(model, source, target)
        is_parentable =  True #self.checkParentability(model, target, drop_position)
        if is_sane and is_parentable:
            treeview.enable_model_drag_dest([drop_yes], gtk.gdk.ACTION_MOVE)
        else:
            treeview.enable_model_drag_dest([drop_no], gtk.gdk.ACTION_MOVE)
