# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import pygtk
import gobject

from node import AoisoNode
from aoisoConsts import AoisoConsts as c

class AoisoTreeStore(gtk.TreeStore):

    def __init__(self, widget, *args):
        gtk.TreeStore.__init__(self, *args)
        self.widget = widget

    def __get_icon_pixbuf(self, iter):
        if self.iter_parent(iter)==None:
            stock_icon = gtk.STOCK_DIRECTORY
        else:
            stock_icon = gtk.STOCK_DND
        return self.widget.render_icon(stock_icon,size=gtk.ICON_SIZE_MENU,detail=None)

    #override 一応作っておく
    def set_value(self, iter, column, value):
        gtk.TreeStore.set_value(self, iter, column, value)

    def __reset_icon(self, iter):
        self.set_value(iter, c.COL_ICON, self.__get_icon_pixbuf(iter))

    #override
    def insert(self, parent, position, row=None):
        iter = gtk.TreeStore.insert(parent, position, row)
        self.__reset_icon(iter)
        return iter
    
    #override
    def insert_before(self, parent, sibling, row=None):
        iter = gtk.TreeStore.insert_before(self, parent, sibling, row=None)
        self.__reset_icon(iter)
        return iter

    #override
    def insert_after(self, parent, sibling, row=None):
        iter = gtk.TreeStore.insert_after(self, parent, sibling, row=None)
        self.__reset_icon(iter)
        return iter

    #override
    def append(self, parent, row=None):
        iter = gtk.TreeStore.append(self, parent, row)
        self.__reset_icon(iter)
        return iter

    #override
    def move_after(self, iter, position):
        gtk.TreeStore.move_after(iter, position)
        self.__reset_icon(iter)

    #override
    def move_before(self, iter, position):
        gtk.TreeStore.move_before(iter, position)
        self.__reset_icon(iter)

    def setNode(self, iter, node):
        self.set_value(iter, c.COL_ICON, self.__get_icon_pixbuf(iter))
        self.set_value(iter, c.COL_TEXT, node.title)
        self.set_value(iter, c.COL_OBJECT, node)

    def resetNode(self, iter):
        node = AoisoNode("NonTitled","")
        self.setNode(iter, node)

