# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import wx
import wx.xrc as xrc

from aoiso.wx.aoisoWxTreeCtrl import AoisoWxTreeCtrl

class AoisoWxMainFrame(wx.Frame):

    def __init__(self, app, parent=None):
        self.app = app
        pre = wx.PreFrame()
        app.res.LoadOnFrame(pre, parent, "ID_MAIN_FRAME")
        self.PostCreate(pre)
        self.__setEventHandler()
        self.SetSize((700,500))
        self.SetPosition((200,200))
        
        panel = xrc.XRCCTRL(self, "ID_TREE_PANEL")
        self.treeCtrl = AoisoWxTreeCtrl(panel)
        self.treeView = self.treeCtrl # for Gtk Compatiblity
        app.res.AttachUnknownControl("ID_TREE_CTRL", self.treeCtrl, panel)
        panel.Fit()

        self.titleEntry = xrc.XRCCTRL(self,"ID_TITLE_ENTRY")
        self.editor = xrc.XRCCTRL(self,"ID_EDITOR")

    def __setEventHandler(self):
        #Menu
        self.Bind(wx.EVT_MENU, self.onFileNewClick,     id=xrc.XRCID("ID_FILE_NEW"))
        self.Bind(wx.EVT_MENU, self.onFileOpenClick,    id=xrc.XRCID("ID_FILE_OPEN"))
        self.Bind(wx.EVT_MENU, self.onFileSaveClick,    id=xrc.XRCID("ID_FILE_SAVE"))
        self.Bind(wx.EVT_MENU, self.onFileSaveAsClick,  id=xrc.XRCID("ID_FILE_SAVE_AS"))
        self.Bind(wx.EVT_MENU, self.onFileOpenTxtClick, id=xrc.XRCID("ID_FILE_OPEN_TXT"))
        self.Bind(wx.EVT_MENU, self.onFileSaveTxtClick, id=xrc.XRCID("ID_FILE_SAVE_TXT"))
        self.Bind(wx.EVT_MENU, self.onNodeLeftClick,    id=xrc.XRCID("ID_NODE_LEFT"))
        self.Bind(wx.EVT_MENU, self.onNodeRightClick,   id=xrc.XRCID("ID_NODE_RIGHT"))
        self.Bind(wx.EVT_MENU, self.onNodeUpClick,      id=xrc.XRCID("ID_NODE_UP"))
        self.Bind(wx.EVT_MENU, self.onNodeDownClick,    id=xrc.XRCID("ID_NODE_DOWN"))
        self.Bind(wx.EVT_MENU, self.onNodeAddClick,     id=xrc.XRCID("ID_NODE_ADD"))
        self.Bind(wx.EVT_MENU, self.onNodeAddChildClick,  id=xrc.XRCID("ID_NODE_ADD_CHILD"))
        #Editor
        self.Bind(wx.EVT_TEXT, self.onTitleEntryChanged, id=xrc.XRCID("ID_TITLE_ENTRY"))
        self.Bind(wx.EVT_TEXT, self.onEditorChanged, id=xrc.XRCID("ID_EDITOR"))
        
    def onFileNewClick(self, event):
        print "file_new"

    def onFileOpenClick(self, event):
        print "file_open"
        self.app.logic.openDocument()

    def onFileSaveClick(self, event):
        print "file_save"
        self.app.logic.saveDocument()

    def onFileSaveAsClick(self, event):
        print "file_save_as"

    def onFileOpenTxtClick(self, event):
        print "file_open_txt"
        self.app.logic.openWZText()
        
    def onFileSaveTxtClick(self, event):
        print "file_save_txt"
        self.app.logic.saveWZText()

    def onNodeLeftClick(self, event):
        print "node_left"

    def onNodeRightClick(self, event):
        print "node_right"

    def onNodeUpClick(self, event):
        print "node_up"

    def onNodeDownClick(self, event):
        print "node_down"
        
    def onNodeAddClick(self, event):
        print "node_add"
        self.app.logic.appendNode(self)

    def onNodeAddChildClick(self, event):
        print "node_add_child"
        self.app.logic.appendChildNode(self)

    def onTitleEntryChanged(self, event):
        self.app.model.storeNodeTitle(self.titleEntry.GetValue())
    
    def onEditorChanged(self, event):
        self.app.model.storeNodeText(self.editor.GetValue())

